/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import javax.swing.UIManager;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerGrid
extends Layer {
    private static final long serialVersionUID = 4363123625161512763L;
    private int _spacing = 16;
    private boolean _paintLines = false;
    private boolean _paintDots = true;
    private transient Image _stamp = null;
    private int _stampWidth = 128;
    private int _stampHeight = 128;
    protected Color _color = new Color(180, 180, 180);
    protected Color _bgColor = Color.lightGray;
    protected boolean _paintBackground = true;
    protected int _dotSize = 2;
    private int _style = 2;
    private final int NUM_STYLES = 5;

    public LayerGrid() {
        super("Grid");
        this._bgColor = UIManager.getColor("Panel.background");
        if (this._bgColor == null) {
            this._bgColor = Color.lightGray;
        }
        float scale = 0.9f;
        this._color = new Color((int)((float)this._bgColor.getRed() * 0.9f), (int)((float)this._bgColor.getGreen() * 0.9f), (int)((float)this._bgColor.getBlue() * 0.9f));
    }

    public LayerGrid(Color fore, Color back, int spacing, boolean lines) {
        super("Grid");
        this._color = fore;
        this._bgColor = back;
        this._spacing = spacing;
        this._paintLines = lines;
    }

    public List getContents() {
        return null;
    }

    public Fig presentationFor(Object obj) {
        return null;
    }

    public synchronized void paintContents(Graphics g) {
        if (g instanceof PrintGraphics) {
            if (!Globals.getPrefs().getPrintGrid()) {
                return;
            }
            if (this._paintLines) {
                this.paintLines(g, Globals.getPrefs().getPrintBackground());
            } else {
                this.paintDots(g, Globals.getPrefs().getPrintBackground());
            }
            return;
        }
        if (this._stamp == null) {
            if (this._spacing > this._stampHeight) {
                this._stampHeight = this._stampWidth = this._spacing;
            }
            if (Globals.curEditor() == null) {
                System.out.println("no editor");
                Frame frame = new Frame();
                frame.setVisible(true);
                this._stamp = frame.createImage(this._stampWidth, this._stampHeight);
                frame.dispose();
            } else {
                this._stamp = Globals.curEditor().createImage(this._stampWidth, this._stampHeight);
            }
            if (this._stamp != null) {
                if (this._paintLines) {
                    this.paintLines(this._stamp, this._paintBackground);
                } else if (this._paintDots) {
                    this.paintDots(this._stamp, this._paintBackground);
                }
            }
        }
        Rectangle clip = g.getClipBounds();
        int y = clip.y / this._spacing * this._spacing;
        int bot = clip.y + clip.height;
        int right = clip.x + clip.width;
        if (this._stamp != null) {
            for (int x = clip.x / this._spacing * this._spacing; x <= right; x += this._stampWidth) {
                for (y = clip.y / this._spacing * this._spacing; y <= bot; y += this._stampHeight) {
                    g.drawImage(this._stamp, x, y, null);
                }
            }
        }
    }

    private void paintLines(Image i, boolean paintBackground) {
        Graphics g = i.getGraphics();
        g.clipRect(0, 0, i.getWidth(null), i.getHeight(null));
        this.paintLines(g, paintBackground);
    }

    private void paintDots(Image i, boolean paintBackground) {
        Graphics g = i.getGraphics();
        g.clipRect(0, 0, i.getWidth(null), i.getHeight(null));
        this.paintDots(g, paintBackground);
    }

    private void paintLines(Graphics g, boolean paintBackground) {
        Rectangle clip = g.getClipBounds();
        if (paintBackground) {
            g.setColor(this._bgColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        int x = clip.x / this._spacing * this._spacing - this._spacing;
        int y = clip.y / this._spacing * this._spacing - this._spacing;
        int stepsY = clip.height / this._spacing + 2;
        int right = clip.x + clip.width;
        int bot = clip.y + clip.height;
        g.setColor(this._color);
        for (int stepsX = clip.width / this._spacing + 2; stepsX > 0; --stepsX) {
            g.drawLine(x, 0, x, bot);
            x += this._spacing;
        }
        while (stepsY > 0) {
            g.drawLine(0, y, right, y);
            y += this._spacing;
            --stepsY;
        }
    }

    protected void paintDots(Graphics g, boolean paintBackground) {
        Rectangle clip = g.getClipBounds();
        if (paintBackground) {
            g.setColor(this._bgColor);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        int y = clip.y / this._spacing * this._spacing - this._spacing;
        int right = clip.x + clip.width;
        int bot = clip.y + clip.height;
        g.setColor(this._color);
        for (int x = clip.x / this._spacing * this._spacing - this._spacing; x <= right; x += this._spacing) {
            for (y = 0; y <= bot; y += this._spacing) {
                g.fillRect(x, y, this._dotSize, this._dotSize);
            }
        }
    }

    public void adjust() {
        this._style = (this._style + 1) % 5;
        this._stamp = null;
        this.setHidden(false);
        switch (this._style) {
            case 0: {
                this._paintLines = true;
                this._paintDots = true;
                this._spacing = 16;
                break;
            }
            case 1: {
                this._paintLines = true;
                this._paintDots = true;
                this._spacing = 8;
                break;
            }
            case 2: {
                this._paintLines = false;
                this._paintDots = true;
                this._spacing = 16;
                break;
            }
            case 3: {
                this._paintLines = false;
                this._paintDots = true;
                this._spacing = 32;
                break;
            }
            case 4: {
                this._paintLines = false;
                this._paintDots = false;
            }
        }
        this.refreshEditors();
    }

    public void adjust(HashMap map) {
        super.adjust(map);
        this._stamp = null;
        this.setHidden(false);
        Object m = map.get("spacing");
        if (m instanceof Integer) {
            this._spacing = (Integer)m;
        }
        if ((m = map.get("paintLines")) instanceof Boolean) {
            this._paintLines = (Boolean)m;
        }
        if ((m = map.get("paintDots")) instanceof Boolean) {
            this._paintDots = (Boolean)m;
        }
        this.refreshEditors();
    }
}

