/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.ModeCreateEdge;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.UndoManager;

public class ModeCreatePolyEdge
extends ModeCreateEdge {
    private static final long serialVersionUID = 1991680308906935894L;
    private Object startPort;
    private Fig startPortFig;
    private FigNode sourceFigNode;
    private Object newEdge;
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);
    private static Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$base$ModeCreatePolyEdge == null ? (class$org$tigris$gef$base$ModeCreatePolyEdge = ModeCreatePolyEdge.class$("org.tigris.gef.base.ModeCreatePolyEdge")) : class$org$tigris$gef$base$ModeCreatePolyEdge));
    static /* synthetic */ Class class$org$tigris$gef$base$ModeCreatePolyEdge;

    public ModeCreatePolyEdge() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreatePolyEdge");
        }
    }

    public ModeCreatePolyEdge(Editor par) {
        super(par);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreatePolyEdge for Editor");
        }
    }

    public String instructions() {
        return "Drag to define an edge to another port";
    }

    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        FigPoly p = new FigPoly(snapX, snapY);
        p.setLineColor(Globals.getPrefs().getRubberbandColor());
        p.setFillColor(null);
        p.addPoint(snapX, snapY);
        this._startX = this._lastX = snapX;
        this._startY = this._lastY = snapY;
        this._npoints = 2;
        return p;
    }

    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but rejected as already consumed");
            }
            return;
        }
        UndoManager.getInstance().addMementoLock(this);
        int x = me.getX();
        int y = me.getY();
        Fig underMouse = this.editor.hit(x, y);
        if (underMouse == null) {
            underMouse = this.editor.hit(x - 16, y - 16, 32, 32);
        }
        if (underMouse == null && this._npoints == 0) {
            this.done();
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but nothing under mouse - consumed anyway");
            }
            return;
        }
        if (!(underMouse instanceof FigNode) && this._npoints == 0) {
            this.done();
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but not on a FigNode - consumed anyway");
            }
            return;
        }
        if (this.sourceFigNode == null) {
            this.sourceFigNode = (FigNode)underMouse;
            this.startPort = this.sourceFigNode.deepHitPort(x, y);
        }
        if (this.startPort == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected but not on a port - consumed anyway");
            }
            this.done();
            me.consume();
            return;
        }
        this.startPortFig = this.sourceFigNode.getPortFig(this.startPort);
        if (this._npoints == 0) {
            this.createFig(me);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MousePressed detected and processed by ancestor - consumed");
        }
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        GraphModel graphModel;
        if (me.isConsumed()) {
            return;
        }
        if (this.sourceFigNode == null) {
            this.done();
            me.consume();
            return;
        }
        UndoManager.getInstance().startChain();
        int x = me.getX();
        int y = me.getY();
        Fig f = this.editor.hit(x, y);
        if (f == null) {
            f = this.editor.hit(x - 16, y - 16, 32, 32);
        }
        if (!((graphModel = this.editor.getGraphModel()) instanceof MutableGraphModel)) {
            f = null;
        }
        MutableGraphModel mutableGraphModel = (MutableGraphModel)graphModel;
        if (f instanceof FigNode) {
            FigNode destFigNode = (FigNode)f;
            Object foundPort = destFigNode.deepHitPort(x, y);
            if (foundPort == this.startPort && this._npoints < 4) {
                this.done();
                me.consume();
                return;
            }
            if (foundPort != null) {
                Fig destPortFig = destFigNode.getPortFig(foundPort);
                FigPoly p = (FigPoly)this._newItem;
                if (foundPort == this.startPort && this._npoints >= 4) {
                    p.setSelfLoop(true);
                }
                this.editor.damageAll();
                p.setComplete(true);
                Class edgeClass = (Class)this.getArg("edgeClass");
                this.newEdge = edgeClass != null ? mutableGraphModel.connect(this.startPort, foundPort, edgeClass) : mutableGraphModel.connect(this.startPort, foundPort);
                if (null == this.newEdge) {
                    LOG.warn((Object)"MutableGraphModel connect() returned null");
                } else {
                    this.sourceFigNode.damage();
                    destFigNode.damage();
                    Layer lay = this.editor.getLayerManager().getActiveLayer();
                    FigEdge fe = (FigEdge)lay.presentationFor(this.newEdge);
                    this._newItem.setLineColor(Color.black);
                    fe.setFig(this._newItem);
                    fe.setSourcePortFig(this.startPortFig);
                    fe.setSourceFigNode(this.sourceFigNode);
                    fe.setDestPortFig(destPortFig);
                    fe.setDestFigNode(destFigNode);
                    if (fe != null) {
                        this.editor.getSelectionManager().select(fe);
                    }
                    this.editor.damageAll();
                    if (fe instanceof MouseListener) {
                        ((MouseListener)((Object)fe)).mouseReleased(me);
                    }
                    if (this.sourceFigNode != null) {
                        this.sourceFigNode.updateEdges();
                    }
                    if (destFigNode != null) {
                        destFigNode.updateEdges();
                    }
                    this.endAttached(fe);
                }
                this.done();
                me.consume();
                return;
            }
        }
        if (!this.nearLast(x, y)) {
            this.editor.damageAll();
            Point snapPt = new Point(x, y);
            this.editor.snap(snapPt);
            ((FigPoly)this._newItem).addPoint(snapPt.x, snapPt.y);
            ++this._npoints;
            this.editor.damageAll();
        }
        this._lastX = x;
        this._lastY = y;
        UndoManager.getInstance().removeMementoLock(this);
        me.consume();
    }

    public void mouseMoved(MouseEvent me) {
        this.mouseDragged(me);
    }

    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._npoints == 0) {
            me.consume();
            return;
        }
        if (this._newItem == null) {
            me.consume();
            return;
        }
        FigPoly p = (FigPoly)this._newItem;
        this.editor.damageAll();
        Point snapPt = new Point(x, y);
        this.editor.snap(snapPt);
        this._handle.index = p.getNumPoints() - 1;
        p.moveVertex(this._handle, snapPt.x, snapPt.y, true);
        this.editor.damageAll();
        me.consume();
    }

    protected boolean nearLast(int x, int y) {
        return x > this._lastX - 8 && x < this._lastX + 8 && y > this._lastY - 8 && y < this._lastY + 8;
    }

    public void done() {
        super.done();
        if (this._newItem != null) {
            this.editor.damageAll();
        }
        this._newItem = null;
        this._npoints = 0;
        this.sourceFigNode = null;
        this.startPort = null;
        this.startPortFig = null;
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == '\u001b') {
            LOG.debug((Object)"Esc pressed");
            this.done();
            ke.consume();
        }
    }

    protected FigNode getSourceFigNode() {
        return this.sourceFigNode;
    }

    protected void setSourceFigNode(FigNode node) {
        this.sourceFigNode = node;
    }

    protected Object getStartPort() {
        return this.startPort;
    }

    protected void setStartPort(Object object) {
        this.startPort = object;
    }

    protected Fig getStartPortFig() {
        return this.startPortFig;
    }

    protected void setStartPortFig(Fig fig) {
        this.startPortFig = fig;
    }

    protected Object getNewEdge() {
        return this.newEdge;
    }

    protected void setNewEdge(Object edge) {
        this.newEdge = edge;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

