/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.PlaceMemento;
import org.tigris.gef.graph.GraphFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.undo.UndoManager;

public class ModePlace
extends FigModifyingModeImpl {
    private static final long serialVersionUID = 8861862975789222877L;
    protected Object _node;
    protected FigNode _pers;
    protected GraphFactory _factory;
    protected boolean _addRelatedEdges = false;
    protected String _instructions;
    private static Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$base$ModePlace == null ? (class$org$tigris$gef$base$ModePlace = ModePlace.class$("org.tigris.gef.base.ModePlace")) : class$org$tigris$gef$base$ModePlace));
    static /* synthetic */ Class class$org$tigris$gef$base$ModePlace;

    public ModePlace(GraphFactory gf) {
        this._factory = gf;
        this._node = null;
        this._pers = null;
        this._instructions = null;
    }

    public ModePlace(GraphFactory gf, String instructions) {
        this._factory = gf;
        this._node = null;
        this._pers = null;
        this._instructions = instructions;
    }

    public String instructions() {
        if (this._instructions == null) {
            this._instructions = "";
        }
        return this._instructions;
    }

    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void setAddRelatedEdges(boolean b) {
        this._addRelatedEdges = b;
    }

    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        UndoManager.getInstance().addMementoLock(this);
        this._node = this._factory.makeNode();
        this.start();
        this.editor = Globals.curEditor();
        GraphModel gm = this.editor.getGraphModel();
        GraphNodeRenderer renderer = this.editor.getGraphNodeRenderer();
        Layer lay = this.editor.getLayerManager().getActiveLayer();
        this._pers = renderer.getFigNodeFor(gm, lay, this._node, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mousePressed: Got a fig at position (" + this._pers.getX() + "," + this._pers.getY() + ")"));
        }
        this.mouseMoved(me);
        me.consume();
    }

    public void mouseExited(MouseEvent me) {
        this.editor.damageAll();
        this._pers = null;
        me.consume();
    }

    public void mouseMoved(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        int x = me.getX();
        int y = me.getY();
        if (this._pers == null) {
            me.consume();
            return;
        }
        this.editor.damageAll();
        Point snapPt = new Point(x, y);
        this.editor.snap(snapPt);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mouseMoved: About to set location (" + this._pers.getX() + "," + this._pers.getY() + ")"));
        }
        this._pers.setLocation(snapPt.x, snapPt.y);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mouseMoved: Location set (" + this._pers.getX() + "," + this._pers.getY() + ")"));
        }
        this.editor.damageAll();
        me.consume();
    }

    public void mouseEntered(MouseEvent me) {
        me.consume();
    }

    public void mouseDragged(MouseEvent me) {
        this.mouseMoved(me);
    }

    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as already consumed");
            }
            return;
        }
        GraphModel gm = this.editor.getGraphModel();
        if (!(gm instanceof MutableGraphModel)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as graph is not mutable");
            }
            return;
        }
        MutableGraphModel mgm = (MutableGraphModel)gm;
        if (mgm.canAddNode(this._node)) {
            LOG.debug((Object)("mouseReleased Adding fig to editor (" + this._pers.getX() + "," + this._pers.getY()));
            UndoManager.getInstance().startChain();
            this.editor.add(this._pers);
            mgm.addNode(this._node);
            if (this._addRelatedEdges) {
                mgm.addNodeRelatedEdges(this._node);
            }
            Fig encloser = null;
            Rectangle bbox = this._pers.getBounds();
            Layer lay = this.editor.getLayerManager().getActiveLayer();
            List otherFigs = lay.getContents();
            Iterator it = otherFigs.iterator();
            while (it.hasNext()) {
                Rectangle trap;
                Fig otherFig = (Fig)it.next();
                if (!otherFig.getUseTrapRect() || !(otherFig instanceof FigNode) || !otherFig.isVisible() || otherFig.equals(this._pers) || (trap = otherFig.getTrapRect()) == null || !trap.contains(bbox.x, bbox.y) || !trap.contains(bbox.x + bbox.width, bbox.y + bbox.height)) continue;
                encloser = otherFig;
            }
            this._pers.setEnclosingFig(encloser);
            if (this._node instanceof GraphNodeHooks) {
                ((GraphNodeHooks)this._node).postPlacement(this.editor);
            }
            UndoManager.getInstance().removeMementoLock(this);
            if (UndoManager.getInstance().isGenerateMementos()) {
                PlaceMemento memento = new PlaceMemento(this.editor, this._node, this._pers);
                UndoManager.getInstance().addMemento(memento);
            }
            UndoManager.getInstance().addMementoLock(this);
            this.editor.getSelectionManager().select(this._pers);
        }
        this.done();
        me.consume();
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == '\u001b') {
            LOG.debug((Object)"ESC pressed");
            this.leave();
        }
    }

    public void done() {
        super.done();
        this._pers = null;
        this._node = null;
    }

    public void paint(Graphics g) {
        if (this._pers != null) {
            this._pers.paint((Object)g);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

