/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeBroom;
import org.tigris.gef.base.ModeImpl;
import org.tigris.gef.base.ModeModify;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.Handle;

public class ModeSelect
extends FigModifyingModeImpl {
    private static final long serialVersionUID = 2412264848254549816L;
    private Point selectAnchor = new Point(0, 0);
    private Rectangle selectRect = new Rectangle(0, 0, 0, 0);
    private boolean showSelectRect = false;
    private boolean toggleSelection = false;
    private static Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$base$ModeSelect == null ? (class$org$tigris$gef$base$ModeSelect = ModeSelect.class$("org.tigris.gef.base.ModeSelect")) : class$org$tigris$gef$base$ModeSelect));
    static /* synthetic */ Class class$org$tigris$gef$base$ModeSelect;

    public ModeSelect(Editor parent) {
        super(parent);
    }

    public ModeSelect() {
    }

    public boolean canExit() {
        return false;
    }

    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as already consumed");
            }
            return;
        }
        if (me.isAltDown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as alt key pressed");
            }
            return;
        }
        if (me.getModifiers() == 4) {
            this.selectAnchor = new Point(me.getX(), me.getY());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected button 3 so setting anchor point");
            }
            return;
        }
        if (me.isShiftDown()) {
            this.gotoBroomMode(me);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed with shift key so gone to broom mode");
            }
            return;
        }
        int x = me.getX();
        int y = me.getY();
        this.selectAnchor = new Point(x, y);
        this.selectRect.setBounds(x, y, 0, 0);
        this.toggleSelection = me.isControlDown() && !me.isPopupTrigger() || me.isMetaDown();
        SelectionManager sm = this.editor.getSelectionManager();
        Rectangle hitRect = new Rectangle(x - 4, y - 4, 8, 8);
        Fig underMouse = this.editor.hit(this.selectAnchor);
        Rectangle smallHitRect = new Rectangle(x - 1, y - 1, 3, 3);
        if (underMouse instanceof FigGroup) {
            underMouse = ((FigGroup)underMouse).deepSelect(smallHitRect);
        }
        if (underMouse == null && !sm.hit(hitRect)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as no fig found");
            }
            return;
        }
        Handle h = new Handle(-1);
        sm.hitHandle(new Rectangle(x - 4, y - 4, 8, 8), h);
        if (h.index >= 0) {
            this.gotoModifyMode(me);
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed with hit handle, going to Modify mode and consumed event");
            }
            return;
        }
        if (underMouse != null) {
            if (this.toggleSelection) {
                sm.toggle(underMouse);
            } else if (!sm.containsFig(underMouse)) {
                sm.select(underMouse);
            }
        }
        if (sm.hit(hitRect)) {
            this.gotoModifyMode(me);
        }
        me.consume();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MousePressed selection changed and consumed event");
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed() || me.isAltDown() || me.isMetaDown()) {
            return;
        }
        this.editor.translateMouseEvent(me);
        int x = me.getX();
        int y = me.getY();
        this.showSelectRect = true;
        int boundX = Math.min(this.selectAnchor.x, x);
        int boundY = Math.min(this.selectAnchor.y, y);
        int boundW = Math.max(this.selectAnchor.x, x) - boundX;
        int boundH = Math.max(this.selectAnchor.y, y) - boundY;
        double scale = this.editor.getScale();
        this.scaleDamage(scale, this.selectRect);
        this.selectRect.setBounds(boundX, boundY, boundW, boundH);
        this.scaleDamage(scale, this.selectRect);
        this.editor.scrollToShow(x, y);
        me.consume();
    }

    private void scaleDamage(double scale, Rectangle rect) {
        int newX = (int)((double)rect.x * scale) - 1;
        int newY = (int)((double)rect.y * scale) - 1;
        int newWidth = (int)((double)(rect.width + 2) * scale) + 2;
        int newHeight = (int)((double)(rect.height + 2) * scale) + 2;
        this.editor.damaged(newX, newY, newWidth, newHeight);
    }

    public void mouseReleased(MouseEvent me) {
        Fig f;
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as already consumed");
            }
            return;
        }
        if (me.isMetaDown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as meta key down");
            }
            return;
        }
        this.editor.translateMouseEvent(me);
        int x = me.getX();
        int y = me.getY();
        this.showSelectRect = false;
        Vector<Fig> selectList = new Vector<Fig>();
        Rectangle hitRect = new Rectangle(x - 4, y - 4, 8, 8);
        Enumeration figs = this.editor.figs();
        while (figs.hasMoreElements()) {
            f = (Fig)figs.nextElement();
            if (!f.isSelectable() || (this.toggleSelection || !this.selectRect.isEmpty() || !f.hit(hitRect)) && (this.selectRect.isEmpty() || !f.within(this.selectRect))) continue;
            selectList.addElement(f);
        }
        if (!this.selectRect.isEmpty() && selectList.isEmpty()) {
            figs = this.editor.figs();
            while (figs.hasMoreElements()) {
                f = (Fig)figs.nextElement();
                if (!f.isSelectable() || !f.intersects(this.selectRect)) continue;
                selectList.addElement(f);
            }
        }
        if (this.toggleSelection) {
            this.editor.getSelectionManager().toggle(selectList);
        } else {
            this.editor.getSelectionManager().select(selectList);
        }
        this.selectRect.grow(1, 1);
        this.editor.scaleRect(this.selectRect);
        this.editor.damaged(this.selectRect);
        if (me.getModifiers() == 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased button 3 detected so not consumed");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MouseReleased and consumed");
        }
        me.consume();
    }

    public String instructions() {
        return "  ";
    }

    public void paint(Graphics g) {
        if (this.showSelectRect) {
            Color selectRectColor = Globals.getPrefs().getRubberbandColor();
            g.setColor(selectRectColor);
            g.drawRect(this.selectRect.x, this.selectRect.y, this.selectRect.width, this.selectRect.height);
        }
    }

    protected void gotoModifyMode(MouseEvent me) {
        ModeModify nextMode = new ModeModify(this.editor);
        this.editor.pushMode(nextMode);
        ((ModeImpl)nextMode).mousePressed(me);
    }

    protected void gotoBroomMode(MouseEvent me) {
        ModeBroom nextMode = new ModeBroom(this.editor);
        this.editor.pushMode(nextMode);
        ((ModeImpl)nextMode).mousePressed(me);
    }

    private boolean isMultiSelectTrigger(MouseEvent me) {
        return me.isControlDown() && !me.isPopupTrigger() || me.isMetaDown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

