/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.GuideGrid;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;
import org.tigris.gef.util.VetoableChangeEventSource;

public class PasteAction
extends UndoableAction {
    private static final long serialVersionUID = 1306168450357555809L;

    public PasteAction(String name) {
        this(name, false);
    }

    public PasteAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public PasteAction(String name, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name);
    }

    public PasteAction(String name, Icon icon, boolean localize) {
        super(localize ? Localizer.localize("GefBase", name) : name, icon);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        SelectionManager sm = Globals.curEditor().getSelectionManager();
        Vector<Fig> figs = new Vector<Fig>();
        Enumeration cb = Globals.clipBoard.elements();
        while (cb.hasMoreElements()) {
            Fig f = (Fig)cb.nextElement();
            Editor ce = Globals.curEditor();
            int gridSze = ((GuideGrid)ce.getGuide()).gridSize();
            f.translate(gridSze, gridSze);
            f = (Fig)f.clone();
            Object owner = f.getOwner();
            if (owner instanceof VetoableChangeEventSource && f instanceof VetoableChangeListener) {
                ((VetoableChangeEventSource)owner).addVetoableChangeListener((VetoableChangeListener)((Object)f));
            }
            ce.add(f);
            figs.addElement(f);
        }
        sm.deselectAll();
        sm.select(figs);
    }
}

