/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ConnectionConstrainer {
    protected Map _validConnectionMap = new HashMap();

    public boolean isConnectionValid(Object edgeType, Object fromElement, Object toElement) {
        ArrayList validItems = (ArrayList)this._validConnectionMap.get(edgeType);
        if (validItems == null) {
            return false;
        }
        Iterator it = validItems.iterator();
        while (it.hasNext()) {
            Class[] modeElementPair = (Class[])it.next();
            if (!modeElementPair[0].isInstance(fromElement) || !modeElementPair[1].isInstance(toElement)) continue;
            return true;
        }
        return false;
    }

    protected void buildValidConnectionMap(Object[][] validConnections) {
        Object connection = null;
        for (int i = 0; i < validConnections.length; ++i) {
            Class[] modeElementPair;
            connection = validConnections[i][0];
            ArrayList<Class[]> validItems = (ArrayList<Class[]>)this._validConnectionMap.get(connection);
            if (validItems == null) {
                validItems = new ArrayList<Class[]>();
                this._validConnectionMap.put(connection, validItems);
            }
            if (validConnections[i].length < 3) {
                modeElementPair = new Class[]{validConnections[i][1], validConnections[i][1]};
                validItems.add(modeElementPair);
                continue;
            }
            modeElementPair = new Class[]{validConnections[i][1], validConnections[i][2]};
            validItems.add(modeElementPair);
            if (validConnections[i].length >= 4) continue;
            Class[] reversedModeElementPair = new Class[]{validConnections[i][2], validConnections[i][1]};
            validItems.add(reversedModeElementPair);
        }
    }

    protected void addValidConnection(Class edgeClass, Class portClass) {
        Class connection = edgeClass;
        ArrayList<Class[]> validItems = (ArrayList<Class[]>)this._validConnectionMap.get(connection);
        if (validItems == null) {
            validItems = new ArrayList<Class[]>();
            this._validConnectionMap.put(connection, validItems);
        }
        Class[] modeElementPair = new Class[]{portClass, portClass};
        validItems.add(modeElementPair);
    }

    protected void addValidConnection(Class edgeClass, Class portClass1, Class portClass2) {
        ArrayList<Class[]> validItems = (ArrayList<Class[]>)this._validConnectionMap.get(edgeClass);
        if (validItems == null) {
            validItems = new ArrayList<Class[]>();
            this._validConnectionMap.put(edgeClass, validItems);
        }
        Class[] modeElementPair = new Class[]{portClass1, portClass2};
        validItems.add(modeElementPair);
    }
}

