/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ocl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.ocl.ExpansionException;

public class OCLEvaluator {
    public static String OCL_START = "<ocl>";
    public static String OCL_END = "</ocl>";
    public static String GET_NAME_EXPR_1 = "self";
    public static String GET_NAME_EXPR_2 = "self.name.body";
    public static String GET_OWNER_EXPR = "self.owner";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$ocl$OCLEvaluator == null ? (class$org$tigris$gef$ocl$OCLEvaluator = OCLEvaluator.class$("org.tigris.gef.ocl.OCLEvaluator")) : class$org$tigris$gef$ocl$OCLEvaluator));
    protected Map _scratchBindings = new Hashtable();
    protected StringBuffer _strBuf = new StringBuffer(100);
    static /* synthetic */ Class class$org$tigris$gef$ocl$OCLEvaluator;

    protected OCLEvaluator() {
    }

    protected synchronized String evalToString(Object self, String expr) throws ExpansionException {
        return this.evalToString(self, expr, ", ");
    }

    protected synchronized String evalToString(Object self, String expr, String sep) throws ExpansionException {
        this._scratchBindings.put("self", self);
        List values = this.eval(this._scratchBindings, expr);
        this._strBuf.setLength(0);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String v = iter.next().toString();
            if (v.length() <= 0) continue;
            this._strBuf.append(v);
            if (!iter.hasNext()) continue;
            this._strBuf.append(sep);
        }
        return this._strBuf.toString();
    }

    protected List eval(Map bindings, String expr) throws ExpansionException {
        Vector targets;
        Object target;
        int firstPos = expr.indexOf(".");
        if (firstPos < 0) {
            firstPos = expr.length();
        }
        if ((target = bindings.get(expr.substring(0, firstPos))) instanceof Vector) {
            targets = (Vector)target;
        } else {
            targets = new Vector();
            targets.addElement(target);
        }
        if (expr.equals("self")) {
            return targets;
        }
        String prop = expr.substring(firstPos);
        List items = this.eval(bindings, prop, targets);
        return items;
    }

    private List eval(Map bindings, String expr, List targets) throws ExpansionException {
        String partExpr = expr;
        try {
            while (partExpr.length() > 0) {
                String property;
                ArrayList<Object> v = new ArrayList<Object>();
                int firstPos = partExpr.indexOf(".");
                int secPos = partExpr.indexOf(".", firstPos + 1);
                if (secPos == -1) {
                    property = partExpr.substring(firstPos + 1);
                    partExpr = "";
                } else {
                    property = partExpr.substring(firstPos + 1, secPos);
                    partExpr = partExpr.substring(secPos);
                }
                int numElements = targets.size();
                for (int i = 0; i < numElements; ++i) {
                    v.add(this.evaluateProperty(targets.get(i), property));
                }
                targets = new Vector(this.flatten(v));
            }
        }
        catch (Exception e) {
            throw new ExpansionException("Exception while expanding the expression " + expr + " (" + partExpr + ")", e);
        }
        return targets;
    }

    private String toTitleCase(String s) {
        if (s.length() > 0) {
            return this.toUpperCase(s.charAt(0)) + s.substring(1, s.length());
        }
        return s;
    }

    private char toUpperCase(char c) {
        int pos = "abcdefghijklmnopqrstuvwxyz".indexOf(c);
        if (pos == -1) {
            return c;
        }
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(pos);
    }

    private Object evaluateProperty(Object target, String property) throws ExpansionException {
        Method method;
        if (target == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for property '" + property + "' on " + target.getClass().getName()));
        }
        String collectionRange = null;
        int rangePos = property.indexOf(91);
        if (rangePos >= 0) {
            collectionRange = property.substring(rangePos);
            property = property.substring(0, rangePos);
        }
        if ((method = this.getMethod(target.getClass(), "get" + this.toTitleCase(property))) != null) {
            return this.invokeMethod(method, target, collectionRange);
        }
        method = this.getMethod(target.getClass(), property);
        if (method != null) {
            return this.invokeMethod(method, target, collectionRange);
        }
        method = this.getMethod(target.getClass(), this.toTitleCase(property));
        if (method != null) {
            LOG.warn((Object)("Reference to a method with bad naming convention - " + this.toTitleCase(property)));
            return this.invokeMethod(method, target, collectionRange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for variable '" + property + "'"));
        }
        Field f = null;
        try {
            f = target.getClass().getField(property);
            return OCLEvaluator.convertCollection(f.get(target), collectionRange);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get field " + property + " on " + target.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    private Object invokeMethod(Method method, Object target, String collectionRange) throws ExpansionException {
        if (method != null) {
            try {
                Object o = method.invoke(target, null);
                return OCLEvaluator.convertCollection(o, collectionRange);
            }
            catch (Exception e) {
                throw new ExpansionException(e);
            }
        }
        return null;
    }

    private List flatten(List v) {
        ArrayList accum = new ArrayList();
        this.flattenInto(v, accum);
        return accum;
    }

    private void flattenInto(Object o, List accum) {
        if (o instanceof List) {
            List oList = (List)o;
            Iterator it = oList.iterator();
            while (it.hasNext()) {
                Object p = it.next();
                this.flattenInto(p, accum);
            }
        } else {
            accum.add(o);
        }
    }

    private static Object convertCollection(Object o, String range) {
        if (!(o instanceof Collection) && !(o instanceof Object[])) {
            return o;
        }
        List list = o instanceof Object[] ? Arrays.asList((Object[])o) : (o instanceof List ? (ArrayList)o : new ArrayList((Collection)o));
        if (range != null) {
            StringTokenizer st = new StringTokenizer(range, "[,]");
            int start = OCLEvaluator.getValue(st.nextToken(), list);
            int end = OCLEvaluator.getValue(st.nextToken(), list);
            if (end <= start) {
                return Collections.EMPTY_LIST;
            }
            list = list.subList(start, end);
        }
        return list;
    }

    private static final int getValue(String range, List list) {
        if (range.trim().equals("*")) {
            return list.size();
        }
        return Integer.parseInt(range);
    }

    private Method getMethod(Class targetClass, String methodName) {
        Method[] m = targetClass.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (m[i].getParameterTypes().length != 0 || !m[i].getName().equals(methodName)) continue;
            return m[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

