/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import org.tigris.gef.persistence.FontUtility;

public class PostscriptWriter
extends Graphics2D {
    private PrintWriter p;
    private boolean autoClose = false;
    private static final String ellipseDef = "%%BeginProcSet: ellipse 1.0 0 \n/ellipsedict 8 dict def \nellipsedict /mtrx matrix put \n/ellipse { ellipsedict begin \n/endangle exch def \n/startangle exch def \n/yrad exch def \n/xrad exch def \n/y exch def \n/x exch def \n/savematrix mtrx currentmatrix def \nx y translate \nxrad yrad scale \n0 0 1 0 360 arc \nsavematrix setmatrix end } def \n%%EndProcSet: ellipse 1.0 0 \n";
    private static final String reencodeDef = "%%BeginProcSet: reencode 1.0 0 \n/RE \n{  findfont begin \n  currentdict dup length dict begin \n  {1 index /FID ne {def} {pop pop} ifelse} forall \n  /FontName exch def dup length 0 ne \n  { /Encoding Encoding 256 array copy def \n      0 exch \n      { dup type /nametype eq \n        { Encoding 2 index 2 index put \n          pop 1 add \n        } \n        { exch pop \n        } ifelse \n      } forall \n  } if pop \n  currentdict dup end end \n  /FontName get exch definefont pop \n    } bind def \n%%EndProcSet: reencode 1.0 0 \n";
    private static final String isolatin1encoding = "/isolatin1encoding \n[ 32 /space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quoteright \n /parenleft /parenright /asterisk /plus /comma /hyphen /period /slash /zero /one \n /two /three /four /five /six /seven /eight /nine /colon /semicolon \n /less /equal /greater /question /at /A /B /C /D /E \n /F /G /H /I /J /K /L /M /N /O \n /P /Q /R /S /T /U /V /W /X /Y \n /Z /bracketleft /backslash /bracketright /asciicircum /underscore /quoteleft /a /b /c \n /d /e /f /g /h /i /j /k /l /m \n /n /o /p /q /r /s /t /u /v /w \n /x /y /z /braceleft /bar /braceright /asciitilde /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /space /exclamdown /cent /sterling /currency /yen /brokenbar /section /dieresis /copyright \n /ordfeminine /guillemotleft /logicalnot /hyphen /registered /macron /degree /plusminus /twosuperior /threesuperior \n /acute /mu /paragraph /periodcentered /cedilla /onesuperior /ordmasculine /guillemotright /onequarter /onehalf \n /threequarters /questiondown /Agrave /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE /Ccedilla \n /Egrave /Eacute /Ecircumflex /Edieresis /Igrave /Iacute /Icircumflex /Idieresis /Eth /Ntilde \n /Ograve /Oacute /Ocircumflex /Otilde /Odieresis /multiply /Oslash /Ugrave /Uacute /Ucircumflex \n /Udieresis /Yacute /Thorn /germandbls /agrave /aacute /acircumflex /atilde /adieresis /aring \n /ae /ccedilla /egrave /eacute /ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis \n /eth /ntilde /ograve /oacute /ocircumflex /otilde /odieresis /divide /oslash /ugrave \n /uacute /ucircumflex /udieresis /yacute /thorn /ydieresis] def \n";
    private Color fColor = null;
    private Font fFont = null;
    private Rectangle clip;
    private Hashtable fontmap = new Hashtable();
    private Hashtable colormap = new Hashtable();
    private BasicStroke stroke = null;
    private String lastStroke = "[] 0 setdash";

    public PostscriptWriter(String filename) throws IOException {
        this(filename, null);
    }

    public PostscriptWriter(String filename, Rectangle boundingBox) throws IOException {
        this(new FileOutputStream(filename), boundingBox);
        this.autoClose = true;
    }

    public PostscriptWriter(OutputStream stream) throws IOException {
        this(stream, null);
    }

    public PostscriptWriter(OutputStream stream, Rectangle bb) throws IOException {
        this.fontmap.put("Dialog", "Helvetica");
        this.fontmap.put("SansSerif", "Helvetica");
        this.fontmap.put("DialogInput", "Monospaced");
        this.p = new PrintWriter(new OutputStreamWriter(stream, "ISO8859-1"));
        if (bb == null) {
            this.p.println("%!PS-Adobe-3.0");
        } else {
            this.p.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.p.println("%%BoundingBox: " + bb.x + " " + bb.y + " " + (bb.x + bb.width) + " " + (bb.y + bb.height));
        }
        this.p.print(reencodeDef);
        this.p.print(ellipseDef);
        this.p.println("%%EndProlog");
        this.p.println("%%BeginSetup");
        this.p.print(isolatin1encoding);
        this.p.println("%%EndSetup");
        this.p.println("1 setlinewidth");
        this.setFont(new Font("Helvetica", 0, 12));
        this.setColor(Color.black);
        if (bb != null) {
            this.translate(0, bb.height + 2 * bb.y);
        }
    }

    public Graphics create() {
        return this;
    }

    public Graphics create(int x, int y, int width, int height) {
        return this;
    }

    public void dispose() {
        this.p.println("showpage");
        this.p.println("%%Trailer");
        if (this.autoClose) {
            this.p.close();
        } else {
            this.p.flush();
        }
    }

    public void setColorConversion(Color source, Color target) {
        this.colormap.put(source, target);
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color c) {
        Color replaceColor = (Color)this.colormap.get(c);
        if (replaceColor != null) {
            c = replaceColor;
        }
        if (c.equals(this.fColor)) {
            return;
        }
        this.fColor = c;
        float maxColor = 255.0f;
        this.p.print((float)c.getRed() / 255.0f + " ");
        this.p.print((float)c.getGreen() / 255.0f + " ");
        this.p.print((float)c.getBlue() / 255.0f + " ");
        this.p.println("setrgbcolor");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color otherColor) {
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
        if (!font.equals(this.fFont)) {
            this.fFont = font;
            FontMetrics metrics = this.getFontMetrics();
            String name = font.getName();
            if (this.fontmap.containsKey(name)) {
                name = (String)this.fontmap.get(name);
            }
            if (font.isBold() || font.isItalic()) {
                name = name + "-";
                if (font.isBold()) {
                    name = name + "Bold";
                }
                if (font.isItalic()) {
                    name = name + "Oblique";
                }
            }
            this.p.println("isolatin1encoding /_" + name + " /" + name + " RE");
            this.p.println("/_" + name + " findfont");
            this.p.println(font.getSize() + " scalefont setfont");
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.fFont);
    }

    public FontMetrics getFontMetrics(Font font) {
        return FontUtility.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.clip;
    }

    public void clipRect(int x, int y, int w, int h) {
        this.setClip(x, y, w, h);
    }

    public Shape getClip() {
        return this.clip;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    private void handlesinglepixel(int x, int y, int pixel) {
        if ((pixel >> 24 & 0xFF) == 0) {
            pixel = 0xFFFFFF;
        }
        this.p.print(Integer.toHexString(pixel >> 20 & 0xF) + Integer.toHexString(pixel >> 12 & 0xF) + Integer.toHexString(pixel >> 4 & 0xF));
    }

    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        int iw = img.getWidth(observer);
        int ih = img.getHeight(observer);
        this.p.println("gsave");
        this.writeCoords(x, y + h);
        this.p.println("translate");
        this.writeCoords(w, -h);
        this.p.println("scale");
        this.p.println("/DatenString " + iw + " string def");
        this.writeCoords(iw, -ih);
        this.p.println("4 [" + iw + " 0 0 " + -ih + " 0 " + ih + "]");
        this.p.println("{currentfile DatenString readhexstring pop} bind");
        this.p.println("false 3 colorimage");
        int[] pixels = new int[iw * ih];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, iw, ih, pixels, 0, iw);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        for (int j = 0; j < ih; ++j) {
            for (int i = 0; i < iw; ++i) {
                this.handlesinglepixel(i, j, pixels[j * iw + i]);
            }
            if (iw % 2 == 1) {
                this.p.print("0");
            }
            this.p.println();
        }
        if (ih % 2 == 1) {
            for (int i = 0; i < 3 * (iw + iw % 2); ++i) {
                this.p.print("0");
            }
            this.p.println();
        }
        this.p.println("grestore");
        return true;
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    private void writeSetDash() {
        float[] dash;
        String result = "[] 0 setdash";
        if (this.stroke != null && (dash = this.stroke.getDashArray()) != null) {
            StringBuffer ps = new StringBuffer();
            ps.append('[');
            for (int i = 0; i < dash.length; ++i) {
                ps.append(dash[i]).append(' ');
            }
            ps.append("] 0 setdash");
            result = ps.toString();
        }
        if (!this.lastStroke.equals(result)) {
            this.lastStroke = result;
            this.p.println(result);
        }
    }

    private void writeCoords(int x, int y) {
        this.p.print(x + " " + -y + " ");
    }

    private void writeRectanglePath(int x, int y, int w, int h) {
        this.p.println("newpath");
        this.writeCoords(x, y);
        this.p.println("moveto");
        this.writeCoords(w - 1, 0);
        this.p.println("rlineto");
        this.writeCoords(0, h - 1);
        this.p.println("rlineto");
        this.writeCoords(-(w - 1), 0);
        this.p.println("rlineto");
        this.p.println("closepath");
    }

    public void drawRect(int x, int y, int w, int h) {
        this.writeRectanglePath(x, y, w + 1, h + 1);
        this.p.println("stroke");
    }

    public void fillRect(int x, int y, int w, int h) {
        this.writeRectanglePath(x, y, w, h);
        this.p.println("eofill");
    }

    public void clearRect(int x, int y, int w, int h) {
        this.writeRectanglePath(x, y, w, h);
        this.setColor(Color.white);
        this.p.println("eofill");
    }

    private void writeEllipsePath(int x, int y, int w, int h, int startAngle, int arcAngle) {
        this.writeSetDash();
        this.p.println("newpath");
        int dx = w / 2;
        int dy = h / 2;
        this.writeCoords(x + dx, y + dy);
        this.writeCoords(dx, dy);
        this.writeCoords(startAngle, -(startAngle + arcAngle));
        this.p.println("ellipse");
    }

    public void drawOval(int x, int y, int w, int h) {
        this.writeEllipsePath(x, y, w + 1, h + 1, 0, 360);
        this.p.println("stroke");
    }

    public void fillOval(int x, int y, int w, int h) {
        this.writeEllipsePath(x, y, w, h, 0, 360);
        this.p.println("eofill");
    }

    public void drawArc(int x, int y, int w, int h, int startAngle, int arcAngle) {
        this.writeEllipsePath(x, y, w + 1, h + 1, startAngle, arcAngle);
        this.p.println("stroke");
    }

    public void fillArc(int x, int y, int w, int h, int startAngle, int arcAngle) {
        this.writeEllipsePath(x, y, w, h, startAngle, arcAngle);
        this.p.println("eofill");
    }

    private void writeRoundRectPath(int x, int y, int w, int h, int arcw, int arch) {
        String curve = Math.min(arcw /= 2, arch /= 2) + " arcto 4 {pop} repeat";
        this.writeSetDash();
        this.p.println("newpath");
        this.writeCoords(x, y + arch);
        this.p.println("moveto");
        this.writeCoords(x, y);
        this.writeCoords(x + arcw, y);
        this.p.println(curve);
        this.writeCoords(w - arcw - arcw, 0);
        this.p.println("rlineto");
        this.writeCoords(x + w, y);
        this.writeCoords(x + w, y + arch);
        this.p.println(curve);
        this.writeCoords(0, h - arch - arch);
        this.p.println("rlineto");
        this.writeCoords(x + w, y + h);
        this.writeCoords(x + w - arcw, y + h);
        this.p.println(curve);
        this.writeCoords(arcw + arcw - w, 0);
        this.p.println("rlineto");
        this.writeCoords(x, y + h);
        this.writeCoords(x, y + h - arch);
        this.p.println(curve);
        this.p.println("closepath");
    }

    public void drawRoundRect(int x, int y, int w, int h, int arcw, int arch) {
        this.writeRoundRectPath(x, y, w + 1, h + 1, arcw, arch);
        this.p.println("stroke");
    }

    public void fillRoundRect(int x, int y, int w, int h, int arcw, int arch) {
        this.writeRoundRectPath(x, y, w, h, arcw, arch);
        this.p.println("eofill");
    }

    private void writePolyLinePath(int[] xPoints, int[] yPoints, int nPoints) {
        this.writeSetDash();
        this.p.println("newpath");
        for (int i = 0; i < nPoints; ++i) {
            this.writeCoords(xPoints[i], yPoints[i]);
            if (i == 0) {
                this.p.println("moveto");
                continue;
            }
            this.p.println("lineto");
        }
    }

    public void writePolygonPath(int[] xPoints, int[] yPoints, int nPoints) {
        this.writePolyLinePath(xPoints, yPoints, nPoints);
        this.p.println("closepath");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.writePolygonPath(xPoints, yPoints, nPoints);
        this.p.println("stroke");
    }

    public void drawPolygon(Polygon poly) {
        this.drawPolygon(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.writePolygonPath(xPoints, yPoints, nPoints);
        this.p.println("eofill");
    }

    public void fillPolygon(Polygon poly) {
        this.fillPolygon(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.writePolyLinePath(xPoints, yPoints, nPoints);
        this.p.println("stroke");
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.writeSetDash();
        this.p.println("newpath");
        this.writeCoords(x1, y1);
        this.p.println("moveto");
        this.writeCoords(x2, y2);
        this.p.println("lineto");
        this.p.println("stroke");
    }

    public void setClip(int x, int y, int w, int h) {
        this.clip = new Rectangle(x, y, w, h);
        this.writeRectanglePath(x, y, w, h);
        this.p.println("clip");
    }

    public void setClip(Shape clip) {
        this.setClip(clip.getBounds());
    }

    public void translate(int x, int y) {
        this.writeCoords(x, -y);
        this.p.println("translate");
    }

    public void scale(double xscale, double yscale) {
        this.p.println(xscale + " " + yscale + " scale");
    }

    public void drawString(String text, int x, int y) {
        StringBuffer buf = new StringBuffer(text);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c >= '\u00c0' && c < '\u0100') {
                buf.setCharAt(i, '\\');
                String code = Integer.toOctalString(c);
                buf.insert(i + 1, code);
                i += code.length();
                continue;
            }
            if (c != '\\' && c != '(' && c != ')') continue;
            buf.insert(i++, '\\');
        }
        this.writeCoords(x, y);
        this.p.println("moveto");
        this.p.println("(" + buf.toString() + ") show");
    }

    public void comment(String cmt) {
        this.p.println("% " + cmt);
    }

    public void drawString(AttributedCharacterIterator iterator, int i, int j) {
        throw new RuntimeException("Not supported.");
    }

    public void addRenderingHints(Map map) {
    }

    public void clip(Shape shape) {
    }

    public void draw(Shape shape) {
    }

    public void drawGlyphVector(GlyphVector glyphVector, float param, float param2) {
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int param, int param3) {
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float param, float param2) {
    }

    public void drawString(String str, float param, float param2) {
    }

    public void fill(Shape shape) {
    }

    public Color getBackground() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public Paint getPaint() {
        return null;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public AffineTransform getTransform() {
        return null;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean param) {
        return false;
    }

    public void rotate(double param) {
    }

    public void rotate(double param, double param1, double param2) {
    }

    public void setBackground(Color color) {
    }

    public void setComposite(Composite composite) {
    }

    public void setPaint(Paint paint) {
    }

    public void setRenderingHint(RenderingHints.Key key, Object obj) {
    }

    public void setRenderingHints(Map map) {
    }

    public void setStroke(Stroke stroke) {
        try {
            this.stroke = (BasicStroke)stroke;
        }
        catch (ClassCastException e) {
            this.stroke = null;
        }
    }

    public void setTransform(AffineTransform affineTransform) {
    }

    public void shear(double param, double param1) {
    }

    public void transform(AffineTransform affineTransform) {
    }

    public void translate(double param, double param1) {
    }
}

