/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.pgml;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;

public class PgmlUtility {
    public static String getColor(Color color) {
        String colorDescr = PgmlUtility.getColorName(color);
        if (colorDescr != null) {
            return colorDescr;
        }
        return color.getRed() + " " + color.getGreen() + " " + color.getBlue();
    }

    private static String getColorName(Color color) {
        String colorName = null;
        if (color.equals(Color.white)) {
            colorName = "white";
        } else if (color.equals(Color.black)) {
            colorName = "black";
        } else if (color.equals(Color.red)) {
            colorName = "red";
        } else if (color.equals(Color.green)) {
            colorName = "green";
        } else if (color.equals(Color.blue)) {
            colorName = "blue";
        }
        return colorName;
    }

    public static String getVisibility(Fig f) {
        if (f.isVisible()) {
            return null;
        }
        return "0";
    }

    public static int getDashed(Fig f) {
        return f.getDashed() ? 1 : 0;
    }

    public static int getFilled(Fig f) {
        return f.getFilled() ? 1 : 0;
    }

    public static List getContentsNoEdges(Layer lay) {
        List contents = lay.getContents();
        int size = contents.size();
        ArrayList list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object o = contents.get(i);
            if (o instanceof FigEdge) continue;
            list.add(o);
        }
        return list;
    }

    public static String getId(Fig f) {
        if (f == null) {
            throw new IllegalArgumentException("A fig must be supplied");
        }
        if (f.getGroup() != null) {
            String groupId = f.getGroup().getId();
            if (f.getGroup() instanceof FigGroup) {
                FigGroup group = (FigGroup)f.getGroup();
                return groupId + "." + group.getFigs().indexOf(f);
            }
            if (f.getGroup() instanceof FigEdge) {
                FigEdge edge = (FigEdge)f.getGroup();
                return groupId + "." + (edge.getPathItemFigs().indexOf(f) + 1);
            }
            return groupId + ".0";
        }
        Layer layer = f.getLayer();
        if (layer == null) {
            return "LAYER_NULL";
        }
        List c = layer.getContents();
        int index = c.indexOf(f);
        return "Fig" + index;
    }
}

