/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;

public class FigGroup
extends Fig {
    private static final long serialVersionUID = -6310938507588533546L;
    private ArrayList figs;
    private int _extraFrameSpace = 0;
    private Color textColor = Color.black;
    private Color textFillColor = Color.white;
    private boolean textFilled = false;
    private boolean suppressCalcBounds;

    public FigGroup() {
        this.figs = new ArrayList();
    }

    public FigGroup(List figs) {
        this.figs = new ArrayList(figs);
        this.calcBounds();
    }

    public void parseDynObjects(String dynStr) {
    }

    public void addFig(Fig fig) {
        Fig group = fig.getGroup();
        if (group != this) {
            if (group != null) {
                ((FigGroup)group).removeFig(fig);
            }
            this.figs.add(fig);
            fig.setGroup(this);
            this.calcBounds();
        }
    }

    public void addFigs(Collection figs) {
        Iterator figIter = figs.iterator();
        while (figIter.hasNext()) {
            this.addFig((Fig)figIter.next());
        }
        this.calcBounds();
    }

    public void setFigs(Collection figs) {
        this.figs.clear();
        this.addFigs(figs);
    }

    public void calcBounds() {
        if (this.suppressCalcBounds) {
            return;
        }
        Rectangle boundingBox = null;
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = (Fig)this.figs.get(figIndex);
            if (!f.isVisible()) continue;
            if (boundingBox == null) {
                boundingBox = f.getBounds();
                continue;
            }
            boundingBox.add(this.getSubFigBounds(f));
        }
        if (boundingBox == null) {
            boundingBox = new Rectangle(0, 0, 0, 0);
        }
        this._x = boundingBox.x;
        this._y = boundingBox.y;
        this._w = boundingBox.width;
        this._h = boundingBox.height + this._extraFrameSpace;
    }

    protected Rectangle getSubFigBounds(Fig subFig) {
        return subFig.getBounds();
    }

    public Object clone() {
        FigGroup figClone = (FigGroup)super.clone();
        int figCount = this.figs.size();
        ArrayList<Fig> figsClone = new ArrayList<Fig>(figCount);
        for (int i = 0; i < figCount; ++i) {
            Fig tempFig = (Fig)this.figs.get(i);
            Fig tempFigClone = (Fig)tempFig.clone();
            figsClone.add(tempFigClone);
            tempFigClone.setGroup(figClone);
        }
        figClone.figs = figsClone;
        return figClone;
    }

    public boolean contains(int x, int y) {
        return this.hitFig(new Rectangle(x, y, 0, 0)) != null;
    }

    public Enumeration elements() {
        return new Vector(this.figs).elements();
    }

    public Iterator iterator() {
        return this.figs.iterator();
    }

    public Fig getFigAt(int i) {
        return (Fig)this.figs.get(i);
    }

    public int getFigCount() {
        return this.figs.size();
    }

    public int getFigPosn(Fig f) {
        return this.figs.indexOf(f);
    }

    public List getFigs() {
        return Collections.unmodifiableList(this.figs);
    }

    public Font getFont() {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (!(ft instanceof FigText)) continue;
            return ((FigText)ft).getFont();
        }
        return null;
    }

    public String getFontFamily() {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (!(ft instanceof FigText)) continue;
            return ((FigText)ft).getFontFamily();
        }
        return "Serif";
    }

    public int getFontSize() {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (!(ft instanceof FigText)) continue;
            return ((FigText)ft).getFontSize();
        }
        return 10;
    }

    public String getPrivateData() {
        Fig enc = this.getEnclosingFig();
        if (enc != null) {
            return "enclosingFig=\"" + enc.getId() + "\"";
        }
        return "";
    }

    public int getExtraFrameSpace() {
        return this._extraFrameSpace;
    }

    public boolean hit(Rectangle r) {
        return this.hitFig(r) != null;
    }

    public Fig hitFig(Rectangle r) {
        if (!this.isVisible()) {
            return null;
        }
        Fig res = null;
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = (Fig)this.figs.get(figIndex);
            if (!f.hit(r)) continue;
            res = f;
        }
        return res;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isRotatable() {
        return false;
    }

    public void paint(Object g) {
        if (this.isVisible()) {
            int figCount = this.figs.size();
            for (int figIndex = 0; figIndex < figCount; ++figIndex) {
                Fig f = (Fig)this.figs.get(figIndex);
                if (!f.isVisible()) continue;
                f.paint(g);
            }
        }
    }

    public void appendSvg(StringBuffer sb) {
        sb.append("<g id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("'");
        this.appendSvgStyle(sb);
        Iterator it = this.getFigs().iterator();
        while (it.hasNext()) {
            Fig fig = (Fig)it.next();
            fig.appendSvg(sb);
        }
        sb.append("</g>");
    }

    public void removeAll() {
        Rectangle oldBounds = this.getBounds();
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = (Fig)this.figs.get(figIndex);
            f.setGroup(null);
        }
        this.figs.clear();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void removeFig(Fig f) {
        if (!this.figs.contains(f)) {
            return;
        }
        Rectangle oldBounds = this.getBounds();
        this.figs.remove(f);
        f.setGroup(null);
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public Collection getDisplayedFigs(Collection c) {
        if (c == null) {
            c = new ArrayList<Fig>();
        }
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = (Fig)this.figs.get(figIndex);
            if (!f.isVisible()) continue;
            c.add(f);
        }
        return c;
    }

    protected void setBoundsImpl(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = (Fig)this.figs.get(figIndex);
            if (!f.isVisible()) continue;
            int newW = this._w == 0 ? 0 : f.getWidth() * w / this._w;
            int newH = this._h == 0 ? 0 : f.getHeight() * h / this._h;
            int newX = this._w == 0 ? x : x + (f.getX() - this._x) * w / this._w;
            int newY = this._h == 0 ? y : y + (f.getY() - this._y) * h / this._h;
            f.setBoundsImpl(newX, newY, newW, newH);
        }
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void setFigs(List figs) {
        Rectangle oldBounds = this.getBounds();
        this.figs = new ArrayList(figs);
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void setFillColor(Color col) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            ((Fig)this.figs.get(i)).setFillColor(col);
        }
        super.setFillColor(col);
    }

    public void setFilled(boolean f) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            ((Fig)this.figs.get(i)).setFilled(f);
        }
        super.setFilled(f);
    }

    public void setFont(Font f) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (!(ft instanceof FigText)) continue;
            ((FigText)ft).setFont(f);
        }
    }

    public void setFontFamily(String s) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (!(ft instanceof FigText)) continue;
            ((FigText)ft).setFontFamily(s);
        }
    }

    public void setFontSize(int s) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (!(ft instanceof FigText)) continue;
            ((FigText)ft).setFontSize(s);
        }
    }

    public void setLineColor(Color col) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            ((Fig)this.figs.get(i)).setLineColor(col);
        }
        super.setLineColor(col);
    }

    public void setLineWidth(int w) {
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            ((Fig)this.figs.get(i)).setLineWidth(w);
        }
        super.setLineWidth(w);
    }

    public void setPrivateData(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, "=\"' ");
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (!tok.equals("enclosingFig")) continue;
            String s = tokenizer.nextToken();
            Integer.parseInt(s);
        }
    }

    public void setTextColor(Color c) {
        this.firePropChange("textColor", this.textColor, c);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setTextColor(c);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setTextColor(c);
        }
        this.textColor = c;
    }

    public void setTextFillColor(Color c) {
        this.firePropChange("textFillColor", this.textFillColor, c);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setTextFillColor(c);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setTextFillColor(c);
        }
        this.textFillColor = c;
    }

    public void setTextFilled(boolean b) {
        this.firePropChange("textFilled", this.textFilled, b);
        int size = this.figs.size();
        for (int i = 0; i < size; ++i) {
            Object ft = this.figs.get(i);
            if (ft instanceof FigText) {
                ((FigText)ft).setTextFilled(b);
                continue;
            }
            if (!(ft instanceof FigGroup)) continue;
            ((FigGroup)ft).setTextFilled(b);
        }
        this.textFilled = b;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getTextFillColor() {
        return this.textFillColor;
    }

    public boolean getTextFilled() {
        return this.textFilled;
    }

    public void setExtraFrameSpace(int extraSpace) {
        this._extraFrameSpace = extraSpace;
    }

    protected void translateImpl(int dx, int dy) {
        Rectangle oldBounds = this.getBounds();
        int figCount = this.figs.size();
        for (int figIndex = 0; figIndex < figCount; ++figIndex) {
            Fig f = (Fig)this.figs.get(figIndex);
            f.translate(dx, dy);
        }
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public Fig deepSelect(Rectangle hitRect) {
        return this;
    }
}

