/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.undo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.tigris.gef.undo.Memento;

public class UndoManager {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private int undoMax = 100;
    private int undoChainCount = 0;
    private int redoChainCount = 0;
    private Collection mementoLocks = new ArrayList();
    private Collection listeners = new ArrayList();
    private boolean newChain = true;
    private boolean undoInProgress = false;
    protected ArrayList undoStack = new ArrayList();
    protected ArrayList redoStack = new ArrayList();
    private static UndoManager instance = new UndoManager();

    protected UndoManager() {
    }

    public static void setInstance(UndoManager manager) {
        manager.listeners = UndoManager.instance.listeners;
        instance = manager;
    }

    public static UndoManager getInstance() {
        return instance;
    }

    public void addMemento(Memento memento) {
        if (this.undoMax == 0) {
            return;
        }
        memento.startChain = this.newChain;
        if (this.newChain) {
            this.emptyRedo();
            this.incrementUndoChainCount();
            this.newChain = false;
            if (this.undoChainCount > this.undoMax) {
                // empty if block
            }
        }
        this.undoStack.add(memento);
    }

    public void setUndoMax(int max) {
        this.undoMax = max;
    }

    public void undo() {
        this.undoInProgress = true;
        boolean startChain = false;
        do {
            Memento memento = this.pop(this.undoStack);
            startChain = memento.isStartChain();
            this.undo(memento);
        } while (!startChain);
        this.decrementUndoChainCount();
        this.incrementRedoChainCount();
        this.undoInProgress = false;
    }

    protected void undo(Memento memento) {
        memento.undo();
        this.redoStack.add(memento);
    }

    public void redo() {
        this.undoInProgress = true;
        do {
            Memento memento = this.pop(this.redoStack);
            this.redo(memento);
        } while (this.redoStack.size() > 0 && !((Memento)this.redoStack.get((int)(this.redoStack.size() - 1))).startChain);
        this.incrementUndoChainCount();
        this.decrementRedoChainCount();
        this.undoInProgress = false;
    }

    protected void redo(Memento memento) {
        memento.redo();
        this.undoStack.add(memento);
    }

    public void emptyUndo() {
        if (this.undoChainCount > 0) {
            this.emptyStack(this.undoStack);
            this.undoChainCount = 0;
            this.fireCanUndo();
        }
    }

    private void emptyRedo() {
        if (this.redoChainCount > 0) {
            this.emptyStack(this.redoStack);
            this.redoChainCount = 0;
            this.fireCanRedo();
        }
    }

    public void empty() {
        this.emptyUndo();
        this.emptyRedo();
    }

    public void startChain() {
        this.newChain = true;
    }

    private void emptyStack(List list) {
        for (int i = 0; i < list.size(); ++i) {
            ((Memento)list.get(i)).dispose();
        }
        list.clear();
    }

    private Memento pop(ArrayList stack) {
        return (Memento)stack.remove(stack.size() - 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireCanUndo() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)i.next();
            listener.propertyChange(new PropertyChangeEvent(this, "canUndo", "", this.getBoolString(this.undoChainCount > 0)));
        }
    }

    private void fireCanRedo() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)i.next();
            listener.propertyChange(new PropertyChangeEvent(this, "canRedo", "", this.getBoolString(this.redoChainCount > 0)));
        }
    }

    private void incrementUndoChainCount() {
        if (++this.undoChainCount == 1) {
            this.fireCanUndo();
        }
    }

    private void decrementUndoChainCount() {
        if (--this.undoChainCount == 0) {
            this.fireCanUndo();
        }
    }

    private void incrementRedoChainCount() {
        if (++this.redoChainCount == 1) {
            this.fireCanRedo();
        }
    }

    private void decrementRedoChainCount() {
        if (--this.redoChainCount == 0) {
            this.fireCanRedo();
        }
    }

    private String getBoolString(boolean b) {
        return b ? TRUE : FALSE;
    }

    public boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    public boolean isGenerateMementos() {
        return this.mementoLocks.size() == 0;
    }

    public void setGenerateMementos(boolean generateMementos) {
    }

    public void addMementoLock(Object lockOwner) {
        this.mementoLocks.add(lockOwner);
    }

    public void removeMementoLock(Object lockOwner) {
        this.mementoLocks.remove(lockOwner);
    }
}

