/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.templates;

import freemarker.template.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jooreports.opendocument.OpenDocumentIO;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.UnzippedDocumentTemplate;
import net.sf.jooreports.templates.ZippedDocumentTemplate;

public class DocumentTemplateFactory {
    private final Configuration freemarkerConfiguration = new Configuration();

    public DocumentTemplateFactory() {
        this.freemarkerConfiguration.setTagSyntax(2);
        this.freemarkerConfiguration.setDefaultEncoding(OpenDocumentIO.UTF_8.name());
        this.freemarkerConfiguration.setOutputEncoding(OpenDocumentIO.UTF_8.name());
    }

    public Configuration getFreemarkerConfiguration() {
        return this.freemarkerConfiguration;
    }

    public DocumentTemplate getTemplate(File file) throws IOException {
        if (file.isDirectory()) {
            return new UnzippedDocumentTemplate(file, this.freemarkerConfiguration);
        }
        return this.getTemplate(new FileInputStream(file));
    }

    public DocumentTemplate getTemplate(InputStream inputStream) throws IOException {
        return new ZippedDocumentTemplate(inputStream, this.freemarkerConfiguration);
    }
}

