/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Dg;
import jxl.biff.drawing.DgContainer;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.ShapeType;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;
import jxl.biff.drawing.Spgr;
import jxl.biff.drawing.SpgrContainer;
import jxl.write.biff.File;

public class SheetDrawingWriter {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$SheetDrawingWriter == null ? (class$jxl$biff$drawing$SheetDrawingWriter = SheetDrawingWriter.class$("jxl.biff.drawing.SheetDrawingWriter")) : class$jxl$biff$drawing$SheetDrawingWriter);
    private ArrayList drawings;
    private boolean drawingsModified;
    private Chart[] charts = new Chart[0];
    private WorkbookSettings workbookSettings;
    static /* synthetic */ Class class$jxl$biff$drawing$SheetDrawingWriter;

    public SheetDrawingWriter(WorkbookSettings ws) {
    }

    public void setDrawings(ArrayList dr, boolean mod) {
        this.drawings = dr;
        this.drawingsModified = mod;
    }

    public void write(File outputFile) throws IOException {
        int i;
        if (this.drawings.size() == 0 && this.charts.length == 0) {
            return;
        }
        boolean modified = this.drawingsModified;
        Iterator i2 = this.drawings.iterator();
        while (i2.hasNext() && !modified) {
            Drawing d = (Drawing)i2.next();
            if (d.getOrigin() == Drawing.READ) continue;
            modified = true;
        }
        if (!modified) {
            this.writeUnmodified(outputFile);
            return;
        }
        int numImages = this.drawings.size();
        Object[] spContainerData = new Object[numImages + this.charts.length];
        int length = 0;
        EscherContainer firstSpContainer = null;
        for (i = 0; i < numImages; ++i) {
            Drawing drawing = (Drawing)this.drawings.get(i);
            EscherContainer spc = drawing.getSpContainer();
            byte[] data = spc.getData();
            spContainerData[i] = data;
            if (i == 0) {
                firstSpContainer = spc;
                continue;
            }
            length += data.length;
        }
        for (i = 0; i < this.charts.length; ++i) {
            EscherContainer spContainer = this.charts[i].getSpContainer();
            byte[] data = spContainer.getBytes();
            data = spContainer.setHeaderData(data);
            spContainerData[i + numImages] = data;
            if (i == 0 && numImages == 0) {
                firstSpContainer = spContainer;
                continue;
            }
            length += data.length;
        }
        Drawing firstDrawing = (Drawing)this.drawings.get(0);
        DgContainer dgContainer = new DgContainer();
        Dg dg = new Dg(numImages + this.charts.length);
        dgContainer.add(dg);
        SpgrContainer spgrContainer = new SpgrContainer();
        SpContainer spContainer = new SpContainer();
        Spgr spgr = new Spgr();
        spContainer.add(spgr);
        Sp sp = new Sp(ShapeType.MIN, 1024, 5);
        spContainer.add(sp);
        spgrContainer.add(spContainer);
        spgrContainer.add(firstSpContainer);
        dgContainer.add(spgrContainer);
        byte[] firstMsoData = dgContainer.getData();
        int len = IntegerHelper.getInt(firstMsoData[4], firstMsoData[5], firstMsoData[6], firstMsoData[7]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 4);
        len = IntegerHelper.getInt(firstMsoData[28], firstMsoData[29], firstMsoData[30], firstMsoData[31]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 28);
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(firstMsoData);
        outputFile.write(msoDrawingRecord);
        ObjRecord objRecord = new ObjRecord(firstDrawing.getObjectId());
        outputFile.write(objRecord);
        for (int i3 = 1; i3 < spContainerData.length; ++i3) {
            byte[] bytes = (byte[])spContainerData[i3];
            msoDrawingRecord = new MsoDrawingRecord(bytes);
            outputFile.write(msoDrawingRecord);
            if (i3 < numImages) {
                Drawing d = (Drawing)this.drawings.get(i3);
                if (d.getType() == ShapeType.PICTURE_FRAME) {
                    objRecord = new ObjRecord(d.getObjectId());
                } else if (d.getType() == ShapeType.HOST_CONTROL) {
                    objRecord = d.getObjRecord();
                }
                outputFile.write(objRecord);
                continue;
            }
            Chart chart = this.charts[i3 - numImages];
            objRecord = chart.getObjRecord();
            outputFile.write(objRecord);
            outputFile.write(chart);
        }
    }

    private void writeUnmodified(File outputFile) throws IOException {
        int i;
        if (this.charts.length == 0 && this.drawings.size() == 0) {
            return;
        }
        if (this.charts.length == 0 && this.drawings.size() != 0) {
            Iterator i2 = this.drawings.iterator();
            while (i2.hasNext()) {
                Drawing d = (Drawing)i2.next();
                outputFile.write(d.getMsoDrawingRecord());
                outputFile.write(d.getObjRecord());
            }
            return;
        }
        if (this.drawings.size() == 0 && this.charts.length != 0) {
            Chart curChart = null;
            for (int i3 = 0; i3 < this.charts.length; ++i3) {
                curChart = this.charts[i3];
                if (curChart.getMsoDrawingRecord() != null) {
                    outputFile.write(curChart.getMsoDrawingRecord());
                }
                if (curChart.getObjRecord() != null) {
                    outputFile.write(curChart.getObjRecord());
                }
                outputFile.write(curChart);
            }
            return;
        }
        int numDrawings = this.drawings.size();
        int length = 0;
        EscherContainer[] spContainers = new EscherContainer[numDrawings + this.charts.length];
        for (i = 0; i < numDrawings; ++i) {
            Drawing d = (Drawing)this.drawings.get(i);
            spContainers[i] = d.getSpContainer();
            if (i <= 0) continue;
            length += spContainers[i].getLength();
        }
        for (i = 0; i < this.charts.length; ++i) {
            spContainers[i + numDrawings] = this.charts[i].getSpContainer();
            length += spContainers[i + numDrawings].getLength();
        }
        DgContainer dgContainer = new DgContainer();
        Dg dg = new Dg(numDrawings + this.charts.length);
        dgContainer.add(dg);
        SpgrContainer spgrContainer = new SpgrContainer();
        SpContainer spContainer = new SpContainer();
        Spgr spgr = new Spgr();
        spContainer.add(spgr);
        Sp sp = new Sp(ShapeType.MIN, 1024, 5);
        spContainer.add(sp);
        spgrContainer.add(spContainer);
        spgrContainer.add(spContainers[0]);
        dgContainer.add(spgrContainer);
        byte[] firstMsoData = dgContainer.getData();
        int len = IntegerHelper.getInt(firstMsoData[4], firstMsoData[5], firstMsoData[6], firstMsoData[7]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 4);
        len = IntegerHelper.getInt(firstMsoData[28], firstMsoData[29], firstMsoData[30], firstMsoData[31]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 28);
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(firstMsoData);
        outputFile.write(msoDrawingRecord);
        ObjRecord objRecord = ((Drawing)this.drawings.get(0)).getObjRecord();
        outputFile.write(objRecord);
        for (int i4 = 1; i4 < spContainers.length; ++i4) {
            byte[] bytes = spContainers[i4].getBytes();
            byte[] bytes2 = spContainers[i4].setHeaderData(bytes);
            msoDrawingRecord = new MsoDrawingRecord(bytes2);
            outputFile.write(msoDrawingRecord);
            if (i4 < numDrawings) {
                objRecord = ((Drawing)this.drawings.get(i4)).getObjRecord();
                outputFile.write(objRecord);
                continue;
            }
            Chart chart = this.charts[i4 - numDrawings];
            objRecord = chart.getObjRecord();
            outputFile.write(objRecord);
            outputFile.write(chart);
        }
    }

    public void setCharts(Chart[] ch) {
        this.charts = ch;
    }

    public Chart[] getCharts() {
        return this.charts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

