/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.aleph;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.andreinc.aleph.UncheckedFormatterException;

public class AlephFormatter {
    private final String str;
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private List<Object> posArguments = new ArrayList<Object>();
    private Style style = Styles.DEFAULT;

    private AlephFormatter(String str) {
        this.str = str;
    }

    public static AlephFormatter str(String str) {
        return new AlephFormatter(str);
    }

    public static AlephFormatter str(String str, Object ... args) {
        AlephFormatter af = new AlephFormatter(str);
        if (args != null) {
            af.posArguments = Arrays.asList(args);
        }
        return af;
    }

    public static AlephFormatter str(String str, Map<String, Object> args) {
        return AlephFormatter.str(str).args(args);
    }

    public static AlephFormatter file(String strPath) {
        return AlephFormatter.str(AlephFormatter.readFromFile(strPath));
    }

    public static AlephFormatter file(String strPath, Charset encoding) {
        return AlephFormatter.str(AlephFormatter.readFromFile(strPath, encoding));
    }

    public static AlephFormatter file(String strPath, Object ... args) {
        return AlephFormatter.str(AlephFormatter.readFromFile(strPath), args);
    }

    public static AlephFormatter file(String strPath, Charset encoding, Object ... args) {
        return AlephFormatter.str(AlephFormatter.readFromFile(strPath, encoding), args);
    }

    public static AlephFormatter file(String strPath, Map<String, Object> args) {
        return AlephFormatter.str(AlephFormatter.readFromFile(strPath), args);
    }

    public static AlephFormatter file(String strPath, Charset encoding, Map<String, Object> args) {
        return AlephFormatter.str(AlephFormatter.readFromFile(strPath, encoding), args);
    }

    public void failIfArgExists(String argName) {
        if (this.arguments.containsKey(argName)) {
            throw UncheckedFormatterException.argumentAlreadyExist(argName);
        }
    }

    public static String readFromFile(String strPath, Charset encoding) {
        try {
            byte[] encodedBytes = Files.readAllBytes(Paths.get(strPath, new String[0]));
            return new String(encodedBytes, encoding);
        }
        catch (IOException e) {
            throw UncheckedFormatterException.ioExceptionReadingFromFile(strPath, e);
        }
    }

    public static String readFromFile(String strPath) {
        return AlephFormatter.readFromFile(strPath, Charset.forName("UTF8"));
    }

    public AlephFormatter style(Style style) {
        this.style = style;
        return this;
    }

    public AlephFormatter arg(String argName, Object object) {
        this.failIfArgExists(argName);
        this.arguments.put(argName, object);
        return this;
    }

    public AlephFormatter args(Map<String, Object> args) {
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            this.failIfArgExists(entry.getKey());
            this.arguments.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public AlephFormatter args(Object ... args) {
        if (args.length % 2 == 1) {
            throw UncheckedFormatterException.invalidNumberOfArguments(args.length);
        }
        for (int i = 0; i < args.length; i += 2) {
            String key = (String)args[i];
            this.failIfArgExists(key);
            this.arguments.put(key, args[i + 1]);
        }
        return this;
    }

    public String fmt() {
        StringBuilder result = new StringBuilder(this.str.length());
        StringBuilder param = new StringBuilder(16);
        State state = State.FREE_TEXT;
        block6: for (int i = 0; i < this.str.length(); ++i) {
            char chr = this.str.charAt(i);
            state = this.nextState(state, i);
            switch (state) {
                case FREE_TEXT: {
                    result.append(chr);
                    continue block6;
                }
                case PARAM_START: {
                    ++i;
                    continue block6;
                }
                case PARAM: {
                    this.validateParamChar(chr, i);
                    param.append(chr);
                    continue block6;
                }
                case PARAM_END: {
                    this.appendParamValue(param, result);
                    continue block6;
                }
            }
        }
        return result.toString();
    }

    private State nextState(State currentState, int i) {
        switch (currentState) {
            case FREE_TEXT: {
                return this.jumpFromFreeText(this.str, i);
            }
            case PARAM_START: {
                return this.jumpFromParamStart(this.str, i);
            }
            case PARAM: {
                return this.jumpFromParam(this.str, i);
            }
            case PARAM_END: {
                return this.jumpFromParamEnd(this.str, i);
            }
            case ESCAPE_CHAR: {
                return State.FREE_TEXT;
            }
        }
        throw UncheckedFormatterException.invalidStateException(currentState);
    }

    private State jumpFromFreeText(String fmt, int idx) {
        if (this.isEscapeChar(fmt, idx)) {
            return State.ESCAPE_CHAR;
        }
        if (this.isParamStart(fmt, idx)) {
            return State.PARAM_START;
        }
        return State.FREE_TEXT;
    }

    private State jumpFromParamStart(String fmt, int idx) {
        if (this.isParamEnd(fmt, idx)) {
            return State.PARAM_END;
        }
        return State.PARAM;
    }

    private State jumpFromParam(String fmt, int idx) {
        if (this.isParamEnd(fmt, idx)) {
            return State.PARAM_END;
        }
        return State.PARAM;
    }

    private State jumpFromParamEnd(String fmt, int idx) {
        if (this.isEscapeChar(fmt, idx)) {
            return State.ESCAPE_CHAR;
        }
        if (this.isParamStart(fmt, idx)) {
            return State.PARAM_START;
        }
        return State.FREE_TEXT;
    }

    private boolean isParamStart(String fmt, int idx) {
        return this.style.getStartCharacter() == fmt.charAt(idx) && idx + 1 < fmt.length() && this.style.getOpenBracket() == fmt.charAt(idx + 1);
    }

    private boolean isParamEnd(String fmt, int idx) {
        return this.style.getCloseBracket() == fmt.charAt(idx);
    }

    private boolean isEscapeChar(String fmt, int idx) {
        return this.style.getEscapeCharacter() == fmt.charAt(idx);
    }

    private void validateParamChar(char cc, int idx) {
        if (!Character.isDigit(cc) && !Character.isLetter(cc) && '.' != cc) {
            throw UncheckedFormatterException.invalidCharacterInParam(cc, idx);
        }
    }

    private void appendParamValue(StringBuilder param, StringBuilder result) {
        Object objectValue;
        if (param == null) {
            throw UncheckedFormatterException.invalidArgumentName(param);
        }
        String objectName = AlephFormatter.takeUntilDotOrEnd(param);
        try {
            Integer objectIndex = Integer.parseInt(objectName);
            try {
                objectValue = this.posArguments.get(objectIndex);
            }
            catch (IndexOutOfBoundsException e) {
                throw UncheckedFormatterException.invalidPositionalArgumentValue(objectIndex);
            }
        }
        catch (NumberFormatException nex) {
            objectValue = this.arguments.get(objectName);
        }
        Object toAppend = param.length() != 0 ? AlephFormatter.valueInChain(objectValue, param) : AlephFormatter.evaluateIfArray(objectValue);
        result.append(toAppend);
    }

    private static Object evaluateIfArray(Object o) {
        if (null != o && o.getClass().isArray()) {
            return AlephFormatter.arrayToString(o);
        }
        return o;
    }

    private static String arrayToString(Object array) {
        StringBuilder buff = new StringBuilder("[");
        for (int i = 0; i < Array.getLength(array); ++i) {
            buff.append(Array.get(array, i)).append(", ");
        }
        return AlephFormatter.clearLastComma(buff).append("]").toString();
    }

    private static StringBuilder clearLastComma(StringBuilder buff) {
        int lastComma = buff.lastIndexOf(", ");
        if (-1 != lastComma) {
            buff.delete(lastComma, buff.length());
        }
        return buff;
    }

    private static String takeUntilDotOrEnd(StringBuilder buff) {
        String result;
        int firstPointIdx = buff.indexOf(".");
        if (-1 == firstPointIdx) {
            result = buff.toString();
            buff.setLength(0);
        } else {
            result = buff.substring(0, firstPointIdx);
            buff.delete(0, firstPointIdx + 1);
        }
        return result;
    }

    private static Object valueInChain(Object object, StringBuilder paramBuffer) {
        if (object == null || paramBuffer.length() == 0) {
            return AlephFormatter.evaluateIfArray(object);
        }
        String methodName = AlephFormatter.takeUntilDotOrEnd(paramBuffer);
        try {
            Method method = AlephFormatter.getMethodOrGetter(object, methodName);
            if (null == method) {
                return null;
            }
            Object newObject = method.invoke(object, new Object[0]);
            return AlephFormatter.valueInChain(newObject, paramBuffer);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    public static Method getMethodOrGetter(Object object, String methodName) {
        Method method;
        try {
            method = object.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                String capital = methodName.substring(0, 1).toUpperCase();
                String nameCapitalized = "get" + capital + methodName.substring(1);
                method = object.getClass().getMethod(nameCapitalized, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
        return method;
    }

    public static enum Styles implements Style
    {
        DEFAULT('#', '{', '}', '`'),
        DOLLARS('$', '{', '}', '`');

        private final char START_CHARACTER;
        private final char OPEN_BRACKET;
        private final char CLOSE_BRACKET;
        private final char ESCAPE_CHARACTER;

        private Styles(char START_CHARACTER, char OPEN_BRACKET, char CLOSE_BRACKET, char ESCAPE_CHARACTER) {
            this.START_CHARACTER = START_CHARACTER;
            this.OPEN_BRACKET = OPEN_BRACKET;
            this.CLOSE_BRACKET = CLOSE_BRACKET;
            this.ESCAPE_CHARACTER = ESCAPE_CHARACTER;
        }

        @Override
        public char getStartCharacter() {
            return this.START_CHARACTER;
        }

        @Override
        public char getOpenBracket() {
            return this.OPEN_BRACKET;
        }

        @Override
        public char getCloseBracket() {
            return this.CLOSE_BRACKET;
        }

        @Override
        public char getEscapeCharacter() {
            return this.ESCAPE_CHARACTER;
        }
    }

    public static interface Style {
        public char getStartCharacter();

        public char getOpenBracket();

        public char getCloseBracket();

        public char getEscapeCharacter();
    }

    protected static enum State {
        FREE_TEXT,
        PARAM,
        PARAM_START,
        PARAM_END,
        ESCAPE_CHAR;

    }
}

