/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ExceptionSerializer
implements JsonDeserializer<Exception>,
JsonSerializer<Exception> {
    @Override
    public Exception deserialize(JsonElement stackTraceElementArray, Type object, JsonDeserializationContext jsonDeserializationContext) {
        stackTraceElementArray = stackTraceElementArray.getAsJsonObject();
        try {
            object = (Exception)Class.forName(stackTraceElementArray.get("class").getAsString()).getConstructor(String.class).newInstance(stackTraceElementArray.get("message").getAsString());
            stackTraceElementArray = (StackTraceElement[])jsonDeserializationContext.deserialize(stackTraceElementArray.get("stackTrace"), (Type)((Object)StackTraceElement[].class));
            ((Throwable)object).setStackTrace(stackTraceElementArray);
            return object;
        }
        catch (Exception exception) {
            return exception;
        }
    }

    @Override
    public JsonElement serialize(Exception exception, Type object, JsonSerializationContext jsonSerializationContext) {
        object = new JsonObject();
        ((JsonObject)object).addProperty("class", exception.getClass().getName());
        ((JsonObject)object).addProperty("message", exception.getMessage());
        ((JsonObject)object).add("stackTrace", jsonSerializationContext.serialize(exception.getStackTrace()));
        return object;
    }
}

