/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.AbstractSession;
import com.google.code.gsonrmi.transport.rmi.Callback;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;

public class Call {
    public final List<Route> targets;
    public final String method;
    public final Parameter[] params;
    public Callback callback;
    long a;
    public static int defaultExpireSec = 60;
    public int expireSec = defaultExpireSec;

    public Call(Route route, String string, Object ... objectArray) {
        this(Arrays.asList(route), string, objectArray);
    }

    public Call(List<Route> list, String string, Object ... objectArray) {
        this.targets = list;
        this.method = string;
        this.params = Call.a(objectArray);
    }

    public Call expire(int n2) {
        this.expireSec = n2;
        return this;
    }

    public boolean isExpired() {
        return this.expireSec > 0 && System.currentTimeMillis() - this.a > (long)(this.expireSec * 1000);
    }

    public Call callback(URI uRI, String string, Object ... objectArray) {
        return this.callback(new Route(uRI), string, objectArray);
    }

    public Call callback(Route route, String string, Object ... objectArray) {
        this.callback = new Callback();
        this.callback.target = route;
        this.callback.method = string;
        this.callback.params = Call.a(objectArray);
        return this;
    }

    public Call session(AbstractSession abstractSession) {
        if (this.callback == null) {
            throw new RuntimeException("Callback must be set before session");
        }
        if (abstractSession.id == null) {
            abstractSession.id = UUID.randomUUID().toString();
        }
        try {
            this.callback.session = abstractSession;
            this.callback.target.hops[0] = new URI(this.callback.target.hops[0].getScheme(), this.callback.target.hops[0].getSchemeSpecificPart(), abstractSession.id);
            return this;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public void send(Transport transport) {
        transport.send(this.a());
    }

    public TimerTask sendAfter(Transport transport, long l2) {
        return transport.sendAfter(this.a(), l2);
    }

    public TimerTask sendEvery(Transport transport, long l2, long l3) {
        return transport.sendEvery(this.a(), l2, l3);
    }

    private Message a() {
        return new Message(null, Arrays.asList(new Route(URI.create("rmi:service"))), this);
    }

    private static Parameter[] a(Object[] objectArray) {
        Parameter[] parameterArray = new Parameter[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            parameterArray[i2] = objectArray[i2] instanceof Parameter ? (Parameter)objectArray[i2] : new Parameter(objectArray[i2]);
        }
        return parameterArray;
    }
}

