/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Proxy$CheckConnection;
import com.google.code.gsonrmi.transport.Proxy$OnConnectionClosed;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.Transport$Shutdown;
import com.google.code.gsonrmi.transport.rmi.Call;
import com.google.code.gsonrmi.transport.rmi.Callback;
import com.google.code.gsonrmi.transport.rmi.DefaultRpcHandler;
import com.google.code.gsonrmi.transport.rmi.RmiError;
import com.google.code.gsonrmi.transport.rmi.RmiService$Options;
import com.google.code.gsonrmi.transport.rmi.RpcHandler;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RmiService
extends MessageProcessor {
    public static final String SCHEME = "rmi";
    private final URI a;
    private final Transport a;
    private final Gson a;
    private final Map<String, RpcHandler> a;
    private final Map<Integer, Call> b;
    private final TimerTask a;
    private int a = new URI("rmi", "service", null);

    public RmiService(Transport transport, Gson gson) {
        this(transport, gson, new RmiService$Options());
    }

    public RmiService(Transport transport, Gson gson, RmiService$Options rmiService$Options) {
        this.a = transport;
        this.a.register(SCHEME, this.mq);
        this.a = gson;
        this.a = new HashMap();
        this.a.put(this.a.getSchemeSpecificPart(), new DefaultRpcHandler(this, this.a));
        this.b = new HashMap<Integer, Call>();
        this.a = new Call(new Route(this.a), "periodicCleanup", new Object[0]).sendEvery(this.a, rmiService$Options.cleanupInterval, rmiService$Options.cleanupInterval);
    }

    @RMI
    public URI register(String string, Object object) {
        if (object instanceof RpcHandler) {
            this.a.put(string, (RpcHandler)object);
        } else {
            this.a.put(string, new DefaultRpcHandler(object, this.a));
        }
        return new URI(SCHEME, string, null);
    }

    @Override
    protected void process(Message object) {
        if (((Message)object).contentOfType(Call.class)) {
            Call call = ((Message)object).getContentAs(Call.class, this.a);
            object = this;
            call.a = System.currentTimeMillis();
            if ("_onConnectionClosed".equals(call.method)) {
                if (call.params.length != 0) {
                    System.err.println("WARN: _onConnectionClosed accepts no params");
                }
                if (call.callback != null) {
                    Proxy$OnConnectionClosed proxy$OnConnectionClosed = new Proxy$OnConnectionClosed();
                    Parameter[] parameterArray = Arrays.copyOf(call.callback.params, call.callback.params.length + 1);
                    Parameter[] parameterArray2 = parameterArray;
                    parameterArray[parameterArray.length - 1] = new Parameter(call.callback.method);
                    proxy$OnConnectionClosed.data = new Parameter(parameterArray2);
                    ((RmiService)object).a.send(new Message(call.callback.target, call.targets, proxy$OnConnectionClosed));
                    return;
                }
                System.err.println("_onConnectionClosed requires a callback");
                return;
            }
            Integer n2 = null;
            if (call.callback != null) {
                n2 = ++((RmiService)object).a;
                ((RmiService)object).b.put(n2, call);
            }
            if ("_checkConnection".equals(call.method)) {
                if (call.callback != null) {
                    Proxy$CheckConnection proxy$CheckConnection = new Proxy$CheckConnection();
                    new Proxy$CheckConnection().data = new Parameter(n2);
                    ((RmiService)object).a.send(new Message(call.callback.target, call.targets, proxy$CheckConnection));
                    return;
                }
                System.err.println("_checkConnection requires a callback");
                return;
            }
            RpcRequest rpcRequest = new RpcRequest();
            new RpcRequest().method = call.method;
            rpcRequest.params = call.params;
            rpcRequest.id = n2 != null ? new Parameter(n2) : null;
            ((RmiService)object).a.send(new Message(call.callback != null ? call.callback.target : new Route(((RmiService)object).a), call.targets, rpcRequest));
            return;
        }
        if (((Message)object).contentOfType(RpcRequest.class)) {
            Route route = ((Message)object).src;
            Object object2 = ((Message)object).dests;
            RpcRequest rpcRequest = ((Message)object).getContentAs(RpcRequest.class, this.a);
            object = this;
            Iterator<Route> iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3;
                Route route2 = iterator.next();
                URI uRI = route2.hops[0];
                if (rpcRequest.method.equals("registerCapabilities")) {
                    for (int i2 = 0; i2 < rpcRequest.params.length; ++i2) {
                        System.out.println(rpcRequest.params[i2]);
                        if (rpcRequest.params[i2] != null) continue;
                        object3 = route.hops[0].getAuthority();
                        object3 = new JsonPrimitive((String)object3);
                        rpcRequest.params[i2] = new Parameter((JsonElement)object3);
                    }
                }
                if ((object2 = (RpcHandler)((RmiService)object).a.get(uRI.getSchemeSpecificPart())) != null) {
                    object3 = object2.handle(rpcRequest, route2, route);
                } else {
                    object3 = new RpcResponse();
                    new RpcResponse().id = rpcRequest.id;
                    ((RpcResponse)object3).error = new RpcError(RmiError.TARGET_NOT_FOUND, uRI);
                }
                if (object3 == null) continue;
                if (((RpcResponse)object3).id != null) {
                    ((RmiService)object).a.send(new Message(route2, Arrays.asList(route), object3));
                    continue;
                }
                if (((RpcResponse)object3).error == null) continue;
                System.err.println("Notification failed:  " + uRI + " method " + rpcRequest.method + ", " + ((RpcResponse)object3).error);
                if (!((RpcResponse)object3).error.equals(RpcError.INVOCATION_EXCEPTION)) continue;
                ((RpcResponse)object3).error.data.getValue(Exception.class, ((RmiService)object).a).printStackTrace();
            }
            return;
        }
        if (((Message)object).contentOfType(RpcResponse.class)) {
            this.a(((Message)object).getContentAs(RpcResponse.class, this.a), ((Message)object).dests.get(0), Arrays.asList(((Message)object).src));
            return;
        }
        if (((Message)object).contentOfType(DeliveryFailure.class)) {
            Route route = ((Message)object).src;
            Route route3 = ((Message)object).dests.get(0);
            DeliveryFailure deliveryFailure = ((Message)object).getContentAs(DeliveryFailure.class, this.a);
            object = this;
            if (deliveryFailure.message.contentOfType(RpcRequest.class)) {
                RpcRequest rpcRequest = deliveryFailure.message.getContentAs(RpcRequest.class, ((RmiService)object).a);
                if (rpcRequest.id != null) {
                    RpcResponse rpcResponse = new RpcResponse();
                    new RpcResponse().id = rpcRequest.id;
                    rpcResponse.error = RmiError.UNREACHABLE;
                    super.a(rpcResponse, route3, RmiService.a(deliveryFailure.message.dests, route));
                    return;
                }
                System.err.println("Failed to deliver notification(s): " + rpcRequest.method);
                return;
            }
            if (deliveryFailure.message.contentOfType(RpcResponse.class)) {
                Integer n3 = deliveryFailure.message.getContentAs(RpcResponse.class, (Gson)((RmiService)object).a).id.getValue(Integer.class, ((RmiService)object).a);
                System.err.println("Failed to deliver response with id " + n3);
                return;
            }
            if (deliveryFailure.message.contentOfType(Proxy$CheckConnection.class)) {
                Proxy$CheckConnection proxy$CheckConnection = deliveryFailure.message.getContentAs(Proxy$CheckConnection.class, ((RmiService)object).a);
                RpcResponse rpcResponse = new RpcResponse();
                new RpcResponse().id = proxy$CheckConnection.data;
                rpcResponse.error = RmiError.UNREACHABLE;
                super.a(rpcResponse, route3, RmiService.a(deliveryFailure.message.dests, route));
                return;
            }
            if (deliveryFailure.message.contentOfType(Proxy$OnConnectionClosed.class)) {
                Proxy$OnConnectionClosed proxy$OnConnectionClosed = deliveryFailure.message.getContentAs(Proxy$OnConnectionClosed.class, ((RmiService)object).a);
                Callback callback = new Callback();
                new Callback().target = route3;
                Parameter[] parameterArray = proxy$OnConnectionClosed.data.getValue(Parameter[].class, ((RmiService)object).a);
                callback.method = parameterArray[parameterArray.length - 1].getValue(String.class, ((RmiService)object).a);
                callback.params = Arrays.copyOfRange(parameterArray, 0, parameterArray.length - 1);
                RpcResponse rpcResponse = new RpcResponse();
                new RpcResponse().error = RmiError.UNREACHABLE;
                super.a(callback, rpcResponse, route3, RmiService.a(deliveryFailure.message.dests, route));
                return;
            }
            System.err.println("Unhandled delivery failure of " + deliveryFailure.message.contentType);
            return;
        }
        if (((Message)object).contentOfType(Transport$Shutdown.class)) {
            ((Message)object).getContentAs(Transport$Shutdown.class, this.a);
            this.a();
            return;
        }
        if (!((Message)object).contentOfType(Proxy$CheckConnection.class) && !((Message)object).contentOfType(Proxy$OnConnectionClosed.class)) {
            System.err.println("Unhandled message type: " + ((Message)object).contentType);
        }
    }

    private void a(RpcResponse rpcResponse, Route route, List<Route> list) {
        Integer n2 = rpcResponse.id.getValue(Integer.class, this.a);
        Call call = this.b.get(n2);
        if (call != null) {
            this.a(call.callback, rpcResponse, route, list);
            return;
        }
        System.err.println("No pending request with id " + n2);
    }

    private void a() {
        Iterator iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            ((RpcHandler)iterator.next()).shutdown();
        }
        this.a.cancel();
    }

    @RMI
    public void periodicCleanup() {
        int n2 = this.b.size();
        Iterator<Call> iterator = this.b.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isExpired()) continue;
            iterator.remove();
        }
        if (this.b.size() < n2) {
            System.err.println("INFO: cleanup pending calls " + n2 + " -> " + this.b.size());
        }
        iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            ((RpcHandler)((Object)iterator.next())).periodicCleanup();
        }
    }

    private static List<Route> a(List<Route> object, Route route) {
        LinkedList<Route> linkedList = new LinkedList<Route>();
        object = object.iterator();
        while (object.hasNext()) {
            Route route2 = (Route)object.next();
            linkedList.add(route2.addFirst(route.hops));
        }
        return linkedList;
    }

    private void a(Callback callback, RpcResponse rpcResponse, Route route, List<Route> list) {
        URI uRI = route.hops[0];
        RpcHandler rpcHandler = (RpcHandler)this.a.get(uRI.getSchemeSpecificPart());
        if (rpcHandler != null) {
            rpcHandler.handle(rpcResponse, route, list, callback);
            return;
        }
        System.err.println("Callback target not found " + uRI);
    }
}

