/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.JsonTreeWriter$1;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer a = new JsonTreeWriter$1();
    private static final JsonPrimitive a = new JsonPrimitive("closed");
    private final List<JsonElement> a;
    private String a;
    private JsonElement a = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(a);
    }

    public final JsonElement get() {
        if (!this.a.isEmpty()) {
            throw new IllegalStateException("Expected one JSON element but was " + this.a);
        }
        return this.a;
    }

    private JsonElement a() {
        return (JsonElement)this.a.get(this.a.size() - 1);
    }

    private void a(JsonElement jsonElement) {
        if (this.a != null) {
            if (!jsonElement.isJsonNull() || this.getSerializeNulls()) {
                ((JsonObject)this.a()).add(this.a, jsonElement);
            }
            this.a = null;
            return;
        }
        if (this.a.isEmpty()) {
            this.a = jsonElement;
            return;
        }
        JsonElement jsonElement2 = this.a();
        if (jsonElement2 instanceof JsonArray) {
            ((JsonArray)jsonElement2).add(jsonElement);
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter beginArray() {
        JsonArray jsonArray = new JsonArray();
        this.a(jsonArray);
        this.a.add(jsonArray);
        return this;
    }

    @Override
    public final JsonWriter endArray() {
        if (this.a.isEmpty() || this.a != null) {
            throw new IllegalStateException();
        }
        if (this.a() instanceof JsonArray) {
            this.a.remove(this.a.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter beginObject() {
        JsonObject jsonObject = new JsonObject();
        this.a(jsonObject);
        this.a.add(jsonObject);
        return this;
    }

    @Override
    public final JsonWriter endObject() {
        if (this.a.isEmpty() || this.a != null) {
            throw new IllegalStateException();
        }
        if (this.a() instanceof JsonObject) {
            this.a.remove(this.a.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter name(String string) {
        if (this.a.isEmpty() || this.a != null) {
            throw new IllegalStateException();
        }
        if (this.a() instanceof JsonObject) {
            this.a = string;
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public final JsonWriter value(String string) {
        if (string == null) {
            return this.nullValue();
        }
        this.a(new JsonPrimitive(string));
        return this;
    }

    @Override
    public final JsonWriter nullValue() {
        this.a(JsonNull.INSTANCE);
        return this;
    }

    @Override
    public final JsonWriter value(boolean bl2) {
        this.a(new JsonPrimitive(bl2));
        return this;
    }

    @Override
    public final JsonWriter value(double d2) {
        if (!this.isLenient() && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + d2);
        }
        this.a(new JsonPrimitive(d2));
        return this;
    }

    @Override
    public final JsonWriter value(long l2) {
        this.a(new JsonPrimitive(l2));
        return this;
    }

    @Override
    public final JsonWriter value(Number number) {
        double d2;
        if (number == null) {
            return this.nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d2 = number.doubleValue()) || Double.isInfinite(d2))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + number);
        }
        this.a(new JsonPrimitive(number));
        return this;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
        if (!this.a.isEmpty()) {
            throw new IOException("Incomplete document");
        }
        this.a.add(a);
    }
}

