/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.stream.JsonScope;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] a = new String[128];
    private static final String[] b;
    private final Writer a;
    private final List<JsonScope> a;
    private String a;
    private String b;
    private boolean a = new ArrayList();
    private boolean b;
    private String c;
    private boolean c;

    public JsonWriter(Writer writer) {
        this.a.add(JsonScope.EMPTY_DOCUMENT);
        this.b = ":";
        this.c = true;
        if (writer == null) {
            throw new NullPointerException("out == null");
        }
        this.a = writer;
    }

    public final void setIndent(String string) {
        if (string.length() == 0) {
            this.a = null;
            this.b = ":";
            return;
        }
        this.a = string;
        this.b = ": ";
    }

    public final void setLenient(boolean bl2) {
        this.a = bl2;
    }

    public boolean isLenient() {
        return this.a;
    }

    public final void setHtmlSafe(boolean bl2) {
        this.b = bl2;
    }

    public final boolean isHtmlSafe() {
        return this.b;
    }

    public final void setSerializeNulls(boolean bl2) {
        this.c = bl2;
    }

    public final boolean getSerializeNulls() {
        return this.c;
    }

    public JsonWriter beginArray() {
        this.a();
        return this.a(JsonScope.EMPTY_ARRAY, "[");
    }

    public JsonWriter endArray() {
        return this.a(JsonScope.EMPTY_ARRAY, JsonScope.NONEMPTY_ARRAY, "]");
    }

    public JsonWriter beginObject() {
        this.a();
        return this.a(JsonScope.EMPTY_OBJECT, "{");
    }

    public JsonWriter endObject() {
        return this.a(JsonScope.EMPTY_OBJECT, JsonScope.NONEMPTY_OBJECT, "}");
    }

    private JsonWriter a(JsonScope jsonScope, String string) {
        this.a(true);
        this.a.add(jsonScope);
        this.a.write(string);
        return this;
    }

    private JsonWriter a(JsonScope jsonScope, JsonScope jsonScope2, String string) {
        JsonScope jsonScope3 = this.a();
        if (jsonScope3 != jsonScope2 && jsonScope3 != jsonScope) {
            throw new IllegalStateException("Nesting problem: " + this.a);
        }
        if (this.c != null) {
            throw new IllegalStateException("Dangling name: " + this.c);
        }
        this.a.remove(this.a.size() - 1);
        if (jsonScope3 == jsonScope2) {
            this.b();
        }
        this.a.write(string);
        return this;
    }

    private JsonScope a() {
        int n2 = this.a.size();
        if (n2 == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return (JsonScope)((Object)this.a.get(n2 - 1));
    }

    private void a(JsonScope jsonScope) {
        this.a.set(this.a.size() - 1, jsonScope);
    }

    public JsonWriter name(String string) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.c != null) {
            throw new IllegalStateException();
        }
        if (this.a.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.c = string;
        return this;
    }

    private void a() {
        if (this.c != null) {
            JsonWriter jsonWriter = this;
            JsonScope jsonScope = jsonWriter.a();
            if (jsonScope == JsonScope.NONEMPTY_OBJECT) {
                jsonWriter.a.write(44);
            } else if (jsonScope != JsonScope.EMPTY_OBJECT) {
                throw new IllegalStateException("Nesting problem: " + jsonWriter.a);
            }
            jsonWriter.b();
            jsonWriter.a(JsonScope.DANGLING_NAME);
            this.a(this.c);
            this.c = null;
        }
    }

    public JsonWriter value(String string) {
        if (string == null) {
            return this.nullValue();
        }
        this.a();
        this.a(false);
        this.a(string);
        return this;
    }

    public JsonWriter nullValue() {
        if (this.c != null) {
            if (this.c) {
                this.a();
            } else {
                this.c = null;
                return this;
            }
        }
        this.a(false);
        this.a.write("null");
        return this;
    }

    public JsonWriter value(boolean bl2) {
        this.a();
        this.a(false);
        this.a.write(bl2 ? "true" : "false");
        return this;
    }

    public JsonWriter value(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + d2);
        }
        this.a();
        this.a(false);
        this.a.append(Double.toString(d2));
        return this;
    }

    public JsonWriter value(long l2) {
        this.a();
        this.a(false);
        this.a.write(Long.toString(l2));
        return this;
    }

    public JsonWriter value(Number number) {
        if (number == null) {
            return this.nullValue();
        }
        this.a();
        String string = number.toString();
        if (!this.a && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + number);
        }
        this.a(false);
        this.a.append(string);
        return this;
    }

    @Override
    public void flush() {
        if (this.a.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.a.flush();
    }

    @Override
    public void close() {
        this.a.close();
        int n2 = this.a.size();
        if (n2 > 1 || n2 == 1 && this.a.get(n2 - 1) != JsonScope.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
        this.a.clear();
    }

    private void a(String string) {
        String[] stringArray = this.b ? b : a;
        this.a.write("\"");
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c2 != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n2 < i2) {
                this.a.write(string, n2, i2 - n2);
            }
            this.a.write(string2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            this.a.write(string, n2, n3 - n2);
        }
        this.a.write("\"");
    }

    private void b() {
        if (this.a == null) {
            return;
        }
        this.a.write("\n");
        for (int i2 = 1; i2 < this.a.size(); ++i2) {
            this.a.write(this.a);
        }
    }

    private void a(boolean bl2) {
        switch (this.a()) {
            case NONEMPTY_DOCUMENT: {
                if (!this.a) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case EMPTY_DOCUMENT: {
                if (!this.a && !bl2) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.a(JsonScope.NONEMPTY_DOCUMENT);
                return;
            }
            case EMPTY_ARRAY: {
                this.a(JsonScope.NONEMPTY_ARRAY);
                this.b();
                return;
            }
            case NONEMPTY_ARRAY: {
                this.a.append(',');
                this.b();
                return;
            }
            case DANGLING_NAME: {
                this.a.append(this.b);
                this.a(JsonScope.NONEMPTY_OBJECT);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem: " + this.a);
    }

    static {
        for (int i2 = 0; i2 <= 31; ++i2) {
            JsonWriter.a[i2] = String.format("\\u%04x", i2);
        }
        JsonWriter.a[34] = "\\\"";
        JsonWriter.a[92] = "\\\\";
        JsonWriter.a[9] = "\\t";
        JsonWriter.a[8] = "\\b";
        JsonWriter.a[10] = "\\n";
        JsonWriter.a[13] = "\\r";
        JsonWriter.a[12] = "\\f";
        String[] stringArray = (String[])a.clone();
        b = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.b[62] = "\\u003e";
        JsonWriter.b[38] = "\\u0026";
        JsonWriter.b[61] = "\\u003d";
        JsonWriter.b[39] = "\\u0027";
    }
}

