/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.Encoder;
import com.google.zxing.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset a = Charset.forName("ISO-8859-1");

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string, barcodeFormat, n2, n3, null);
    }

    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> object) {
        Charset charset = a;
        int n4 = 33;
        int n5 = 0;
        if (object != null) {
            if (object.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                charset = Charset.forName(object.get((Object)EncodeHintType.CHARACTER_SET).toString());
            }
            if (object.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                n4 = Integer.parseInt(object.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (object.containsKey((Object)EncodeHintType.AZTEC_LAYERS)) {
                n5 = Integer.parseInt(object.get((Object)EncodeHintType.AZTEC_LAYERS).toString());
            }
        }
        int n6 = n4;
        n4 = n5;
        int n7 = n6;
        object = charset;
        if (barcodeFormat != BarcodeFormat.AZTEC) {
            throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)barcodeFormat));
        }
        return AztecWriter.a(Encoder.encode(string.getBytes((Charset)object), n7, n4), n2, n3);
    }

    private static BitMatrix a(AztecCode object, int n2, int n3) {
        if ((object = ((AztecCode)object).getMatrix()) == null) {
            throw new IllegalStateException();
        }
        int n4 = ((BitMatrix)object).getWidth();
        int n5 = ((BitMatrix)object).getHeight();
        n2 = Math.max(n2, n4);
        n3 = Math.max(n3, n5);
        int n6 = Math.min(n2 / n4, n3 / n5);
        int n7 = (n2 - n4 * n6) / 2;
        int n8 = (n3 - n5 * n6) / 2;
        BitMatrix bitMatrix = new BitMatrix(n2, n3);
        n3 = 0;
        while (n3 < n5) {
            int n9 = 0;
            int n10 = n7;
            while (n9 < n4) {
                if (((BitMatrix)object).get(n9, n3)) {
                    bitMatrix.setRegion(n10, n8, n6, n6);
                }
                ++n9;
                n10 += n6;
            }
            ++n3;
            n8 += n6;
        }
        return bitMatrix;
    }
}

