/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.aztec.decoder.Decoder$Table;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Decoder {
    private static final String[] a = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] b = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] c = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] d = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] e = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult a;

    public final DecoderResult decode(AztecDetectorResult object) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.a = object;
        Object object2 = object = ((DetectorResult)object).getBits();
        Decoder decoder = this;
        int n6 = decoder.a.isCompact();
        int n7 = decoder.a.getNbLayers();
        int n8 = (n6 != 0 ? 11 : 14) + (n7 << 2);
        int[] nArray = new int[n8];
        int n9 = n6;
        int n10 = n7;
        boolean[] blArray = new boolean[((n9 != 0 ? 88 : 112) + (n10 << 4)) * n10];
        if (n9 != 0) {
            for (n9 = 0; n9 < nArray.length; ++n9) {
                nArray[n9] = n9;
            }
        } else {
            n9 = n8 + 1 + 2 * ((n8 / 2 - 1) / 15);
            n5 = n8 / 2;
            n4 = n9 / 2;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n3 + n3 / 15;
                nArray[n5 - n3 - 1] = n4 - n2 - 1;
                nArray[n5 + n3] = n4 + n2 + 1;
            }
        }
        n5 = 0;
        for (n9 = 0; n9 < n7; ++n9) {
            n4 = (n7 - n9 << 2) + (n6 != 0 ? 9 : 12);
            n3 = n9 << 1;
            n2 = n8 - 1 - n3;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n11 = i2 << 1;
                for (int i3 = 0; i3 < 2; ++i3) {
                    blArray[n5 + n11 + i3] = ((BitMatrix)object2).get(nArray[n3 + i3], nArray[n3 + i2]);
                    blArray[n5 + 2 * n4 + n11 + i3] = ((BitMatrix)object2).get(nArray[n3 + i2], nArray[n2 - i3]);
                    blArray[n5 + 4 * n4 + n11 + i3] = ((BitMatrix)object2).get(nArray[n2 - i3], nArray[n2 - i2]);
                    blArray[n5 + n4 * 6 + n11 + i3] = ((BitMatrix)object2).get(nArray[n2 - i2], nArray[n3 + i3]);
                }
            }
            n5 += n4 << 3;
        }
        blArray = this.a(blArray);
        Object object3 = blArray;
        object2 = new byte[(blArray.length + 7) / 8];
        for (n6 = 0; n6 < ((Object)object2).length; ++n6) {
            n8 = n6 << 3;
            Object object4 = object3;
            int n12 = ((boolean[])object3).length - n8;
            object2[n6] = n12 >= 8 ? (byte)Decoder.a(object4, n8, 8) : (byte)(Decoder.a(object4, n8, n12) << 8 - n12);
        }
        object3 = object2;
        object2 = Decoder.a(blArray);
        DecoderResult decoderResult = new DecoderResult((byte[])object3, (String)object2, null, null);
        object3 = decoderResult;
        decoderResult.setNumBits(blArray.length);
        return object3;
    }

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.a(blArray);
    }

    private static String a(boolean[] blArray) {
        int n2 = blArray.length;
        Decoder$Table decoder$Table = Decoder$Table.UPPER;
        Decoder$Table decoder$Table2 = Decoder$Table.UPPER;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n3 = 0;
        while (n3 < n2) {
            String string;
            int n4;
            int n5;
            if (decoder$Table2 == Decoder$Table.BINARY) {
                if (n2 - n3 < 5) break;
                int n6 = Decoder.a(blArray, n3, 5);
                n3 += 5;
                if (n6 == 0) {
                    if (n2 - n3 < 11) break;
                    n6 = Decoder.a(blArray, n3, 11) + 31;
                    n3 += 11;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    if (n2 - n3 < 8) {
                        n3 = n2;
                        break;
                    }
                    int n7 = Decoder.a(blArray, n3, 8);
                    stringBuilder.append((char)n7);
                    n3 += 8;
                }
                decoder$Table2 = decoder$Table;
                continue;
            }
            int n8 = n4 = decoder$Table2 == Decoder$Table.DIGIT ? 4 : 5;
            if (n2 - n3 < n4) break;
            n5 = Decoder.a(blArray, n3, n4);
            n3 += n4;
            Decoder$Table decoder$Table3 = decoder$Table2;
            switch (decoder$Table3) {
                case UPPER: {
                    string = a[n5];
                    break;
                }
                case LOWER: {
                    string = b[n5];
                    break;
                }
                case MIXED: {
                    string = c[n5];
                    break;
                }
                case PUNCT: {
                    string = d[n5];
                    break;
                }
                case DIGIT: {
                    string = e[n5];
                    break;
                }
                default: {
                    throw new IllegalStateException("Bad table");
                }
            }
            String string2 = string;
            if (string.startsWith("CTRL_")) {
                decoder$Table = decoder$Table2;
                switch (string2.charAt(5)) {
                    case 'L': {
                        Decoder$Table decoder$Table4 = Decoder$Table.LOWER;
                        break;
                    }
                    case 'P': {
                        Decoder$Table decoder$Table4 = Decoder$Table.PUNCT;
                        break;
                    }
                    case 'M': {
                        Decoder$Table decoder$Table4 = Decoder$Table.MIXED;
                        break;
                    }
                    case 'D': {
                        Decoder$Table decoder$Table4 = Decoder$Table.DIGIT;
                        break;
                    }
                    case 'B': {
                        Decoder$Table decoder$Table4 = Decoder$Table.BINARY;
                        break;
                    }
                    default: {
                        Decoder$Table decoder$Table4 = decoder$Table2 = Decoder$Table.UPPER;
                    }
                }
                if (string2.charAt(6) != 'L') continue;
                decoder$Table = decoder$Table2;
                continue;
            }
            stringBuilder.append(string2);
            decoder$Table2 = decoder$Table;
        }
        return stringBuilder.toString();
    }

    private boolean[] a(boolean[] blArray) {
        GenericGF genericGF;
        int n2;
        if (this.a.getNbLayers() <= 2) {
            n2 = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.a.getNbLayers() <= 8) {
            n2 = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.a.getNbLayers() <= 22) {
            n2 = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            n2 = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n3 = this.a.getNbDatablocks();
        int n4 = blArray.length / n2;
        if (n4 < n3) {
            throw FormatException.getFormatInstance();
        }
        int n5 = blArray.length % n2;
        int[] nArray = new int[n4];
        int n6 = 0;
        while (n6 < n4) {
            nArray[n6] = Decoder.a(blArray, n5, n2);
            ++n6;
            n5 += n2;
        }
        try {
            new ReedSolomonDecoder(genericGF).decode(nArray, n4 - n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw FormatException.getFormatInstance(reedSolomonException);
        }
        n6 = (1 << n2) - 1;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = nArray[i2];
            if (n4 == 0 || n4 == n6) {
                throw FormatException.getFormatInstance();
            }
            if (n4 != 1 && n4 != n6 - 1) continue;
            ++n7;
        }
        boolean[] blArray2 = new boolean[n3 * n2 - n7];
        n4 = 0;
        for (n7 = 0; n7 < n3; ++n7) {
            n5 = nArray[n7];
            if (n5 == 1 || n5 == n6 - 1) {
                Arrays.fill(blArray2, n4, n4 + n2 - 1, n5 > 1);
                n4 += n2 - 1;
                continue;
            }
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                blArray2[n4++] = (n5 & 1 << i3) != 0;
            }
        }
        return blArray2;
    }

    private static int a(boolean[] blArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            n4 <<= 1;
            if (!blArray[i2]) continue;
            n4 |= 1;
        }
        return n4;
    }
}

