/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.LuminanceSource;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class BufferedImageLuminanceSource
extends LuminanceSource {
    private final BufferedImage a;
    private final int a;
    private final int b;

    public BufferedImageLuminanceSource(BufferedImage bufferedImage) {
        this(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public BufferedImageLuminanceSource(BufferedImage bufferedImage, int n2, int n3, int n4, int n5) {
        super(n4, n5);
        if (bufferedImage.getType() == 10) {
            this.a = bufferedImage;
        } else {
            int n6 = bufferedImage.getWidth();
            int n7 = bufferedImage.getHeight();
            if (n2 + n4 > n6 || n3 + n5 > n7) {
                throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
            }
            this.a = new BufferedImage(n6, n7, 10);
            WritableRaster writableRaster = this.a.getRaster();
            int[] nArray = new int[n4];
            for (int i2 = n3; i2 < n3 + n5; ++i2) {
                bufferedImage.getRGB(n2, i2, n4, 1, nArray, 0, n6);
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n8 = nArray[i3];
                    if ((n8 & 0xFF000000) == 0) {
                        n8 = -1;
                    }
                    nArray[i3] = 306 * (n8 >> 16 & 0xFF) + 601 * (n8 >> 8 & 0xFF) + 117 * (n8 & 0xFF) + 512 >> 10;
                }
                writableRaster.setPixels(n2, i2, n4, 1, nArray);
            }
        }
        this.a = n2;
        this.b = n3;
    }

    @Override
    public final byte[] getRow(int n2, byte[] byArray) {
        if (n2 < 0 || n2 >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n2);
        }
        int n3 = this.getWidth();
        if (byArray == null || byArray.length < n3) {
            byArray = new byte[n3];
        }
        this.a.getRaster().getDataElements(this.a, this.b + n2, n3, 1, byArray);
        return byArray;
    }

    @Override
    public final byte[] getMatrix() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        byte[] byArray = new byte[n2 * n3];
        this.a.getRaster().getDataElements(this.a, this.b, n2, n3, byArray);
        return byArray;
    }

    @Override
    public final boolean isCropSupported() {
        return true;
    }

    @Override
    public final LuminanceSource crop(int n2, int n3, int n4, int n5) {
        return new BufferedImageLuminanceSource(this.a, this.a + n2, this.b + n3, n4, n5);
    }

    @Override
    public final boolean isRotateSupported() {
        return true;
    }

    @Override
    public final LuminanceSource rotateCounterClockwise() {
        int n2 = this.a.getWidth();
        int n3 = this.a.getHeight();
        AffineTransform affineTransform = new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, (double)n2);
        BufferedImage bufferedImage = new BufferedImage(n3, n2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.a, affineTransform, null);
        graphics2D.dispose();
        int n4 = this.getWidth();
        return new BufferedImageLuminanceSource(bufferedImage, this.b, n2 - (this.a + n4), this.getHeight(), n4);
    }

    @Override
    public final LuminanceSource rotateCounterClockwise45() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = this.a + n2 / 2;
        int n5 = this.b + n3 / 2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-0.7853981633974483, n4, n5);
        int n6 = Math.max(this.a.getWidth(), this.a.getHeight());
        BufferedImage bufferedImage = new BufferedImage(n6, n6, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.a, affineTransform, null);
        graphics2D.dispose();
        n2 = Math.max(n2, n3) / 2;
        n3 = Math.max(0, n4 - n2);
        int n7 = Math.max(0, n5 - n2);
        n4 = Math.min(n6 - 1, n4 + n2);
        n2 = Math.min(n6 - 1, n5 + n2);
        return new BufferedImageLuminanceSource(bufferedImage, n3, n7, n4 - n3, n2 - n7);
    }
}

