/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
final class DecodeWorker
implements Callable<Integer> {
    private final Queue<URI> a;
    private final Map<DecodeHintType, ?> a;

    DecodeWorker(Queue<URI> object) {
        this.a = object;
        ArrayList<BarcodeFormat> arrayList = new ArrayList<BarcodeFormat>();
        arrayList.addAll(Arrays.asList(BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.EAN_13, BarcodeFormat.EAN_8, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED));
        arrayList.addAll(Arrays.asList(BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.ITF, BarcodeFormat.QR_CODE, BarcodeFormat.DATA_MATRIX, BarcodeFormat.AZTEC, BarcodeFormat.PDF_417, BarcodeFormat.CODABAR, BarcodeFormat.MAXICODE));
        object = new EnumMap<DecodeHintType, ArrayList<BarcodeFormat>>(DecodeHintType.class);
        object.put((DecodeHintType)DecodeHintType.POSSIBLE_FORMATS, arrayList);
        this.a = Collections.unmodifiableMap(object);
    }

    @Override
    public final Integer call() {
        URI uRI;
        int n2 = 0;
        while ((uRI = this.a.poll()) != null) {
            if (DecodeWorker.a(uRI, this.a) == null) continue;
            ++n2;
        }
        return n2;
    }

    private static Result[] a(URI uRI, Map<DecodeHintType, ?> resultArray) {
        Object object = ImageReader.readImage(uRI);
        object = new BufferedImageLuminanceSource((BufferedImage)object);
        object = new BinaryBitmap(new HybridBinarizer((LuminanceSource)object));
        Result[] resultArray2 = new MultiFormatReader();
        try {
            resultArray = new Result[]{resultArray2.decode((BinaryBitmap)object, (Map<DecodeHintType, ?>)resultArray)};
        }
        catch (NotFoundException notFoundException) {
            System.out.println(uRI + ": No barcode found");
            return null;
        }
        object = new StringWriter();
        resultArray2 = resultArray;
        for (int i2 = 0; i2 <= 0; ++i2) {
            Result result = resultArray2[i2];
            ParsedResult parsedResult = ResultParser.parseResult(result);
            ((StringWriter)object).write(uRI + " (format: " + (Object)((Object)result.getBarcodeFormat()) + ", type: " + (Object)((Object)parsedResult.getType()) + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult() + "\n");
            ((StringWriter)object).write("Found " + result.getResultPoints().length + " result points.\n");
            for (int i3 = 0; i3 < result.getResultPoints().length; ++i3) {
                ResultPoint resultPoint = result.getResultPoints()[i3];
                ((StringWriter)object).write("  Point " + i3 + ": (" + resultPoint.getX() + ',' + resultPoint.getY() + ')');
                if (i3 == result.getResultPoints().length - 1) continue;
                ((StringWriter)object).write(10);
            }
            ((StringWriter)object).write(10);
        }
        System.out.println(object);
        return resultArray;
    }
}

