/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.decoder.Version;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
final class BitMatrixParser {
    final BitMatrix a;
    final BitMatrix b;
    final Version a;

    BitMatrixParser(BitMatrix bitMatrix) {
        int n2 = bitMatrix.getHeight();
        if (n2 < 8 || n2 > 144 || (n2 & 1) != 0) {
            throw FormatException.getFormatInstance();
        }
        BitMatrix bitMatrix2 = bitMatrix;
        int n3 = bitMatrix2.getHeight();
        int n4 = bitMatrix2.getWidth();
        this.a = Version.getVersionForDimensions(n3, n4);
        this.a = this.a(bitMatrix);
        this.b = new BitMatrix(this.a.getWidth(), this.a.getHeight());
    }

    final boolean a(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 += n4;
            n3 += 4 - (n4 + 4 & 7);
        }
        if (n3 < 0) {
            n3 += n5;
            n2 += 4 - (n5 + 4 & 7);
        }
        this.b.set(n3, n2);
        return this.a.get(n3, n2);
    }

    final int a(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (this.a(n2 - 2, n3 - 2, n4, n5)) {
            n6 = 1;
        }
        n6 <<= 1;
        if (this.a(n2 - 2, n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.a(n2 - 1, n3 - 2, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.a(n2 - 1, n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.a(n2 - 1, n3, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.a(n2, n3 - 2, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.a(n2, n3 - 1, n4, n5)) {
            n6 |= 1;
        }
        n6 <<= 1;
        if (this.a(n2, n3, n4, n5)) {
            n6 |= 1;
        }
        return n6;
    }

    private BitMatrix a(BitMatrix bitMatrix) {
        int n2 = this.a.getSymbolSizeRows();
        int n3 = this.a.getSymbolSizeColumns();
        if (bitMatrix.getHeight() != n2) {
            throw new IllegalArgumentException("Dimension of bitMatrix must match the version size");
        }
        int n4 = this.a.getDataRegionSizeRows();
        int n5 = this.a.getDataRegionSizeColumns();
        int n6 = (n2 /= n4) * n4;
        int n7 = (n3 /= n5) * n5;
        BitMatrix bitMatrix2 = new BitMatrix(n7, n6);
        for (n7 = 0; n7 < n2; ++n7) {
            int n8 = n7 * n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n9 = i2 * n5;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n10 = n7 * (n4 + 2) + 1 + i3;
                    int n11 = n8 + i3;
                    for (int i4 = 0; i4 < n5; ++i4) {
                        int n12 = i2 * (n5 + 2) + 1 + i4;
                        if (!bitMatrix.get(n12, n10)) continue;
                        n12 = n9 + i4;
                        bitMatrix2.set(n12, n11);
                    }
                }
            }
        }
        return bitMatrix2;
    }
}

