/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseDaoImpl$2;
import com.j256.ormlite.dao.BaseDaoImpl$3;
import com.j256.ormlite.dao.BaseDaoImpl$DaoConfigArray;
import com.j256.ormlite.dao.CloseableWrappedIterableImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.Dao$CreateOrUpdateStatus;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.ReferenceObjectCache;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.StatementBuilder$StatementType;
import com.j256.ormlite.stmt.StatementExecutor;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class BaseDaoImpl<T, ID>
implements Dao<T, ID> {
    private boolean initialized;
    protected StatementExecutor<T, ID> statementExecutor;
    protected m databaseType;
    protected final Class<T> dataClass;
    protected DatabaseTableConfig<T> tableConfig;
    protected TableInfo<T, ID> tableInfo;
    protected L connectionSource;
    protected e<T> lastIterator;
    protected k<T> objectFactory$160be2cc;
    private static final ThreadLocal<BaseDaoImpl$DaoConfigArray> daoConfigLevelLocal = new a();
    private static ReferenceObjectCache defaultObjectCache;
    private i objectCache;

    protected BaseDaoImpl(Class<T> clazz) {
        this(null, clazz, null);
    }

    protected BaseDaoImpl(L l2, Class<T> clazz) {
        this(l2, clazz, null);
    }

    protected BaseDaoImpl(L l2, DatabaseTableConfig<T> databaseTableConfig) {
        this(l2, databaseTableConfig.getDataClass(), databaseTableConfig);
    }

    private BaseDaoImpl(L l2, Class<T> clazz, DatabaseTableConfig<T> databaseTableConfig) {
        this.dataClass = clazz;
        this.tableConfig = databaseTableConfig;
        if (l2 != null) {
            this.connectionSource = l2;
            this.initialize();
        }
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.connectionSource == null) {
            throw new IllegalStateException("connectionSource was never set on " + this.getClass().getSimpleName());
        }
        this.databaseType = this.connectionSource.a();
        if (this.databaseType == null) {
            throw new IllegalStateException("connectionSource is getting a null DatabaseType in " + this.getClass().getSimpleName());
        }
        if (this.tableConfig == null) {
            this.tableInfo = new TableInfo(this.connectionSource, this, this.dataClass);
        } else {
            this.tableConfig.extractFieldTypes(this.connectionSource);
            this.tableInfo = new TableInfo(this.databaseType, this, this.tableConfig);
        }
        this.statementExecutor = new StatementExecutor<T, ID>(this.databaseType, this.tableInfo, this);
        BaseDaoImpl$DaoConfigArray baseDaoImpl$DaoConfigArray = daoConfigLevelLocal.get();
        if (baseDaoImpl$DaoConfigArray.size() > 0) {
            baseDaoImpl$DaoConfigArray.addDao(this);
            return;
        }
        baseDaoImpl$DaoConfigArray.addDao(this);
        try {
            for (int i2 = 0; i2 < baseDaoImpl$DaoConfigArray.size(); ++i2) {
                BaseDaoImpl<?, ?> baseDaoImpl = baseDaoImpl$DaoConfigArray.get(i2);
                DaoManager.registerDao(this.connectionSource, baseDaoImpl);
                try {
                    FieldType[] fieldTypeArray = baseDaoImpl.getTableInfo().getFieldTypes();
                    int n2 = fieldTypeArray.length;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        fieldTypeArray[i3].configDaoInformation(this.connectionSource, baseDaoImpl.getDataClass());
                    }
                }
                catch (SQLException sQLException) {
                    DaoManager.unregisterDao(this.connectionSource, baseDaoImpl);
                    throw sQLException;
                }
                baseDaoImpl.initialized = true;
            }
            return;
        }
        finally {
            baseDaoImpl$DaoConfigArray.clear();
        }
    }

    @Override
    public T queryForId(ID object) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.a();
        object = this.statementExecutor.queryForId(databaseConnection, object, this.objectCache);
        return (T)object;
    }

    @Override
    public T queryForFirst$71d1a119$6d15d8e(A<T> a2) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.a();
        a2 = this.statementExecutor.queryForFirst(databaseConnection, a2, this.objectCache);
        return (T)a2;
    }

    @Override
    public List<T> queryForAll() {
        this.checkForInitialized();
        return this.statementExecutor.queryForAll(this.connectionSource, this.objectCache);
    }

    @Override
    public List<T> queryForEq(String string, Object object) {
        return this.queryBuilder().where().eq(string, object).query();
    }

    @Override
    public QueryBuilder<T, ID> queryBuilder() {
        this.checkForInitialized();
        return new QueryBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public UpdateBuilder<T, ID> updateBuilder() {
        this.checkForInitialized();
        return new UpdateBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public x<T, ID> deleteBuilder() {
        this.checkForInitialized();
        return new x<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public List<T> query$4f085612$1c35ffa3(A<T> a2) {
        this.checkForInitialized();
        return this.statementExecutor.query(this.connectionSource, a2, this.objectCache);
    }

    @Override
    public List<T> queryForMatching(T t2) {
        return this.queryForMatching(t2, false);
    }

    @Override
    public List<T> queryForMatchingArgs(T t2) {
        return this.queryForMatching(t2, true);
    }

    @Override
    public List<T> queryForFieldValues(Map<String, Object> map) {
        return this.queryForFieldValues(map, false);
    }

    @Override
    public List<T> queryForFieldValuesArgs(Map<String, Object> map) {
        return this.queryForFieldValues(map, true);
    }

    @Override
    public T queryForSameId(T object) {
        this.checkForInitialized();
        if (object == null) {
            return null;
        }
        if ((object = this.extractId(object)) == null) {
            return null;
        }
        return this.queryForId(object);
    }

    @Override
    public int create(T t2) {
        this.checkForInitialized();
        if (t2 == null) {
            return 0;
        }
        if (t2 instanceof BaseDaoEnabled) {
            ((BaseDaoEnabled)t2).setDao(this);
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.create(databaseConnection, t2, this.objectCache);
        return n2;
    }

    @Override
    public T createIfNotExists(T t2) {
        if (t2 == null) {
            return null;
        }
        T t3 = this.queryForSameId(t2);
        if (t3 == null) {
            this.create(t2);
            return t2;
        }
        return t3;
    }

    @Override
    public Dao$CreateOrUpdateStatus createOrUpdate(T t2) {
        if (t2 == null) {
            return new Dao$CreateOrUpdateStatus(false, false, 0);
        }
        ID ID2 = this.extractId(t2);
        if (ID2 == null || !this.idExists(ID2)) {
            int n2 = this.create(t2);
            return new Dao$CreateOrUpdateStatus(true, false, n2);
        }
        int n3 = this.update(t2);
        return new Dao$CreateOrUpdateStatus(false, true, n3);
    }

    @Override
    public int update(T t2) {
        this.checkForInitialized();
        if (t2 == null) {
            return 0;
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.update(databaseConnection, t2, this.objectCache);
        return n2;
    }

    @Override
    public int updateId(T t2, ID ID2) {
        this.checkForInitialized();
        if (t2 == null) {
            return 0;
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.updateId(databaseConnection, t2, ID2, this.objectCache);
        return n2;
    }

    @Override
    public int update$530ea9c7$bbe4617(A<T> a2) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.update$31d56318$2cf78cc6(databaseConnection, a2);
        return n2;
    }

    @Override
    public int refresh(T t2) {
        this.checkForInitialized();
        if (t2 == null) {
            return 0;
        }
        if (t2 instanceof BaseDaoEnabled) {
            ((BaseDaoEnabled)t2).setDao(this);
        }
        DatabaseConnection databaseConnection = this.connectionSource.a();
        int n2 = this.statementExecutor.refresh(databaseConnection, t2, this.objectCache);
        return n2;
    }

    @Override
    public int delete(T t2) {
        this.checkForInitialized();
        if (t2 == null) {
            return 0;
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.delete(databaseConnection, t2, this.objectCache);
        return n2;
    }

    @Override
    public int deleteById(ID ID2) {
        this.checkForInitialized();
        if (ID2 == null) {
            return 0;
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.deleteById(databaseConnection, ID2, this.objectCache);
        return n2;
    }

    @Override
    public int delete(Collection<T> collection) {
        this.checkForInitialized();
        if (collection == null || collection.isEmpty()) {
            return 0;
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.deleteObjects(databaseConnection, collection, this.objectCache);
        return n2;
    }

    @Override
    public int deleteIds(Collection<ID> collection) {
        this.checkForInitialized();
        if (collection == null || collection.isEmpty()) {
            return 0;
        }
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.deleteIds(databaseConnection, collection, this.objectCache);
        return n2;
    }

    @Override
    public int delete$bbe4617(A<T> a2) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.b();
        int n2 = this.statementExecutor.delete$2cf78cc6(databaseConnection, a2);
        return n2;
    }

    @Override
    public e<T> iterator() {
        return this.iterator(-1);
    }

    @Override
    public e<T> closeableIterator() {
        return this.iterator(-1);
    }

    @Override
    public e<T> iterator(int n2) {
        this.checkForInitialized();
        this.lastIterator = this.createIterator(n2);
        return this.lastIterator;
    }

    @Override
    public f<T> getWrappedIterable() {
        this.checkForInitialized();
        return new CloseableWrappedIterableImpl(new BaseDaoImpl$2(this));
    }

    @Override
    public f<T> getWrappedIterable$3a266739$367a9ae4(A<T> a2) {
        this.checkForInitialized();
        return new CloseableWrappedIterableImpl(new BaseDaoImpl$3(this, a2));
    }

    @Override
    public void closeLastIterator() {
        if (this.lastIterator != null) {
            this.lastIterator.close();
            this.lastIterator = null;
        }
    }

    @Override
    public e<T> iterator$7ffd9508$10f831ad(A<T> a2) {
        return this.iterator$46cb65d9$46f7aa12(a2, -1);
    }

    @Override
    public e<T> iterator$46cb65d9$46f7aa12(A<T> a2, int n2) {
        this.checkForInitialized();
        this.lastIterator = this.createIterator$46cb65d9$46f7aa12(a2, n2);
        return this.lastIterator;
    }

    @Override
    public h<String[]> queryRaw(String string, String ... stringArray) {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, string, stringArray, this.objectCache);
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not perform raw query for " + string, sQLException);
        }
    }

    @Override
    public <GR> h<GR> queryRaw(String string, j<GR> j2, String ... stringArray) {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, string, j2, stringArray, this.objectCache);
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not perform raw query for " + string, sQLException);
        }
    }

    @Override
    public <UO> h<UO> queryRaw(String string, DataType[] dataTypeArray, k<UO> k2, String ... stringArray) {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, string, dataTypeArray, k2, stringArray, this.objectCache);
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not perform raw query for " + string, sQLException);
        }
    }

    @Override
    public h<Object[]> queryRaw(String string, DataType[] dataTypeArray, String ... stringArray) {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, string, dataTypeArray, stringArray, this.objectCache);
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not perform raw query for " + string, sQLException);
        }
    }

    @Override
    public long queryRawValue(String string, String ... stringArray) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.a();
        try {
            long l2 = this.statementExecutor.queryForLong(databaseConnection, string, stringArray);
            return l2;
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not perform raw value query for " + string, sQLException);
        }
    }

    @Override
    public int executeRaw(String string, String ... stringArray) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.b();
        try {
            int n2 = this.statementExecutor.executeRaw(databaseConnection, string, stringArray);
            return n2;
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not run raw execute statement " + string, sQLException);
        }
    }

    @Override
    public int executeRawNoArgs(String string) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.b();
        try {
            int n2 = this.statementExecutor.executeRawNoArgs(databaseConnection, string);
            return n2;
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not run raw execute statement " + string, sQLException);
        }
    }

    @Override
    public int updateRaw(String string, String ... stringArray) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.b();
        try {
            int n2 = this.statementExecutor.updateRaw(databaseConnection, string, stringArray);
            return n2;
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not run raw update statement " + string, sQLException);
        }
    }

    @Override
    public <CT> CT callBatchTasks(Callable<CT> callable) {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.b();
        boolean bl2 = this.connectionSource.a();
        callable = this.statementExecutor.callBatchTasks(databaseConnection, bl2, callable);
        return (CT)callable;
    }

    @Override
    public String objectToString(T t2) {
        this.checkForInitialized();
        return this.tableInfo.objectToString(t2);
    }

    @Override
    public boolean objectsEqual(T t2, T t3) {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object object = fieldType.extractJavaFieldValue(t2);
            Object object2 = fieldType.extractJavaFieldValue(t3);
            if (fieldType.getDataPersister().dataIsEqual(object, object2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ID extractId(T t2) {
        this.checkForInitialized();
        FieldType fieldType = this.tableInfo.getIdField();
        if (fieldType == null) {
            throw new SQLException("Class " + this.dataClass + " does not have an id field");
        }
        return (ID)fieldType.extractJavaFieldValue(t2);
    }

    @Override
    public Class<T> getDataClass() {
        return this.dataClass;
    }

    @Override
    public FieldType findForeignFieldType(Class<?> clazz) {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            if (fieldType.getType() != clazz) continue;
            return fieldType;
        }
        return null;
    }

    @Override
    public boolean isUpdatable() {
        return this.tableInfo.isUpdatable();
    }

    @Override
    public boolean isTableExists() {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.a();
        boolean bl2 = databaseConnection.isTableExists(this.tableInfo.getTableName());
        return bl2;
    }

    @Override
    public long countOf() {
        this.checkForInitialized();
        DatabaseConnection databaseConnection = this.connectionSource.a();
        long l2 = this.statementExecutor.queryForCountStar(databaseConnection);
        return l2;
    }

    @Override
    public long countOf$7134af2d$bbe4618(A<T> a2) {
        this.checkForInitialized();
        if (a2.getType() != StatementBuilder$StatementType.SELECT_LONG) {
            throw new IllegalArgumentException("Prepared query is not of type " + (Object)((Object)StatementBuilder$StatementType.SELECT_LONG) + ", did you call QueryBuilder.setCountOf(true)?");
        }
        DatabaseConnection databaseConnection = this.connectionSource.a();
        long l2 = this.statementExecutor.queryForLong(databaseConnection, a2);
        return l2;
    }

    @Override
    public void assignEmptyForeignCollection(T t2, String string) {
        this.makeEmptyForeignCollection(t2, string);
    }

    @Override
    public <FT> g<FT> getEmptyForeignCollection(String string) {
        return this.makeEmptyForeignCollection(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectCache(boolean bl2) {
        if (bl2) {
            if (this.objectCache == null) {
                if (this.tableInfo.getIdField() == null) {
                    throw new SQLException("Class " + this.dataClass + " must have an id field to enable the object cache");
                }
                Class<BaseDaoImpl> clazz = BaseDaoImpl.class;
                synchronized (BaseDaoImpl.class) {
                    if (defaultObjectCache == null) {
                        defaultObjectCache = ReferenceObjectCache.makeWeakCache();
                    }
                    this.objectCache = defaultObjectCache;
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    this.objectCache.registerClass(this.dataClass);
                    return;
                }
            }
        } else if (this.objectCache != null) {
            this.objectCache.clear(this.dataClass);
            this.objectCache = null;
        }
    }

    @Override
    public void setObjectCache(i i2) {
        if (i2 == null) {
            if (this.objectCache != null) {
                this.objectCache.clear(this.dataClass);
                this.objectCache = null;
                return;
            }
        } else {
            if (this.objectCache != null && this.objectCache != i2) {
                this.objectCache.clear(this.dataClass);
            }
            if (this.tableInfo.getIdField() == null) {
                throw new SQLException("Class " + this.dataClass + " must have an id field to enable the object cache");
            }
            this.objectCache = i2;
            this.objectCache.registerClass(this.dataClass);
        }
    }

    @Override
    public i getObjectCache() {
        return this.objectCache;
    }

    @Override
    public void clearObjectCache() {
        if (this.objectCache != null) {
            this.objectCache.clear(this.dataClass);
        }
    }

    public static synchronized void clearAllInternalObjectCaches() {
        if (defaultObjectCache != null) {
            defaultObjectCache.clearAll();
            defaultObjectCache = null;
        }
    }

    @Override
    public T mapSelectStarRow$3693931a(k k2) {
        return this.statementExecutor.getSelectStarRowMapper().mapRow$3693931a(k2);
    }

    @Override
    public y<T> getSelectStarRowMapper() {
        return this.statementExecutor.getSelectStarRowMapper();
    }

    @Override
    public j<T> getRawRowMapper() {
        return this.statementExecutor.getRawRowMapper();
    }

    @Override
    public boolean idExists(ID ID2) {
        DatabaseConnection databaseConnection = this.connectionSource.a();
        boolean bl2 = this.statementExecutor.ifExists(databaseConnection, ID2);
        return bl2;
    }

    @Override
    public DatabaseConnection startThreadConnection() {
        return this.connectionSource.b();
    }

    @Override
    public void endThreadConnection(DatabaseConnection databaseConnection) {
    }

    @Override
    public void setAutoCommit(boolean bl2) {
        DatabaseConnection databaseConnection = this.connectionSource.b();
        this.setAutoCommit(databaseConnection, bl2);
        return;
    }

    @Override
    public void setAutoCommit(DatabaseConnection databaseConnection, boolean bl2) {
        databaseConnection.setAutoCommit(bl2);
    }

    @Override
    public boolean isAutoCommit() {
        DatabaseConnection databaseConnection = this.connectionSource.b();
        boolean bl2 = this.isAutoCommit(databaseConnection);
        return bl2;
    }

    @Override
    public boolean isAutoCommit(DatabaseConnection databaseConnection) {
        return databaseConnection.isAutoCommit();
    }

    @Override
    public void commit(DatabaseConnection databaseConnection) {
        databaseConnection.commit(null);
    }

    @Override
    public void rollBack(DatabaseConnection databaseConnection) {
        databaseConnection.rollback(null);
    }

    public k<T> getObjectFactory$4836a68b() {
        return this.objectFactory$160be2cc;
    }

    @Override
    public void setObjectFactory$36685da9(k<T> k2) {
        this.checkForInitialized();
        this.objectFactory$160be2cc = k2;
    }

    public DatabaseTableConfig<T> getTableConfig() {
        return this.tableConfig;
    }

    public TableInfo<T, ID> getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public L getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(L l2) {
        this.connectionSource = l2;
    }

    public void setTableConfig(DatabaseTableConfig<T> databaseTableConfig) {
        this.tableConfig = databaseTableConfig;
    }

    static <T, ID> Dao<T, ID> createDao(L l2, Class<T> clazz) {
        return new b(l2, (Class)clazz);
    }

    static <T, ID> Dao<T, ID> createDao(L l2, DatabaseTableConfig<T> databaseTableConfig) {
        return new c(l2, (DatabaseTableConfig)databaseTableConfig);
    }

    protected void checkForInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("you must call initialize() before you can use the dao");
        }
    }

    private <FT> g<FT> makeEmptyForeignCollection(T t2, String object) {
        this.checkForInitialized();
        Object FID = t2 == null ? null : (Object)this.extractId(t2);
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            if (!fieldType.getColumnName().equals(object)) continue;
            object = fieldType.buildForeignCollection(t2, FID);
            if (t2 != null) {
                fieldType.assignField(t2, object, true, null);
            }
            return object;
        }
        throw new IllegalArgumentException("Could not find a field named " + (String)object);
    }

    private e<T> createIterator(int n2) {
        try {
            return this.statementExecutor.buildIterator(this, this.connectionSource, n2, this.objectCache);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not build iterator for " + this.dataClass, exception);
        }
    }

    private e<T> createIterator$46cb65d9$46f7aa12(A<T> a2, int n2) {
        try {
            return this.statementExecutor.buildIterator(this, this.connectionSource, a2, this.objectCache, n2);
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Could not build prepared-query iterator for " + this.dataClass, sQLException);
        }
    }

    private List<T> queryForMatching(T t2, boolean bl2) {
        this.checkForInitialized();
        QueryBuilder<T, ID> queryBuilder = this.queryBuilder();
        Where where = queryBuilder.where();
        int n2 = 0;
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object object = fieldType.getFieldValueIfNotDefault(t2);
            if (object == null) continue;
            if (bl2) {
                object = new SelectArg(object);
            }
            where.eq(fieldType.getColumnName(), object);
            ++n2;
        }
        if (n2 == 0) {
            return Collections.emptyList();
        }
        where.and(n2);
        return queryBuilder.query();
    }

    private List<T> queryForFieldValues(Map<String, Object> map, boolean bl2) {
        this.checkForInitialized();
        QueryBuilder<T, ID> queryBuilder = this.queryBuilder();
        Where where = queryBuilder.where();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (bl2) {
                object = new SelectArg(object);
            }
            where.eq(entry.getKey(), object);
        }
        if (map.size() == 0) {
            return Collections.emptyList();
        }
        where.and(map.size());
        return queryBuilder.query();
    }

    static /* synthetic */ e access$100(BaseDaoImpl baseDaoImpl, int n2) {
        return baseDaoImpl.createIterator(n2);
    }

    static /* synthetic */ e access$200$22362c6d$1d79f74(BaseDaoImpl baseDaoImpl, A a2, int n2) {
        return baseDaoImpl.createIterator$46cb65d9$46f7aa12(a2, n2);
    }
}

