/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DatabaseFieldConfig {
    private static final int DEFAULT_MAX_EAGER_FOREIGN_COLLECTION_LEVEL = 1;
    public static final Class<? extends p> DEFAULT_PERSISTER_CLASS = t.class;
    public static final DataType DEFAULT_DATA_TYPE = DataType.UNKNOWN;
    public static final boolean DEFAULT_CAN_BE_NULL = true;
    public static final boolean DEFAULT_FOREIGN_COLLECTION_ORDER_ASCENDING = true;
    private String fieldName;
    private String columnName;
    private DataType dataType = DEFAULT_DATA_TYPE;
    private p dataPersister;
    private String defaultValue;
    private int width;
    private boolean canBeNull = true;
    private boolean id;
    private boolean generatedId;
    private String generatedIdSequence;
    private boolean foreign;
    private DatabaseTableConfig<?> foreignTableConfig;
    private boolean useGetSet;
    private Enum<?> unknownEnumValue;
    private boolean throwIfNull;
    private boolean persisted = true;
    private String format;
    private boolean unique;
    private boolean uniqueCombo;
    private boolean index;
    private String indexName;
    private boolean uniqueIndex;
    private String uniqueIndexName;
    private boolean foreignAutoRefresh;
    private int maxForeignAutoRefreshLevel = -1;
    private Class<? extends p> persisterClass = DEFAULT_PERSISTER_CLASS;
    private boolean allowGeneratedIdInsert;
    private String columnDefinition;
    private boolean foreignAutoCreate;
    private boolean version;
    private String foreignColumnName;
    private boolean readOnly;
    private boolean foreignCollection;
    private boolean foreignCollectionEager;
    private int foreignCollectionMaxEagerLevel = 1;
    private String foreignCollectionColumnName;
    private String foreignCollectionOrderColumnName;
    private boolean foreignCollectionOrderAscending = true;
    private String foreignCollectionForeignFieldName;

    public DatabaseFieldConfig() {
    }

    public DatabaseFieldConfig(String string) {
        this.fieldName = string;
    }

    public DatabaseFieldConfig(String string, String string2, DataType dataType, String string3, int n2, boolean bl2, boolean bl3, boolean bl4, String string4, boolean bl5, DatabaseTableConfig<?> databaseTableConfig, boolean bl6, Enum<?> enum_, boolean bl7, String string5, boolean bl8, String string6, String string7, boolean bl9, int n3, int n4) {
        this.fieldName = string;
        this.columnName = string2;
        this.dataType = DataType.UNKNOWN;
        this.defaultValue = string3;
        this.width = n2;
        this.canBeNull = bl2;
        this.id = bl3;
        this.generatedId = bl4;
        this.generatedIdSequence = string4;
        this.foreign = bl5;
        this.foreignTableConfig = databaseTableConfig;
        this.useGetSet = bl6;
        this.unknownEnumValue = enum_;
        this.throwIfNull = bl7;
        this.format = string5;
        this.unique = bl8;
        this.indexName = string6;
        this.uniqueIndexName = string7;
        this.foreignAutoRefresh = bl9;
        this.maxForeignAutoRefreshLevel = n3;
        this.foreignCollectionMaxEagerLevel = n4;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public p getDataPersister() {
        if (this.dataPersister == null) {
            return this.dataType.getDataPersister();
        }
        return this.dataPersister;
    }

    public void setDataPersister(p p2) {
        this.dataPersister = p2;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public void setCanBeNull(boolean bl2) {
        this.canBeNull = bl2;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean bl2) {
        this.id = bl2;
    }

    public boolean isGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(boolean bl2) {
        this.generatedId = bl2;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public void setGeneratedIdSequence(String string) {
        this.generatedIdSequence = string;
    }

    public boolean isForeign() {
        return this.foreign;
    }

    public void setForeign(boolean bl2) {
        this.foreign = bl2;
    }

    public DatabaseTableConfig<?> getForeignTableConfig() {
        return this.foreignTableConfig;
    }

    public void setForeignTableConfig(DatabaseTableConfig<?> databaseTableConfig) {
        this.foreignTableConfig = databaseTableConfig;
    }

    public boolean isUseGetSet() {
        return this.useGetSet;
    }

    public void setUseGetSet(boolean bl2) {
        this.useGetSet = bl2;
    }

    public Enum<?> getUnknownEnumValue() {
        return this.unknownEnumValue;
    }

    public void setUnknownEnumValue(Enum<?> enum_) {
        this.unknownEnumValue = enum_;
    }

    public boolean isThrowIfNull() {
        return this.throwIfNull;
    }

    public void setThrowIfNull(boolean bl2) {
        this.throwIfNull = bl2;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean bl2) {
        this.persisted = bl2;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl2) {
        this.unique = bl2;
    }

    public boolean isUniqueCombo() {
        return this.uniqueCombo;
    }

    public void setUniqueCombo(boolean bl2) {
        this.uniqueCombo = bl2;
    }

    public boolean isIndex() {
        return this.index;
    }

    public void setIndex(boolean bl2) {
        this.index = bl2;
    }

    public String getIndexName(String string) {
        if (this.index && this.indexName == null) {
            this.indexName = this.findIndexName(string);
        }
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public boolean isUniqueIndex() {
        return this.uniqueIndex;
    }

    public void setUniqueIndex(boolean bl2) {
        this.uniqueIndex = bl2;
    }

    public String getUniqueIndexName(String string) {
        if (this.uniqueIndex && this.uniqueIndexName == null) {
            this.uniqueIndexName = this.findIndexName(string);
        }
        return this.uniqueIndexName;
    }

    public void setUniqueIndexName(String string) {
        this.uniqueIndexName = string;
    }

    public void setForeignAutoRefresh(boolean bl2) {
        this.foreignAutoRefresh = bl2;
    }

    public boolean isForeignAutoRefresh() {
        return this.foreignAutoRefresh;
    }

    public int getMaxForeignAutoRefreshLevel() {
        return this.maxForeignAutoRefreshLevel;
    }

    public void setMaxForeignAutoRefreshLevel(int n2) {
        this.maxForeignAutoRefreshLevel = n2;
    }

    public boolean isForeignCollection() {
        return this.foreignCollection;
    }

    public void setForeignCollection(boolean bl2) {
        this.foreignCollection = bl2;
    }

    public boolean isForeignCollectionEager() {
        return this.foreignCollectionEager;
    }

    public void setForeignCollectionEager(boolean bl2) {
        this.foreignCollectionEager = bl2;
    }

    public int getForeignCollectionMaxEagerLevel() {
        return this.foreignCollectionMaxEagerLevel;
    }

    public void setForeignCollectionMaxEagerLevel(int n2) {
        this.foreignCollectionMaxEagerLevel = n2;
    }

    @Deprecated
    public void setMaxEagerForeignCollectionLevel(int n2) {
        this.foreignCollectionMaxEagerLevel = n2;
    }

    @Deprecated
    public void setForeignCollectionMaxEagerForeignCollectionLevel(int n2) {
        this.foreignCollectionMaxEagerLevel = n2;
    }

    public String getForeignCollectionColumnName() {
        return this.foreignCollectionColumnName;
    }

    public void setForeignCollectionColumnName(String string) {
        this.foreignCollectionColumnName = string;
    }

    public String getForeignCollectionOrderColumnName() {
        return this.foreignCollectionOrderColumnName;
    }

    @Deprecated
    public void setForeignCollectionOrderColumn(String string) {
        this.foreignCollectionOrderColumnName = string;
    }

    public void setForeignCollectionOrderColumnName(String string) {
        this.foreignCollectionOrderColumnName = string;
    }

    public boolean isForeignCollectionOrderAscending() {
        return this.foreignCollectionOrderAscending;
    }

    public void setForeignCollectionOrderAscending(boolean bl2) {
        this.foreignCollectionOrderAscending = bl2;
    }

    public String getForeignCollectionForeignFieldName() {
        return this.foreignCollectionForeignFieldName;
    }

    @Deprecated
    public void setForeignCollectionForeignColumnName(String string) {
        this.foreignCollectionForeignFieldName = string;
    }

    public void setForeignCollectionForeignFieldName(String string) {
        this.foreignCollectionForeignFieldName = string;
    }

    public Class<? extends p> getPersisterClass() {
        return this.persisterClass;
    }

    public void setPersisterClass(Class<? extends p> clazz) {
        this.persisterClass = clazz;
    }

    public boolean isAllowGeneratedIdInsert() {
        return this.allowGeneratedIdInsert;
    }

    public void setAllowGeneratedIdInsert(boolean bl2) {
        this.allowGeneratedIdInsert = bl2;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String string) {
        this.columnDefinition = string;
    }

    public boolean isForeignAutoCreate() {
        return this.foreignAutoCreate;
    }

    public void setForeignAutoCreate(boolean bl2) {
        this.foreignAutoCreate = bl2;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean bl2) {
        this.version = bl2;
    }

    public String getForeignColumnName() {
        return this.foreignColumnName;
    }

    public void setForeignColumnName(String string) {
        this.foreignColumnName = string;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public static DatabaseFieldConfig fromField(m m2, String object, Field field) {
        DatabaseField databaseField = field.getAnnotation(DatabaseField.class);
        if (databaseField != null) {
            if (databaseField.persisted()) {
                return DatabaseFieldConfig.fromDatabaseField(m2, (String)object, field, databaseField);
            }
            return null;
        }
        object = field.getAnnotation(ForeignCollectionField.class);
        if (object != null) {
            return DatabaseFieldConfig.fromForeignCollection(m2, field, (ForeignCollectionField)object);
        }
        return LoggerFactory$1.createFieldConfig(m2, field);
    }

    public static Method findGetMethod(Field field, boolean bl2) {
        Method method;
        String string = DatabaseFieldConfig.methodFromField(field, "get");
        try {
            method = field.getDeclaringClass().getMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            if (bl2) {
                throw new IllegalArgumentException("Could not find appropriate get method for " + field);
            }
            return null;
        }
        if (method.getReturnType() != field.getType()) {
            if (bl2) {
                throw new IllegalArgumentException("Return type of get method " + string + " does not return " + field.getType());
            }
            return null;
        }
        return method;
    }

    public static Method findSetMethod(Field field, boolean bl2) {
        Method method;
        String string = DatabaseFieldConfig.methodFromField(field, "set");
        try {
            method = field.getDeclaringClass().getMethod(string, field.getType());
        }
        catch (Exception exception) {
            if (bl2) {
                throw new IllegalArgumentException("Could not find appropriate set method for " + field);
            }
            return null;
        }
        if (method.getReturnType() != Void.TYPE) {
            if (bl2) {
                throw new IllegalArgumentException("Return type of set method " + string + " returns " + method.getReturnType() + " instead of void");
            }
            return null;
        }
        return method;
    }

    public static DatabaseFieldConfig fromDatabaseField(m object, String object2, Field field, DatabaseField databaseField) {
        object2 = new DatabaseFieldConfig();
        new DatabaseFieldConfig().fieldName = field.getName();
        if (object.isEntityNamesMustBeUpCase()) {
            ((DatabaseFieldConfig)object2).fieldName = ((DatabaseFieldConfig)object2).fieldName.toUpperCase();
        }
        ((DatabaseFieldConfig)object2).columnName = DatabaseFieldConfig.valueIfNotBlank(databaseField.columnName());
        ((DatabaseFieldConfig)object2).dataType = databaseField.dataType();
        object = databaseField.defaultValue();
        if (!((String)object).equals("__ormlite__ no default value string was specified")) {
            ((DatabaseFieldConfig)object2).defaultValue = object;
        }
        ((DatabaseFieldConfig)object2).width = databaseField.width();
        ((DatabaseFieldConfig)object2).canBeNull = databaseField.canBeNull();
        ((DatabaseFieldConfig)object2).id = databaseField.id();
        ((DatabaseFieldConfig)object2).generatedId = databaseField.generatedId();
        ((DatabaseFieldConfig)object2).generatedIdSequence = DatabaseFieldConfig.valueIfNotBlank(databaseField.generatedIdSequence());
        ((DatabaseFieldConfig)object2).foreign = databaseField.foreign();
        ((DatabaseFieldConfig)object2).useGetSet = databaseField.useGetSet();
        ((DatabaseFieldConfig)object2).unknownEnumValue = DatabaseFieldConfig.findMatchingEnumVal(field, databaseField.unknownEnumName());
        ((DatabaseFieldConfig)object2).throwIfNull = databaseField.throwIfNull();
        ((DatabaseFieldConfig)object2).format = DatabaseFieldConfig.valueIfNotBlank(databaseField.format());
        ((DatabaseFieldConfig)object2).unique = databaseField.unique();
        ((DatabaseFieldConfig)object2).uniqueCombo = databaseField.uniqueCombo();
        ((DatabaseFieldConfig)object2).index = databaseField.index();
        ((DatabaseFieldConfig)object2).indexName = DatabaseFieldConfig.valueIfNotBlank(databaseField.indexName());
        ((DatabaseFieldConfig)object2).uniqueIndex = databaseField.uniqueIndex();
        ((DatabaseFieldConfig)object2).uniqueIndexName = DatabaseFieldConfig.valueIfNotBlank(databaseField.uniqueIndexName());
        ((DatabaseFieldConfig)object2).foreignAutoRefresh = databaseField.foreignAutoRefresh();
        ((DatabaseFieldConfig)object2).maxForeignAutoRefreshLevel = databaseField.maxForeignAutoRefreshLevel();
        ((DatabaseFieldConfig)object2).persisterClass = databaseField.persisterClass();
        ((DatabaseFieldConfig)object2).allowGeneratedIdInsert = databaseField.allowGeneratedIdInsert();
        ((DatabaseFieldConfig)object2).columnDefinition = DatabaseFieldConfig.valueIfNotBlank(databaseField.columnDefinition());
        ((DatabaseFieldConfig)object2).foreignAutoCreate = databaseField.foreignAutoCreate();
        ((DatabaseFieldConfig)object2).version = databaseField.version();
        ((DatabaseFieldConfig)object2).foreignColumnName = DatabaseFieldConfig.valueIfNotBlank(databaseField.foreignColumnName());
        ((DatabaseFieldConfig)object2).readOnly = databaseField.readOnly();
        return object2;
    }

    public void postProcess() {
        if (this.foreignColumnName != null) {
            this.foreignAutoRefresh = true;
        }
        if (this.foreignAutoRefresh && this.maxForeignAutoRefreshLevel == -1) {
            this.maxForeignAutoRefreshLevel = 2;
        }
    }

    public static Enum<?> findMatchingEnumVal(Field field, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (Enum enum_ : (Enum[])field.getType().getEnumConstants()) {
            if (!enum_.name().equals(string)) continue;
            return enum_;
        }
        throw new IllegalArgumentException("Unknwown enum unknown name " + string + " for field " + field);
    }

    private static DatabaseFieldConfig fromForeignCollection(m object, Field field, ForeignCollectionField foreignCollectionField) {
        object = new DatabaseFieldConfig();
        new DatabaseFieldConfig().fieldName = field.getName();
        if (foreignCollectionField.columnName().length() > 0) {
            ((DatabaseFieldConfig)object).columnName = foreignCollectionField.columnName();
        }
        ((DatabaseFieldConfig)object).foreignCollection = true;
        ((DatabaseFieldConfig)object).foreignCollectionEager = foreignCollectionField.eager();
        int n2 = foreignCollectionField.maxEagerForeignCollectionLevel();
        ((DatabaseFieldConfig)object).foreignCollectionMaxEagerLevel = n2 != 1 ? n2 : foreignCollectionField.maxEagerLevel();
        ((DatabaseFieldConfig)object).foreignCollectionOrderColumnName = DatabaseFieldConfig.valueIfNotBlank(foreignCollectionField.orderColumnName());
        ((DatabaseFieldConfig)object).foreignCollectionOrderAscending = foreignCollectionField.orderAscending();
        ((DatabaseFieldConfig)object).foreignCollectionColumnName = DatabaseFieldConfig.valueIfNotBlank(foreignCollectionField.columnName());
        String string = DatabaseFieldConfig.valueIfNotBlank(foreignCollectionField.foreignFieldName());
        if (string == null) {
            string = DatabaseFieldConfig.valueIfNotBlank(foreignCollectionField.foreignColumnName());
            ((DatabaseFieldConfig)object).foreignCollectionForeignFieldName = DatabaseFieldConfig.valueIfNotBlank(string);
        } else {
            ((DatabaseFieldConfig)object).foreignCollectionForeignFieldName = string;
        }
        return object;
    }

    private String findIndexName(String string) {
        if (this.columnName == null) {
            return string + "_" + this.fieldName + "_idx";
        }
        return string + "_" + this.columnName + "_idx";
    }

    private static String valueIfNotBlank(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    private static String methodFromField(Field field, String string) {
        return string + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }
}

