/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.misc;

import com.j256.ormlite.dao.Dao;
import java.sql.SQLException;

public abstract class BaseDaoEnabled<T, ID> {
    protected transient Dao<T, ID> dao;

    public int create() {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.create(baseDaoEnabled);
    }

    public int refresh() {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.refresh(baseDaoEnabled);
    }

    public int update() {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.update(baseDaoEnabled);
    }

    public int updateId(ID ID2) {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.updateId(baseDaoEnabled, ID2);
    }

    public int delete() {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.delete(baseDaoEnabled);
    }

    public String objectToString() {
        try {
            this.checkForDao();
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException(sQLException);
        }
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.objectToString(baseDaoEnabled);
    }

    public ID extractId() {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.extractId(baseDaoEnabled);
    }

    public boolean objectsEqual(T t2) {
        this.checkForDao();
        BaseDaoEnabled baseDaoEnabled = this;
        return this.dao.objectsEqual(baseDaoEnabled, (BaseDaoEnabled)t2);
    }

    public void setDao(Dao<T, ID> dao) {
        this.dao = dao;
    }

    public Dao<T, ID> getDao() {
        return this.dao;
    }

    private void checkForDao() {
        if (this.dao == null) {
            throw new SQLException("Dao has not been set on " + this.getClass() + " object: " + this);
        }
    }
}

