/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.table.TableInfo;
import java.util.List;

public abstract class BaseMappedStatement<T, ID> {
    protected static Logger logger = LoggerFactory.getLogger(BaseMappedStatement.class);
    protected final TableInfo<T, ID> tableInfo;
    protected final Class<T> clazz;
    protected final FieldType idField;
    protected final String statement;
    protected final FieldType[] argFieldTypes;

    protected BaseMappedStatement(TableInfo<T, ID> tableInfo, String string, FieldType[] fieldTypeArray) {
        this.tableInfo = tableInfo;
        this.clazz = tableInfo.getDataClass();
        this.idField = tableInfo.getIdField();
        this.statement = string;
        this.argFieldTypes = fieldTypeArray;
    }

    protected Object[] getFieldObjects(Object object) {
        Object[] objectArray = new Object[this.argFieldTypes.length];
        for (int i2 = 0; i2 < this.argFieldTypes.length; ++i2) {
            FieldType fieldType = this.argFieldTypes[i2];
            objectArray[i2] = fieldType.isAllowGeneratedIdInsert() ? fieldType.getFieldValueIfNotDefault(object) : fieldType.extractJavaFieldToSqlArgValue(object);
            if (objectArray[i2] != null || fieldType.getDefaultValue() == null) continue;
            objectArray[i2] = fieldType.getDefaultValue();
        }
        return objectArray;
    }

    protected Object convertIdToFieldObject(ID ID2) {
        return this.idField.convertJavaFieldToSqlArgValue(ID2);
    }

    protected static void appendWhereFieldEq(m m2, FieldType fieldType, StringBuilder stringBuilder, List<FieldType> list) {
        stringBuilder.append("WHERE ");
        BaseMappedStatement.appendFieldColumnName(m2, stringBuilder, fieldType, list);
        stringBuilder.append("= ?");
    }

    protected static void appendTableName(m m2, StringBuilder stringBuilder, String string, String string2) {
        if (string != null) {
            stringBuilder.append(string);
        }
        m2.appendEscapedEntityName(stringBuilder, string2);
        stringBuilder.append(' ');
    }

    protected static void appendFieldColumnName(m m2, StringBuilder stringBuilder, FieldType fieldType, List<FieldType> list) {
        m2.appendEscapedEntityName(stringBuilder, fieldType.getColumnName());
        if (list != null) {
            list.add(fieldType);
        }
        stringBuilder.append(' ');
    }

    public String toString() {
        return "MappedStatement: " + this.statement;
    }
}

