/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.LoggerFactory$1;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

public class MappedUpdate<T, ID>
extends BaseMappedStatement<T, ID> {
    private final FieldType versionFieldType;
    private final int versionFieldTypeIndex;

    private MappedUpdate(TableInfo<T, ID> tableInfo, String string, FieldType[] fieldTypeArray, FieldType fieldType, int n2) {
        super(tableInfo, string, fieldTypeArray);
        this.versionFieldType = fieldType;
        this.versionFieldTypeIndex = n2;
    }

    public static <T, ID> MappedUpdate<T, ID> build(m m2, TableInfo<T, ID> tableInfo) {
        FieldType fieldType = tableInfo.getIdField();
        if (fieldType == null) {
            throw new SQLException("Cannot update " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        MappedUpdate.appendTableName(m2, stringBuilder, "UPDATE ", tableInfo.getTableName());
        boolean bl2 = true;
        int n2 = 0;
        FieldType fieldType2 = null;
        int n3 = -1;
        for (FieldType fieldType3 : tableInfo.getFieldTypes()) {
            if (!MappedUpdate.isFieldUpdatable(fieldType3, fieldType)) continue;
            if (fieldType3.isVersion()) {
                fieldType2 = fieldType3;
                n3 = n2;
            }
            ++n2;
        }
        ++n2;
        if (fieldType2 != null) {
            ++n2;
        }
        FieldType[] fieldTypeArray = new FieldType[n2];
        n2 = 0;
        for (FieldType fieldType4 : tableInfo.getFieldTypes()) {
            if (!MappedUpdate.isFieldUpdatable(fieldType4, fieldType)) continue;
            if (bl2) {
                stringBuilder.append("SET ");
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            MappedUpdate.appendFieldColumnName(m2, stringBuilder, fieldType4, null);
            fieldTypeArray[n2++] = fieldType4;
            stringBuilder.append("= ?");
        }
        stringBuilder.append(' ');
        MappedUpdate.appendWhereFieldEq(m2, fieldType, stringBuilder, null);
        fieldTypeArray[n2++] = fieldType;
        if (fieldType2 != null) {
            stringBuilder.append(" AND ");
            MappedUpdate.appendFieldColumnName(m2, stringBuilder, fieldType2, null);
            stringBuilder.append("= ?");
            fieldTypeArray[n2] = fieldType2;
        }
        return new MappedUpdate<T, ID>(tableInfo, stringBuilder.toString(), fieldTypeArray, fieldType2, n3);
    }

    public int update(DatabaseConnection databaseConnection, T t2, i i2) {
        try {
            int n2;
            if (this.argFieldTypes.length <= 1) {
                return 0;
            }
            Object[] objectArray = this.getFieldObjects(t2);
            Object object = null;
            if (this.versionFieldType != null) {
                object = this.versionFieldType.extractJavaFieldValue(t2);
                object = this.versionFieldType.moveToNextValue(object);
                objectArray[this.versionFieldTypeIndex] = this.versionFieldType.convertJavaFieldToSqlArgValue(object);
            }
            if ((n2 = databaseConnection.update(this.statement, objectArray, this.argFieldTypes)) > 0) {
                if (object != null) {
                    this.versionFieldType.assignField(t2, object, false, null);
                }
                if (i2 != null) {
                    object = this.idField.extractJavaFieldValue(t2);
                    if ((object = i2.get(this.clazz, object)) != null && object != t2) {
                        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
                            if (fieldType == this.idField) continue;
                            fieldType.assignField(object, fieldType.extractJavaFieldValue(t2), false, i2);
                        }
                    }
                }
            }
            logger.debug("update data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)objectArray.length, (Object)n2);
            if (objectArray.length > 0) {
                logger.trace("update arguments: {}", (Object)objectArray);
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw LoggerFactory$1.create("Unable to run update stmt on object " + t2 + ": " + this.statement, sQLException);
        }
    }

    private static boolean isFieldUpdatable(FieldType fieldType, FieldType fieldType2) {
        return fieldType != fieldType2 && !fieldType.isForeignCollection() && !fieldType.isReadOnly();
    }
}

