/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard;

import de.t68.utils.keyboard.KeyboardModifier;
import de.t68.utils.keyboard.VKeyboard;
import de.t68.utils.keyboard.button.KeyboardButton;
import de.t68.utils.keyboard.event.VirtualKeyEvent;
import de.t68.utils.keyboard.event.VirtualKeyListener;
import javax.swing.AbstractButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jdom2.Element;

public class KeyboardKey {
    public static final String Element_Key = "Key";
    public static final String Attr_Normal = "normal";
    public static final String Attr_Shift = "shift";
    public static final String Attr_Alt = "alt";
    public static final String Attr_AltGr = "altgr";
    protected String normalKey;
    protected String shiftKey;
    protected String altKey;
    protected String altshiftKey;
    protected String fontName;
    protected KeyboardButton keyboardButton;
    protected int keyFontSize = 18;
    protected int keyWidth;

    protected KeyboardKey(String string) {
        this.fontName = string;
    }

    public KeyboardKey(String string, Element object) {
        this(string);
        string = object.getAttributeValue(Attr_Normal).trim();
        String string2 = object.getAttributeValue(Attr_Shift);
        string2 = string2 != null ? string2.trim() : string2;
        String string3 = object.getAttributeValue(Attr_Alt);
        string3 = string3 != null ? string3.trim() : string3;
        object = object.getAttributeValue(Attr_AltGr);
        object = object != null ? ((String)object).trim() : object;
        this.shiftKey = string.equalsIgnoreCase(string2) && string2 != null ? string2.toUpperCase() : string2;
        this.normalKey = string.equalsIgnoreCase(string2) ? string.toLowerCase() : string;
        this.altKey = string3;
        this.altshiftKey = object;
        this.keyWidth = 1;
    }

    public KeyboardKey(String string, String string2, String string3, String string4, String string5) {
        this.normalKey = string2;
        this.shiftKey = string3;
        this.altKey = string4;
        this.altshiftKey = string5;
        this.fontName = string;
        this.keyWidth = 1;
    }

    public KeyboardKey(String string, String string2, String string3, String string4, String string5, int n2) {
        this.normalKey = string2;
        this.shiftKey = string3;
        this.altKey = string4;
        this.altshiftKey = string5;
        this.fontName = string;
        this.keyWidth = n2;
    }

    private String getContent(KeyboardModifier keyboardModifier) {
        switch (keyboardModifier) {
            case alt: {
                return this.altKey;
            }
            case altshift: {
                return this.altshiftKey;
            }
            case normal: {
                return this.normalKey;
            }
            case shift: {
                return this.shiftKey;
            }
        }
        return this.normalKey;
    }

    public AbstractButton getComponent(VirtualKeyListener virtualKeyListener, VKeyboard vKeyboard) {
        this.keyboardButton = new KeyboardButton(this.fontName, this.keyFontSize, this.normalKey, this.shiftKey, this.altKey, this.altshiftKey, VirtualKeyEvent.stringToKeyCode(this.normalKey), this.normalKey.toCharArray()[0]);
        this.keyboardButton.addVirtualKeyListener(virtualKeyListener);
        return this.keyboardButton;
    }

    public int getKeyFontSize() {
        return this.keyFontSize;
    }

    public int getKeyWidth() {
        return this.keyWidth;
    }

    protected void insertString(JTextComponent jTextComponent, VKeyboard vKeyboard, String string) {
        try {
            int n2 = jTextComponent.getCaretPosition();
            if (string.trim().isEmpty()) {
                string = " ";
            }
            if (string.length() > 1) {
                string = string.trim();
            }
            jTextComponent.getDocument().insertString(n2, string, null);
            vKeyboard.setModifier(vKeyboard.isCapsLock() ? KeyboardModifier.shift : KeyboardModifier.normal);
            return;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return;
        }
    }

    public void doAction(JTextComponent jTextComponent, VKeyboard vKeyboard, int n2) {
        if (n2 == 400) {
            this.insertString(jTextComponent, vKeyboard, this.getContent(vKeyboard.getModifier()));
        }
    }

    public Element getAsElement() {
        Element element = new Element(Element_Key);
        if (this.normalKey != null) {
            element.setAttribute(Attr_Normal, this.normalKey);
        }
        if (this.shiftKey != null) {
            element.setAttribute(Attr_Shift, this.shiftKey);
        }
        if (this.altKey != null) {
            element.setAttribute(Attr_Alt, this.altKey);
        }
        if (this.altshiftKey != null) {
            element.setAttribute(Attr_AltGr, this.altshiftKey);
        }
        return element;
    }

    public void setKeyboardModifier(KeyboardModifier keyboardModifier) {
        if (this.keyboardButton != null) {
            this.keyboardButton.setKeyboardModifier(keyboardModifier);
        }
    }

    public void setKeyFontSize(int n2) {
        this.keyFontSize = n2;
    }

    public void setKeyWidth(int n2) {
        this.keyWidth = n2;
    }
}

