/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard.button;

import de.t68.utils.keyboard.KeyboardModifier;
import de.t68.utils.keyboard.event.VirtualKeyListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class KeyboardButton
extends JButton
implements ComponentListener {
    private static final long serialVersionUID = 7893269168954791966L;
    private final JLabel sLabel;
    private final JLabel nLabel;
    private final JLabel asLabel;
    private final JLabel aLabel;
    Dimension currentDimension = null;
    protected Dimension preferredSize = null;
    public final LinkedList<VirtualKeyListener> vkListener = new LinkedList();

    public KeyboardButton(String object, int n2, String string, String string2, String string3, String string4, int n3, char c2) {
        this.setLayout((LayoutManager)new MigLayout("insets 1 1 1 1"));
        object = Font.getFont((String)object);
        object = ((Font)(object == null ? this.getFont() : object)).deriveFont((float)n2);
        this.setFont((Font)object);
        this.sLabel = this.createLabel(string2);
        this.nLabel = this.createLabel(string.equalsIgnoreCase(string2) ? "" : string);
        this.asLabel = this.createLabel(string4);
        this.aLabel = this.createLabel(string3);
        this.add(this.sLabel);
        this.add((Component)this.aLabel, "wrap");
        this.add(this.nLabel);
        this.add((Component)this.asLabel, "wrap");
        this.addComponentListener(this);
        this.addActionListener(new V(this, n3, c2));
    }

    public KeyboardButton(String string, String object, int n2) {
        this.sLabel = this.createLabel("");
        this.nLabel = this.createLabel("");
        this.asLabel = this.createLabel("");
        this.aLabel = this.createLabel("");
        this.add(this.sLabel);
        this.add(this.aLabel);
        this.add(this.nLabel);
        this.add(this.asLabel);
        this.setText(string);
        this.setLayout(new GridLayout(2, 2));
        object = Font.getFont((String)object);
        object = ((Font)(object == null ? this.getFont() : object)).deriveFont((float)n2);
        this.setFont((Font)object);
        this.addComponentListener(this);
        this.addActionListener(new W(this, string));
    }

    public KeyboardButton(String string, String string2, String string3, String string4, String string5, int n2, char c2) {
        this(string, 18, string2, string3, string4, string5, n2, c2);
    }

    public KeyboardButton(String string, int n2, int n3, char c2) {
        this(string, n2, " ", " ", " ", " ", n3, c2);
    }

    public void addVirtualKeyListener(VirtualKeyListener virtualKeyListener) {
        this.vkListener.add(virtualKeyListener);
    }

    public void removeVirtualKeyListener(VirtualKeyListener virtualKeyListener) {
        this.vkListener.remove(virtualKeyListener);
    }

    private JLabel createLabel(String object) {
        object = new JLabel((String)object);
        ((JLabel)object).setHorizontalTextPosition(0);
        ((JComponent)object).setFont(this.getFont());
        Border border = ((JComponent)object).getBorder();
        ((JComponent)object).setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 0, 0)));
        return object;
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension();
            int n2 = this.getFont().getSize() << 2;
            Object object = this.getGraphicsConfiguration();
            Object object2 = object != null ? ((GraphicsConfiguration)object).createCompatibleImage(n2, n2) : new BufferedImage(n2, n2, 6);
            object2 = ((BufferedImage)object2).createGraphics();
            ((Graphics)object2).setFont(this.getFont());
            object = ((Graphics)object2).getFontMetrics();
            Rectangle2D rectangle2D = ((FontMetrics)object).getStringBounds("W", (Graphics)object2);
            Rectangle2D rectangle2D2 = ((FontMetrics)object).getStringBounds("M", (Graphics)object2);
            Rectangle2D rectangle2D3 = ((FontMetrics)object).getStringBounds("m", (Graphics)object2);
            object = ((FontMetrics)object).getStringBounds("@", (Graphics)object2);
            ((Graphics)object2).dispose();
            double d2 = Math.max(Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()), Math.max(rectangle2D3.getWidth(), ((RectangularShape)object).getWidth()));
            double d3 = Math.max(Math.max(rectangle2D.getHeight(), rectangle2D2.getHeight()), Math.max(rectangle2D3.getHeight(), ((RectangularShape)object).getHeight()));
            double d4 = Math.max(d2, d3) * 4.0;
            object2 = super.getPreferredSize();
            this.preferredSize.setSize(Math.max(d4, (double)((Dimension)object2).height), Math.max(d4, (double)((Dimension)object2).width));
        }
        return this.preferredSize.getSize();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent serializable) {
        if (this.currentDimension != null) {
            serializable = this.getSize();
            Font font = this.getFont();
            float f2 = (float)((double)font.getSize() * ((Dimension)serializable).getHeight() / this.currentDimension.getHeight());
            font = font.deriveFont(f2);
            this.nLabel.setFont(font);
            this.sLabel.setFont(font);
            this.nLabel.setFont(font);
            this.asLabel.setFont(font);
            this.aLabel.setFont(font);
            this.setFont(font);
        }
        this.currentDimension = this.getSize();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setKeyboardModifier(KeyboardModifier keyboardModifier) {
        Font font = this.nLabel.getFont().deriveFont(0);
        Font font2 = this.nLabel.getFont().deriveFont(1);
        JLabel[] jLabelArray = new JLabel[]{this.asLabel, this.aLabel};
        for (int i2 = 0; i2 < 2; ++i2) {
            JLabel jLabel = jLabelArray[i2];
            if (jLabel.getFont().isPlain()) continue;
            jLabel.setFont(font);
        }
        switch (keyboardModifier) {
            case alt: {
                this.aLabel.setFont(font2);
                return;
            }
            case altshift: {
                this.asLabel.setFont(font2);
            }
        }
    }
}

