/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asteriskjava.config.ConfigElement;

public class Category
extends ConfigElement {
    private String name;
    private boolean template;
    private final List<Category> baseCategories = new ArrayList<Category>();
    private final List<ConfigElement> elements = new ArrayList<ConfigElement>();

    public Category(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.name = string;
    }

    public Category(String string, int n2, String string2) {
        super(string, n2);
        this.name = string2;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemplate() {
        return this.template;
    }

    void markAsTemplate() {
        this.template = true;
    }

    public List<Category> getBaseCategories() {
        return this.baseCategories;
    }

    void addBaseCategory(Category category) {
        this.baseCategories.add(category);
    }

    public List<ConfigElement> getElements() {
        return this.elements;
    }

    public void addElement(ConfigElement configElement) {
        if (configElement instanceof Category) {
            throw new IllegalArgumentException("Nested categories are not allowed");
        }
        this.elements.add(configElement);
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        this.format(stringBuilder);
        for (ConfigElement configElement : this.elements) {
            stringBuilder.append("\n");
            configElement.format(stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Override
    protected StringBuilder rawFormat(StringBuilder stringBuilder) {
        stringBuilder.append("[").append(this.name).append("]");
        if (this.isTemplate() || !this.getBaseCategories().isEmpty()) {
            stringBuilder.append("(");
            if (this.isTemplate()) {
                stringBuilder.append("!");
                if (!this.getBaseCategories().isEmpty()) {
                    stringBuilder.append(",");
                }
            }
            Iterator<Category> iterator = this.getBaseCategories().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().getName());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        return stringBuilder;
    }

    public String toString() {
        return this.name;
    }
}

