/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;

public class CompositeMappingStrategy
implements MappingStrategy {
    private List<MappingStrategy> strategies;

    public CompositeMappingStrategy() {
    }

    public CompositeMappingStrategy(MappingStrategy ... mappingStrategyArray) {
        this.strategies = new ArrayList<MappingStrategy>(Arrays.asList(mappingStrategyArray));
    }

    public CompositeMappingStrategy(List<MappingStrategy> list) {
        this.strategies = new ArrayList<MappingStrategy>(list);
    }

    public void addStrategy(MappingStrategy mappingStrategy) {
        if (this.strategies == null) {
            this.strategies = new ArrayList<MappingStrategy>();
        }
        this.strategies.add(mappingStrategy);
    }

    public void setStrategies(List<MappingStrategy> list) {
        this.strategies = new ArrayList<MappingStrategy>(list);
    }

    @Override
    public AgiScript determineScript(AgiRequest agiRequest, AgiChannel agiChannel) {
        AgiScript agiScript = null;
        if (this.strategies == null) {
            return null;
        }
        Iterator<MappingStrategy> iterator = this.strategies.iterator();
        while (iterator.hasNext() && (agiScript = iterator.next().determineScript(agiRequest, agiChannel)) == null) {
        }
        return agiScript;
    }
}

