/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.asteriskjava.fastagi.AbstractMappingStrategy;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;

public class ResourceBundleMappingStrategy
extends AbstractMappingStrategy {
    private static final String DEFAULT_RESOURCE_BUNDLE_NAME = "fastagi-mapping";
    private String resourceBundleName;
    private Map<String, String> mappings;
    private Map<String, AgiScript> instances;
    private boolean shareInstances;

    public ResourceBundleMappingStrategy() {
        this(DEFAULT_RESOURCE_BUNDLE_NAME);
    }

    public ResourceBundleMappingStrategy(String string) {
        this(string, true);
    }

    public ResourceBundleMappingStrategy(boolean bl2) {
        this(DEFAULT_RESOURCE_BUNDLE_NAME, bl2);
    }

    public ResourceBundleMappingStrategy(String string, boolean bl2) {
        this.resourceBundleName = string;
        this.shareInstances = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceBundleName(String object) {
        this.resourceBundleName = object;
        object = this;
        synchronized (object) {
            this.mappings = null;
            this.instances = null;
            return;
        }
    }

    public synchronized void setShareInstances(boolean bl2) {
        this.shareInstances = bl2;
    }

    private synchronized void loadResourceBundle() {
        ResourceBundle resourceBundle;
        this.mappings = new HashMap<String, String>();
        if (this.shareInstances) {
            this.instances = new HashMap<String, AgiScript>();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.resourceBundleName, Locale.getDefault(), this.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            this.logger.info("Resource bundle '" + this.resourceBundleName + "' not found.");
            return;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            this.mappings.put(string, string2);
            if (this.shareInstances) {
                AgiScript agiScript = this.createAgiScriptInstance(string2);
                if (agiScript == null) continue;
                this.instances.put(string, agiScript);
            }
            this.logger.info("Added mapping for '" + string + "' to class " + string2);
        }
    }

    @Override
    public synchronized AgiScript determineScript(AgiRequest agiRequest) {
        if (this.mappings == null || this.shareInstances && this.instances == null) {
            this.loadResourceBundle();
        }
        if (this.shareInstances) {
            return this.instances.get(agiRequest.getScript());
        }
        return this.createAgiScriptInstance(this.mappings.get(agiRequest.getScript()));
    }
}

