/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.ScriptEngineMappingStrategy$1;
import org.asteriskjava.fastagi.ScriptEngineMappingStrategy$ScriptEngineAgiScript;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class ScriptEngineMappingStrategy
implements MappingStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String REQUEST = "request";
    public static final String CHANNEL = "channel";
    private static final String[] DEFAULT_SCRIPT_PATH = new String[]{"agi"};
    private static final String[] DEFAULT_LIB_PATH = new String[]{"lib"};
    protected String[] scriptPath;
    protected String[] libPath;
    protected ScriptEngineManager scriptEngineManager = null;

    public ScriptEngineMappingStrategy() {
        this(DEFAULT_SCRIPT_PATH, DEFAULT_LIB_PATH);
    }

    public ScriptEngineMappingStrategy(String[] stringArray, String[] stringArray2) {
        this.setScriptPath(stringArray);
        this.setLibPath(stringArray2);
    }

    public void setScriptPath(String[] stringArray) {
        this.scriptPath = Arrays.copyOf(stringArray, stringArray.length);
    }

    public void setLibPath(String[] stringArray) {
        this.libPath = Arrays.copyOf(stringArray, stringArray.length);
    }

    @Override
    public AgiScript determineScript(AgiRequest object, AgiChannel object2) {
        if ((object = this.searchFile(object.getScript(), this.scriptPath)) == null) {
            return null;
        }
        object2 = this.getScriptEngine((File)object);
        if (object2 == null) {
            this.logger.debug("No ScriptEngine found that can handle '" + ((File)object).getPath() + "'");
            return null;
        }
        return new ScriptEngineMappingStrategy$ScriptEngineAgiScript(this, (File)object, (ScriptEngine)object2);
    }

    protected ScriptEngine getScriptEngine(File object) {
        if ((object = ScriptEngineMappingStrategy.getExtension(((File)object).getName())) == null) {
            return null;
        }
        return this.getScriptEngineManager().getEngineByExtension((String)object);
    }

    protected synchronized ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager(this.getClassLoader());
        }
        return this.scriptEngineManager;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.libPath == null || this.libPath.length == 0) {
            return classLoader;
        }
        String[] stringArray = this.libPath;
        int n2 = this.libPath.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File[] fileArray = stringArray[i2];
            if (!(fileArray = new File((String)fileArray)).isDirectory()) continue;
            File[] fileArray2 = fileArray.listFiles(new ScriptEngineMappingStrategy$1(this));
            if (fileArray2 != null) {
                fileArray = fileArray2;
                int n3 = fileArray2.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    File file = fileArray[i3];
                    try {
                        arrayList.add(file.toURI().toURL());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                continue;
            }
            this.logger.error("Didn't find any jar files at " + fileArray.getAbsolutePath());
        }
        if (arrayList.size() == 0) {
            return classLoader;
        }
        return new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), classLoader);
    }

    protected File searchFile(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return null;
        }
        for (String iOException : stringArray) {
            File file;
            File file2 = new File(iOException);
            if (!file2.isDirectory() || !(file = new File(file2, string.replaceAll("/", Matcher.quoteReplacement(File.separator)))).exists()) continue;
            try {
                if (!this.isInside(file, file2)) {
                    return null;
                }
            }
            catch (IOException iOException2) {
                this.logger.warn("Unable to check whether '" + file.getPath() + "' is below '" + file2.getPath() + "'");
                continue;
            }
            try {
                return file.getCanonicalFile();
            }
            catch (IOException iOException3) {
                this.logger.error("Unable to get canonical file for '" + file.getPath() + "'", iOException3);
            }
        }
        return null;
    }

    protected final boolean isInside(File file, File file2) {
        return file.getCanonicalPath().startsWith(file2.getCanonicalPath());
    }

    protected static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf("/");
        if (string.lastIndexOf("\\") > n2) {
            n2 = string.lastIndexOf("\\");
        }
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.lastIndexOf(".")) >= 0) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    protected static Reader getReader(File object) {
        object = new FileInputStream((File)object);
        return new InputStreamReader((InputStream)object);
    }

    protected void populateBindings(File file, AgiRequest agiRequest, AgiChannel agiChannel, Bindings bindings) {
    }
}

