/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiSpeechException;
import org.asteriskjava.fastagi.InvalidCommandSyntaxException;
import org.asteriskjava.fastagi.InvalidOrUnknownCommandException;
import org.asteriskjava.fastagi.SpeechRecognitionResult;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.fastagi.command.AnswerCommand;
import org.asteriskjava.fastagi.command.ChannelStatusCommand;
import org.asteriskjava.fastagi.command.ControlStreamFileCommand;
import org.asteriskjava.fastagi.command.DatabaseDelCommand;
import org.asteriskjava.fastagi.command.DatabaseDelTreeCommand;
import org.asteriskjava.fastagi.command.DatabaseGetCommand;
import org.asteriskjava.fastagi.command.DatabasePutCommand;
import org.asteriskjava.fastagi.command.ExecCommand;
import org.asteriskjava.fastagi.command.GetDataCommand;
import org.asteriskjava.fastagi.command.GetFullVariableCommand;
import org.asteriskjava.fastagi.command.GetOptionCommand;
import org.asteriskjava.fastagi.command.GetVariableCommand;
import org.asteriskjava.fastagi.command.GosubCommand;
import org.asteriskjava.fastagi.command.HangupCommand;
import org.asteriskjava.fastagi.command.RecordFileCommand;
import org.asteriskjava.fastagi.command.SayAlphaCommand;
import org.asteriskjava.fastagi.command.SayDateTimeCommand;
import org.asteriskjava.fastagi.command.SayDigitsCommand;
import org.asteriskjava.fastagi.command.SayNumberCommand;
import org.asteriskjava.fastagi.command.SayPhoneticCommand;
import org.asteriskjava.fastagi.command.SayTimeCommand;
import org.asteriskjava.fastagi.command.SetAutoHangupCommand;
import org.asteriskjava.fastagi.command.SetCallerIdCommand;
import org.asteriskjava.fastagi.command.SetContextCommand;
import org.asteriskjava.fastagi.command.SetExtensionCommand;
import org.asteriskjava.fastagi.command.SetMusicOffCommand;
import org.asteriskjava.fastagi.command.SetMusicOnCommand;
import org.asteriskjava.fastagi.command.SetPriorityCommand;
import org.asteriskjava.fastagi.command.SetVariableCommand;
import org.asteriskjava.fastagi.command.SpeechActivateGrammarCommand;
import org.asteriskjava.fastagi.command.SpeechCreateCommand;
import org.asteriskjava.fastagi.command.SpeechDeactivateGrammarCommand;
import org.asteriskjava.fastagi.command.SpeechDestroyCommand;
import org.asteriskjava.fastagi.command.SpeechLoadGrammarCommand;
import org.asteriskjava.fastagi.command.SpeechRecognizeCommand;
import org.asteriskjava.fastagi.command.SpeechSetCommand;
import org.asteriskjava.fastagi.command.SpeechUnloadGrammarCommand;
import org.asteriskjava.fastagi.command.StreamFileCommand;
import org.asteriskjava.fastagi.command.VerboseCommand;
import org.asteriskjava.fastagi.command.WaitForDigitCommand;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.fastagi.reply.AgiReply;

public class AgiChannelImpl
implements AgiChannel {
    private final AgiRequest request;
    private final AgiWriter agiWriter;
    private final AgiReader agiReader;
    private AgiReply lastReply;

    protected AgiChannelImpl(AgiRequest agiRequest, AgiWriter agiWriter, AgiReader agiReader) {
        this.request = agiRequest;
        this.agiWriter = agiWriter;
        this.agiReader = agiReader;
        this.lastReply = null;
    }

    @Override
    public String getName() {
        return this.request.getChannel();
    }

    @Override
    public String getUniqueId() {
        return this.request.getUniqueId();
    }

    @Override
    public AgiReply getLastReply() {
        return this.lastReply;
    }

    @Override
    public synchronized AgiReply sendCommand(AgiCommand agiCommand) {
        this.agiWriter.sendCommand(agiCommand);
        this.lastReply = this.agiReader.readReply();
        if (this.lastReply.getStatus() == 510) {
            throw new InvalidOrUnknownCommandException(agiCommand.buildCommand());
        }
        if (this.lastReply.getStatus() == 511) {
            throw new AgiHangupException();
        }
        if (this.lastReply.getStatus() == 520) {
            throw new InvalidCommandSyntaxException(this.lastReply.getSynopsis(), this.lastReply.getUsage());
        }
        return this.lastReply;
    }

    @Override
    public void answer() {
        this.sendCommand(new AnswerCommand());
    }

    @Override
    public void hangup() {
        this.sendCommand(new HangupCommand());
    }

    @Override
    public void setAutoHangup(int n2) {
        this.sendCommand(new SetAutoHangupCommand(n2));
    }

    @Override
    public void setCallerId(String string) {
        this.sendCommand(new SetCallerIdCommand(string));
    }

    @Override
    public void playMusicOnHold() {
        this.sendCommand(new SetMusicOnCommand());
    }

    @Override
    public void playMusicOnHold(String string) {
        this.sendCommand(new SetMusicOnCommand(string));
    }

    @Override
    public void stopMusicOnHold() {
        this.sendCommand(new SetMusicOffCommand());
    }

    @Override
    public int getChannelStatus() {
        this.sendCommand(new ChannelStatusCommand());
        return this.lastReply.getResultCode();
    }

    @Override
    public String getData(String string) {
        this.sendCommand(new GetDataCommand(string));
        return this.lastReply.getResult();
    }

    @Override
    public String getData(String string, long l2) {
        this.sendCommand(new GetDataCommand(string, l2));
        return this.lastReply.getResult();
    }

    @Override
    public String getData(String string, long l2, int n2) {
        this.sendCommand(new GetDataCommand(string, l2, n2));
        return this.lastReply.getResult();
    }

    @Override
    public char getOption(String string, String string2) {
        this.sendCommand(new GetOptionCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char getOption(String string, String string2, long l2) {
        this.sendCommand(new GetOptionCommand(string, string2, l2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public int exec(String string) {
        this.sendCommand(new ExecCommand(string));
        return this.lastReply.getResultCode();
    }

    @Override
    public int exec(String string, String ... stringArray) {
        this.sendCommand(new ExecCommand(string, stringArray));
        return this.lastReply.getResultCode();
    }

    @Override
    public void setContext(String string) {
        this.sendCommand(new SetContextCommand(string));
    }

    @Override
    public void setExtension(String string) {
        this.sendCommand(new SetExtensionCommand(string));
    }

    @Override
    public void setPriority(String string) {
        this.sendCommand(new SetPriorityCommand(string));
    }

    @Override
    public void streamFile(String string) {
        this.sendCommand(new StreamFileCommand(string));
    }

    @Override
    public char streamFile(String string, String string2) {
        this.sendCommand(new StreamFileCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char streamFile(String string, String string2, int n2) {
        this.sendCommand(new StreamFileCommand(string, string2, n2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void sayDigits(String string) {
        this.sendCommand(new SayDigitsCommand(string));
    }

    @Override
    public char sayDigits(String string, String string2) {
        this.sendCommand(new SayDigitsCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void sayNumber(String string) {
        this.sendCommand(new SayNumberCommand(string));
    }

    @Override
    public char sayNumber(String string, String string2) {
        this.sendCommand(new SayNumberCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void sayPhonetic(String string) {
        this.sendCommand(new SayPhoneticCommand(string));
    }

    @Override
    public char sayPhonetic(String string, String string2) {
        this.sendCommand(new SayPhoneticCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void sayAlpha(String string) {
        this.sendCommand(new SayAlphaCommand(string));
    }

    @Override
    public char sayAlpha(String string, String string2) {
        this.sendCommand(new SayAlphaCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void sayTime(long l2) {
        this.sendCommand(new SayTimeCommand(l2));
    }

    @Override
    public char sayTime(long l2, String string) {
        this.sendCommand(new SayTimeCommand(l2, string));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public String getVariable(String string) {
        this.sendCommand(new GetVariableCommand(string));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    @Override
    public void setVariable(String string, String string2) {
        this.sendCommand(new SetVariableCommand(string, string2));
    }

    @Override
    public char waitForDigit(int n2) {
        this.sendCommand(new WaitForDigitCommand(n2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public String getFullVariable(String string) {
        this.sendCommand(new GetFullVariableCommand(string));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    @Override
    public String getFullVariable(String string, String string2) {
        this.sendCommand(new GetFullVariableCommand(string, string2));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    @Override
    public char sayDateTime(long l2, String string, String string2, String string3) {
        this.sendCommand(new SayDateTimeCommand(l2, string, string2, string3));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char sayDateTime(long l2, String string, String string2) {
        this.sendCommand(new SayDateTimeCommand(l2, string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char sayDateTime(long l2, String string) {
        this.sendCommand(new SayDateTimeCommand(l2, string));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void sayDateTime(long l2) {
        this.sendCommand(new SayDateTimeCommand(l2));
    }

    @Override
    public String databaseGet(String string, String string2) {
        this.sendCommand(new DatabaseGetCommand(string, string2));
        if (this.lastReply.getResultCode() != 1) {
            return null;
        }
        return this.lastReply.getExtra();
    }

    @Override
    public void databasePut(String string, String string2, String string3) {
        this.sendCommand(new DatabasePutCommand(string, string2, string3));
    }

    @Override
    public void databaseDel(String string, String string2) {
        this.sendCommand(new DatabaseDelCommand(string, string2));
    }

    @Override
    public void databaseDelTree(String string) {
        this.sendCommand(new DatabaseDelTreeCommand(string));
    }

    @Override
    public void databaseDelTree(String string, String string2) {
        this.sendCommand(new DatabaseDelTreeCommand(string, string2));
    }

    @Override
    public void verbose(String string, int n2) {
        this.sendCommand(new VerboseCommand(string, n2));
    }

    @Override
    public char recordFile(String string, String string2, String string3, int n2) {
        this.sendCommand(new RecordFileCommand(string, string2, string3, n2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char recordFile(String string, String string2, String string3, int n2, int n3, boolean bl2, int n4) {
        this.sendCommand(new RecordFileCommand(string, string2, string3, n2, n3, bl2, n4));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void controlStreamFile(String string) {
        this.sendCommand(new ControlStreamFileCommand(string));
    }

    @Override
    public char controlStreamFile(String string, String string2) {
        this.sendCommand(new ControlStreamFileCommand(string, string2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char controlStreamFile(String string, String string2, int n2) {
        this.sendCommand(new ControlStreamFileCommand(string, string2, n2));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public char controlStreamFile(String string, String string2, int n2, String string3, String string4, String string5) {
        this.sendCommand(new ControlStreamFileCommand(string, string2, n2, string3, string4, string5));
        return this.lastReply.getResultCodeAsChar();
    }

    @Override
    public void speechCreate() {
        this.speechCreate("");
    }

    @Override
    public void speechCreate(String string) {
        this.sendCommand(new SpeechCreateCommand(string));
        if (this.lastReply.getResultCode() != 1) {
            if (string == null || "".equals(string)) {
                throw new AgiSpeechException("Speech object for default engine cannot be created");
            }
            throw new AgiSpeechException("Speech object for engine '" + string + "' cannot be created");
        }
    }

    @Override
    public void speechSet(String string, String string2) {
        this.sendCommand(new SpeechSetCommand(string, string2));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Setting '" + string + "' cannot be set to '" + string2 + "'");
        }
    }

    @Override
    public void speechDestroy() {
        this.sendCommand(new SpeechDestroyCommand());
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Speech object cannot be destroyed");
        }
    }

    @Override
    public void speechLoadGrammar(String string, String string2) {
        this.sendCommand(new SpeechLoadGrammarCommand(string, string2));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + string + "' cannot be loaded from '" + string2 + "'");
        }
    }

    @Override
    public void speechUnloadGrammar(String string) {
        this.sendCommand(new SpeechUnloadGrammarCommand(string));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + string + "' cannot be unloaded");
        }
    }

    @Override
    public void speechActivateGrammar(String string) {
        this.sendCommand(new SpeechActivateGrammarCommand(string));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + string + "' cannot be activated");
        }
    }

    @Override
    public void speechDeactivateGrammar(String string) {
        this.sendCommand(new SpeechDeactivateGrammarCommand(string));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Grammar '" + string + "' cannot be deactivated");
        }
    }

    @Override
    public SpeechRecognitionResult speechRecognize(String string, int n2) {
        return this.speechRecognize(new SpeechRecognizeCommand(string, n2));
    }

    @Override
    public SpeechRecognitionResult speechRecognize(String string, int n2, int n3) {
        return this.speechRecognize(new SpeechRecognizeCommand(string, n2, n3));
    }

    private SpeechRecognitionResult speechRecognize(SpeechRecognizeCommand serializable) {
        this.sendCommand((AgiCommand)((Object)serializable));
        if (this.lastReply.getResultCode() != 1) {
            throw new AgiSpeechException("Cannot recognize speech");
        }
        if ("hangup".equals(this.lastReply.getExtra())) {
            throw new AgiHangupException();
        }
        serializable = this.lastReply;
        return new SpeechRecognitionResult((AgiReply)serializable);
    }

    @Override
    public void continueAt(String string, String string2, String string3) {
        this.setContext(string);
        this.setExtension(string2);
        this.setPriority(string3);
    }

    @Override
    public void gosub(String string, String string2, String string3) {
        this.sendCommand(new GosubCommand(string, string2, string3));
    }

    @Override
    public void gosub(String string, String string2, String string3, String ... stringArray) {
        this.sendCommand(new GosubCommand(string, string2, string3, stringArray));
    }

    public AgiRequest getInternalAgiRequest() {
        return this.request;
    }
}

