/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.fastagi.reply.AgiReply;

public class AgiReplyImpl
implements AgiReply {
    private static final Pattern STATUS_PATTERN = Pattern.compile("^(\\d{3})[ -]");
    private static final Pattern RESULT_PATTERN = Pattern.compile("^200 result=(\\S+)");
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("^200 result=\\S* +\\((.*)\\)");
    private static final Pattern ADDITIONAL_ATTRIBUTES_PATTERN = Pattern.compile("^200 result=\\S* +(\\(.*\\) )?(.+)$");
    private static final Pattern SYNOPSIS_PATTERN = Pattern.compile("^\\s*Usage:\\s*(.*)\\s*$");
    private static final String END_OF_PROPER_USAGE = "520 End of proper usage.";
    private static final long serialVersionUID = 3256727294671337012L;
    private List<String> lines;
    private String firstLine;
    private String result;
    private Integer status = null;
    private Map<String, String> attributes;
    private String extra;
    private String synopsis;
    private String usage;
    private boolean extraCreated;

    AgiReplyImpl() {
    }

    AgiReplyImpl(List<String> list) {
        this();
        if (list != null) {
            this.lines = new ArrayList<String>(list);
            if (!list.isEmpty()) {
                this.firstLine = list.get(0);
            }
        }
    }

    @Override
    public String getFirstLine() {
        return this.firstLine;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public int getResultCode() {
        String string = this.getResult();
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public char getResultCodeAsChar() {
        int n2 = this.getResultCode();
        if (n2 < 0) {
            return '\u0000';
        }
        return (char)n2;
    }

    @Override
    public String getResult() {
        if (this.result != null) {
            return this.result;
        }
        Matcher matcher = RESULT_PATTERN.matcher(this.firstLine);
        this.result = matcher.find() ? matcher.group(1) : "";
        return this.result;
    }

    @Override
    public int getStatus() {
        if (this.status != null) {
            return this.status;
        }
        Matcher matcher = STATUS_PATTERN.matcher(this.firstLine);
        if (matcher.find()) {
            this.status = Integer.parseInt(matcher.group(1));
            return this.status;
        }
        return -1;
    }

    @Override
    public String getAttribute(String string) {
        if (this.getStatus() != 200) {
            return null;
        }
        if ("result".equalsIgnoreCase(string)) {
            return this.getResult();
        }
        return this.getAttributes().get(string.toLowerCase(Locale.ENGLISH));
    }

    protected Map<String, String> getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        this.attributes = new HashMap<String, String>();
        Matcher matcher = ADDITIONAL_ATTRIBUTES_PATTERN.matcher(this.firstLine);
        if (matcher.find()) {
            this.attributes.putAll(this.parseAttributes(matcher.group(2)));
        }
        return this.attributes;
    }

    Map<String, String> parseAttributes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl2 = true;
        boolean bl3 = false;
        char c2 = '\u0000';
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == '=' && bl2) {
                bl2 = false;
                bl3 = false;
            } else if (c3 == ' ' && !bl2 && !bl3) {
                hashMap.put(stringBuilder.toString().toLowerCase(Locale.ENGLISH), stringBuilder2.toString());
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder2.delete(0, stringBuilder2.length());
                bl2 = true;
            } else if (c3 == '\"' && !bl2) {
                if (c2 == '\\') {
                    stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                    stringBuilder2.append(c3);
                } else {
                    bl3 = !bl3;
                }
            } else if (bl2) {
                stringBuilder.append(c3);
            } else {
                stringBuilder2.append(c3);
            }
            c2 = c3;
        }
        if (stringBuilder.length() > 0) {
            hashMap.put(stringBuilder.toString().toLowerCase(Locale.ENGLISH), stringBuilder2.toString());
        }
        return hashMap;
    }

    @Override
    public String getExtra() {
        if (this.getStatus() != 200) {
            return null;
        }
        if (this.extraCreated) {
            return this.extra;
        }
        Matcher matcher = PARENTHESIS_PATTERN.matcher(this.firstLine);
        if (matcher.find()) {
            this.extra = matcher.group(1);
        }
        this.extraCreated = true;
        return this.extra;
    }

    @Override
    public String getSynopsis() {
        if (this.getStatus() != 520) {
            return null;
        }
        if (this.synopsis == null && this.lines.size() > 1) {
            Object object = this.lines.get(1);
            if (((Matcher)(object = SYNOPSIS_PATTERN.matcher((CharSequence)object))).find()) {
                this.synopsis = ((Matcher)object).group(1);
            }
        }
        return this.synopsis;
    }

    @Override
    public String getUsage() {
        if (this.usage == null) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 2; i2 < this.lines.size() && !END_OF_PROPER_USAGE.equals(string = this.lines.get(i2)); ++i2) {
                stringBuilder.append(string.trim());
                stringBuilder.append(" ");
            }
            this.usage = stringBuilder.toString().trim();
        }
        return this.usage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AgiReply[");
        stringBuilder.append("status=").append(this.getStatus()).append(",");
        if (this.status == 200) {
            stringBuilder.append("result='").append(this.getResult()).append("',");
            stringBuilder.append("extra='").append(this.getExtra()).append("',");
            stringBuilder.append("attributes=").append(this.getAttributes()).append(",");
        }
        if (this.status == 520) {
            stringBuilder.append("synopsis='").append(this.getSynopsis()).append("',");
        }
        stringBuilder.append("systemHashcode=").append(System.identityHashCode(this));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

