/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiReplyImpl;
import org.asteriskjava.fastagi.internal.AgiRequestImpl;
import org.asteriskjava.fastagi.reply.AgiReply;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.event.AsyncAgiEvent;

public class AsyncAgiReader
implements AgiReader {
    private final AgiRequestImpl request;
    private final BlockingQueue<AsyncAgiEvent> asyncAgiEvents;

    public AsyncAgiReader(ManagerConnection managerConnection, List<String> list, BlockingQueue<AsyncAgiEvent> blockingQueue) {
        this.request = new AgiRequestImpl(list);
        this.asyncAgiEvents = blockingQueue;
        this.request.setLocalAddress(managerConnection.getLocalAddress());
        this.request.setLocalPort(managerConnection.getLocalPort());
        this.request.setRemoteAddress(managerConnection.getRemoteAddress());
        this.request.setRemotePort(managerConnection.getRemotePort());
    }

    @Override
    public AgiRequest readRequest() {
        return this.request;
    }

    @Override
    public AgiReply readReply() {
        try {
            return new AgiReplyImpl(this.asyncAgiEvents.take().decodeResult());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new AgiException("Interrupted while waiting for AsyncAgiEvent", interruptedException);
        }
    }
}

