/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.IOException;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.command.AgiCommand;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.AgiAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

public class AsyncAgiWriter
implements AgiWriter {
    private final ManagerConnection connection;
    private volatile String channelName;

    public AsyncAgiWriter(ManagerConnection managerConnection, String string) {
        this.connection = managerConnection;
        this.channelName = string;
    }

    @Override
    public void sendCommand(AgiCommand object) {
        object = new AgiAction(this.channelName, object.buildCommand());
        try {
            object = this.connection.sendAction((ManagerAction)object);
        }
        catch (IOException iOException) {
            throw new AgiException("Unable to send AsyncAGI command to " + this.connection.getHostname() + " for channel " + this.channelName, iOException);
        }
        catch (TimeoutException timeoutException) {
            throw new AgiException("Timeout while sending AsyncAGI command to " + this.connection.getHostname() + " for channel " + this.channelName, timeoutException);
        }
        if (object instanceof ManagerError) {
            throw new AgiException("Unable to send AsyncAGI command to " + this.connection.getHostname() + " for channel " + this.channelName + ": " + ((ManagerResponse)object).getMessage());
        }
    }

    public void updateChannelName(String string) {
        this.channelName = string;
    }
}

