/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.fastagi.AgiNetworkException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiReplyImpl;
import org.asteriskjava.fastagi.internal.AgiRequestImpl;
import org.asteriskjava.fastagi.reply.AgiReply;
import org.asteriskjava.util.SocketConnectionFacade;

class FastAgiReader
implements AgiReader {
    private final SocketConnectionFacade socket;

    FastAgiReader(SocketConnectionFacade socketConnectionFacade) {
        this.socket = socketConnectionFacade;
    }

    @Override
    public AgiRequest readRequest() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while ((object = this.socket.readLine()) != null && ((String)object).length() != 0) {
                arrayList.add((String)object);
            }
        }
        catch (IOException iOException) {
            throw new AgiNetworkException("Unable to read request from Asterisk: " + iOException.getMessage(), iOException);
        }
        object = new AgiRequestImpl(arrayList);
        ((AgiRequestImpl)object).setLocalAddress(this.socket.getLocalAddress());
        ((AgiRequestImpl)object).setLocalPort(this.socket.getLocalPort());
        ((AgiRequestImpl)object).setRemoteAddress(this.socket.getRemoteAddress());
        ((AgiRequestImpl)object).setRemotePort(this.socket.getRemotePort());
        return object;
    }

    @Override
    public AgiReply readReply() {
        String string;
        Serializable serializable = new ArrayList<String>();
        try {
            string = this.socket.readLine();
        }
        catch (IOException iOException) {
            throw new AgiHangupException();
        }
        if (string == null) {
            throw new AgiHangupException();
        }
        if (string.startsWith("HANGUP")) {
            if (string.length() > 6) {
                string = string.substring(6);
            } else {
                return this.readReply();
            }
        }
        serializable.add(string);
        if (string.startsWith(Integer.toString(520))) {
            try {
                while ((string = this.socket.readLine()) != null) {
                    serializable.add((String)string);
                    if (!string.startsWith(Integer.toString(520))) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                throw new AgiNetworkException("Unable to read reply from Asterisk: " + iOException.getMessage(), iOException);
            }
        }
        if ((serializable = new AgiReplyImpl((List<String>)((Object)serializable))).getStatus() == 100) {
            return this.readReply();
        }
        return serializable;
    }
}

