/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskQueueListener;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl$ServiceLevelTimerTask;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class AsteriskQueueImpl
extends AbstractLiveObject
implements AsteriskQueue {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String name;
    private Integer max;
    private String strategy;
    private Integer serviceLevel;
    private Integer weight;
    private final ArrayList<AsteriskQueueEntryImpl> entries;
    private final Timer timer;
    private final HashMap<String, AsteriskQueueMemberImpl> members;
    private final List<AsteriskQueueListener> listeners;
    private final HashMap<AsteriskQueueEntry, AsteriskQueueImpl$ServiceLevelTimerTask> serviceLevelTimerTasks;

    AsteriskQueueImpl(AsteriskServerImpl asteriskServerImpl, String string, Integer n2, String string2, Integer n3, Integer n4) {
        super(asteriskServerImpl);
        this.name = string;
        this.max = n2;
        this.strategy = string2;
        this.serviceLevel = n3;
        this.weight = n4;
        this.entries = new ArrayList(25);
        this.listeners = new ArrayList<AsteriskQueueListener>();
        this.members = new HashMap();
        this.timer = new Timer("ServiceLevelTimer-" + string, true);
        this.serviceLevelTimerTasks = new HashMap();
    }

    void cancelServiceLevelTimer() {
        this.timer.cancel();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    void setMax(Integer n2) {
        this.max = n2;
    }

    @Override
    public Integer getServiceLevel() {
        return this.serviceLevel;
    }

    void setServiceLevel(Integer n2) {
        this.serviceLevel = n2;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    void setWeight(Integer n2) {
        this.weight = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsteriskQueueEntry> getEntries() {
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            return new ArrayList<AsteriskQueueEntry>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shift() {
        int n2 = 1;
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            for (AsteriskQueueEntryImpl asteriskQueueEntryImpl : this.entries) {
                if (asteriskQueueEntryImpl.getPosition() != n2) {
                    asteriskQueueEntryImpl.setPosition(n2);
                }
                ++n2;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewEntry(AsteriskChannelImpl asteriskChannelImpl, int n2, Date object) {
        AsteriskQueueEntryImpl asteriskQueueEntryImpl = new AsteriskQueueEntryImpl(this.server, this, asteriskChannelImpl, n2, (Date)object);
        long l2 = (long)this.serviceLevel.intValue() * 1000L;
        if (l2 > 0L) {
            object = new AsteriskQueueImpl$ServiceLevelTimerTask(this, asteriskQueueEntryImpl);
            this.timer.schedule((TimerTask)object, l2);
            HashMap<AsteriskQueueEntry, AsteriskQueueImpl$ServiceLevelTimerTask> hashMap = this.serviceLevelTimerTasks;
            synchronized (hashMap) {
                this.serviceLevelTimerTasks.put(asteriskQueueEntryImpl, (AsteriskQueueImpl$ServiceLevelTimerTask)object);
            }
        }
        object = this.entries;
        synchronized (object) {
            this.entries.add(asteriskQueueEntryImpl);
            this.shift();
        }
        asteriskChannelImpl.setQueueEntry(asteriskQueueEntryImpl);
        this.fireNewEntry(asteriskQueueEntryImpl);
        this.server.fireNewQueueEntry(asteriskQueueEntryImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(AsteriskQueueEntryImpl asteriskQueueEntryImpl, Date date) {
        boolean bl2;
        HashMap<AsteriskQueueEntry, AsteriskQueueImpl$ServiceLevelTimerTask> hashMap = this.serviceLevelTimerTasks;
        synchronized (hashMap) {
            if (this.serviceLevelTimerTasks.containsKey(asteriskQueueEntryImpl)) {
                this.serviceLevelTimerTasks.get(asteriskQueueEntryImpl).cancel();
                this.serviceLevelTimerTasks.remove(asteriskQueueEntryImpl);
            }
        }
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            bl2 = this.entries.remove(asteriskQueueEntryImpl);
            if (bl2) {
                this.shift();
            }
        }
        if (bl2) {
            asteriskQueueEntryImpl.getChannel().setQueueEntry(null);
            asteriskQueueEntryImpl.left(date);
            this.fireEntryLeave(asteriskQueueEntryImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AsteriskQueue[");
        stringBuffer.append("name='").append(this.getName()).append("',");
        stringBuffer.append("max='").append(this.getMax()).append("',");
        stringBuffer.append("strategy='").append(this.getStrategy()).append("',");
        stringBuffer.append("serviceLevel='").append(this.getServiceLevel()).append("',");
        stringBuffer.append("weight='").append(this.getWeight()).append("',");
        Cloneable cloneable = this.entries;
        synchronized (cloneable) {
            stringBuffer.append("entries='").append(this.entries.toString()).append("',");
        }
        cloneable = this.members;
        synchronized (cloneable) {
            stringBuffer.append("members='").append(this.members.toString()).append("',");
        }
        stringBuffer.append("systemHashcode=").append(System.identityHashCode(this));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsteriskQueueListener(AsteriskQueueListener asteriskQueueListener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(asteriskQueueListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsteriskQueueListener(AsteriskQueueListener asteriskQueueListener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(asteriskQueueListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewEntry(AsteriskQueueEntryImpl asteriskQueueEntryImpl) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener asteriskQueueListener : this.listeners) {
                try {
                    asteriskQueueListener.onNewEntry(asteriskQueueEntryImpl);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onNewEntry()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEntryLeave(AsteriskQueueEntryImpl asteriskQueueEntryImpl) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener asteriskQueueListener : this.listeners) {
                try {
                    asteriskQueueListener.onEntryLeave(asteriskQueueEntryImpl);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onEntryLeave()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberAdded(AsteriskQueueMemberImpl asteriskQueueMemberImpl) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener asteriskQueueListener : this.listeners) {
                try {
                    asteriskQueueListener.onMemberAdded(asteriskQueueMemberImpl);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onMemberAdded()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberRemoved(AsteriskQueueMemberImpl asteriskQueueMemberImpl) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener asteriskQueueListener : this.listeners) {
                try {
                    asteriskQueueListener.onMemberRemoved(asteriskQueueMemberImpl);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onMemberRemoved()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AsteriskQueueMember> getMembers() {
        ArrayList<AsteriskQueueMember> arrayList = new ArrayList<AsteriskQueueMember>(this.members.size());
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            for (AsteriskQueueMemberImpl asteriskQueueMemberImpl : this.members.values()) {
                arrayList.add(asteriskQueueMemberImpl);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueMemberImpl getMember(String string) {
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            if (this.members.containsKey(string)) {
                return this.members.get(string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(AsteriskQueueMemberImpl asteriskQueueMemberImpl) {
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            if (this.members.containsValue(asteriskQueueMemberImpl)) {
                return;
            }
            this.logger.info("Adding new member to the queue " + this.getName() + ": " + asteriskQueueMemberImpl.toString());
            this.members.put(asteriskQueueMemberImpl.getLocation(), asteriskQueueMemberImpl);
        }
        this.fireMemberAdded(asteriskQueueMemberImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueMemberImpl getMemberByLocation(String string) {
        AsteriskQueueMemberImpl asteriskQueueMemberImpl;
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            asteriskQueueMemberImpl = this.members.get(string);
        }
        if (asteriskQueueMemberImpl == null) {
            this.logger.error("Requested member at location " + string + " not found!");
        }
        return asteriskQueueMemberImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberStateChanged(AsteriskQueueMemberImpl asteriskQueueMemberImpl) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener asteriskQueueListener : this.listeners) {
                try {
                    asteriskQueueListener.onMemberStateChange(asteriskQueueMemberImpl);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in onMemberStateChange()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueEntryImpl getEntry(String string) {
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            for (AsteriskQueueEntryImpl asteriskQueueEntryImpl : this.entries) {
                if (!asteriskQueueEntryImpl.getChannel().getName().equals(string)) continue;
                return asteriskQueueEntryImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(AsteriskQueueMemberImpl asteriskQueueMemberImpl) {
        HashMap<String, AsteriskQueueMemberImpl> hashMap = this.members;
        synchronized (hashMap) {
            if (!this.members.containsValue(asteriskQueueMemberImpl)) {
                return;
            }
            this.logger.info("Remove member from the queue " + this.getName() + ": " + asteriskQueueMemberImpl.toString());
            this.members.remove(asteriskQueueMemberImpl.getLocation());
        }
        this.fireMemberRemoved(asteriskQueueMemberImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireServiceLevelExceeded(AsteriskQueueEntry asteriskQueueEntry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener asteriskQueueListener : this.listeners) {
                try {
                    asteriskQueueListener.onEntryServiceLevelExceeded(asteriskQueueEntry);
                }
                catch (Exception exception) {
                    this.logger.warn("Exception in fireServiceLevelExceeded()", exception);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueEntryImpl getEntry(int n2) {
        --n2;
        AsteriskQueueEntryImpl asteriskQueueEntryImpl = null;
        ArrayList<AsteriskQueueEntryImpl> arrayList = this.entries;
        synchronized (arrayList) {
            try {
                asteriskQueueEntryImpl = this.entries.get(n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return asteriskQueueEntryImpl;
    }
}

