/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.InvalidPenaltyException;
import org.asteriskjava.live.NoSuchInterfaceException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.manager.action.QueuePauseAction;
import org.asteriskjava.manager.action.QueuePenaltyAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

class AsteriskQueueMemberImpl
extends AbstractLiveObject
implements AsteriskQueueMember {
    private AsteriskQueue queue;
    private QueueMemberState state;
    private String location;
    private Integer penalty;
    private boolean paused;
    private String membership;

    AsteriskQueueMemberImpl(AsteriskServerImpl asteriskServerImpl, AsteriskQueueImpl asteriskQueueImpl, String string, QueueMemberState queueMemberState, boolean bl2, Integer n2, String string2) {
        super(asteriskServerImpl);
        this.queue = asteriskQueueImpl;
        this.location = string;
        this.state = queueMemberState;
        this.penalty = n2;
        this.paused = bl2;
        this.membership = string2;
    }

    @Override
    public AsteriskQueue getQueue() {
        return this.queue;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public QueueMemberState getState() {
        return this.state;
    }

    @Override
    @Deprecated
    public boolean getPaused() {
        return this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setPaused(boolean bl2) {
        this.sendPauseAction(new QueuePauseAction(this.location, this.queue.getName(), bl2));
    }

    @Override
    public void setPausedAll(boolean bl2) {
        this.sendPauseAction(new QueuePauseAction(this.location, bl2));
    }

    private void sendPauseAction(QueuePauseAction queuePauseAction) {
        ManagerResponse managerResponse = this.server.sendAction(queuePauseAction);
        if (managerResponse instanceof ManagerError) {
            if (queuePauseAction.getQueue() != null) {
                throw new NoSuchInterfaceException("Unable to change paused state for '" + queuePauseAction.getInterface() + "' on '" + queuePauseAction.getQueue() + "': " + managerResponse.getMessage());
            }
            throw new NoSuchInterfaceException("Unable to change paused state for '" + queuePauseAction.getInterface() + "' on all queues: " + managerResponse.getMessage());
        }
    }

    @Override
    public String getMembership() {
        return this.membership;
    }

    @Override
    public boolean isStatic() {
        return this.membership != null && "static".equals(this.membership);
    }

    @Override
    public boolean isDynamic() {
        return this.membership != null && "dynamic".equals(this.membership);
    }

    @Override
    public Integer getPenalty() {
        return this.penalty;
    }

    @Override
    public void setPenalty(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Penalty must not be negative");
        }
        ManagerResponse managerResponse = this.server.sendAction(new QueuePenaltyAction(this.location, n2, this.queue.getName()));
        if (managerResponse instanceof ManagerError) {
            throw new InvalidPenaltyException("Unable to set penalty for '" + this.location + "' on '" + this.queue.getName() + "': " + managerResponse.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AsteriskQueueMember[");
        stringBuffer.append("location='").append(this.location).append("'");
        stringBuffer.append("state='").append((Object)this.state).append("'");
        stringBuffer.append("paused='").append(this.paused).append("'");
        stringBuffer.append("membership='").append(this.membership).append("'");
        stringBuffer.append("queue='").append(this.queue.getName()).append("'");
        stringBuffer.append("systemHashcode=").append(System.identityHashCode(this));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    synchronized void stateChanged(QueueMemberState queueMemberState) {
        QueueMemberState queueMemberState2 = this.state;
        this.state = queueMemberState;
        this.firePropertyChange("state", (Object)queueMemberState2, (Object)queueMemberState);
    }

    synchronized void penaltyChanged(Integer n2) {
        Integer n3 = this.penalty;
        this.penalty = n2;
        this.firePropertyChange("penalty", n3, n2);
    }

    synchronized void pausedChanged(boolean bl2) {
        boolean bl3 = this.paused;
        this.paused = bl2;
        this.firePropertyChange("paused", bl3, bl2);
    }
}

