/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.live.internal.MeetMeRoomImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.event.AbstractMeetMeEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MeetMeLeaveEvent;
import org.asteriskjava.manager.event.MeetMeMuteEvent;
import org.asteriskjava.manager.event.MeetMeTalkingEvent;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class MeetMeManager {
    private static final String MEETME_LIST_COMMAND = "meetme list";
    private static final Pattern MEETME_LIST_PATTERN = Pattern.compile("^User #: ([0-9]+).*Channel: (\\S+).*$");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final ChannelManager channelManager;
    private final Map<String, MeetMeRoomImpl> rooms;

    MeetMeManager(AsteriskServerImpl asteriskServerImpl, ChannelManager channelManager) {
        this.server = asteriskServerImpl;
        this.channelManager = channelManager;
        this.rooms = new HashMap<String, MeetMeRoomImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        Map<String, MeetMeRoomImpl> map = this.rooms;
        synchronized (map) {
            for (MeetMeRoomImpl meetMeRoomImpl : this.rooms.values()) {
                this.populateRoom(meetMeRoomImpl);
            }
            return;
        }
    }

    void disconnected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<MeetMeRoom> getMeetMeRooms() {
        ArrayList<MeetMeRoom> arrayList = new ArrayList<MeetMeRoom>();
        Map<String, MeetMeRoomImpl> map = this.rooms;
        synchronized (map) {
            for (MeetMeRoom meetMeRoom : this.rooms.values()) {
                if (meetMeRoom.isEmpty()) continue;
                arrayList.add(meetMeRoom);
            }
        }
        return arrayList;
    }

    void handleMeetMeEvent(AbstractMeetMeEvent serializable) {
        String string = ((AbstractMeetMeEvent)serializable).getMeetMe();
        if (string == null) {
            this.logger.warn("RoomNumber (meetMe property) is null. Ignoring " + serializable.getClass().getName());
            return;
        }
        if (((AbstractMeetMeEvent)serializable).getUserNum() == null) {
            this.logger.warn("UserNumber (userNum property) is null. Ignoring " + serializable.getClass().getName());
            return;
        }
        MeetMeUserImpl meetMeUserImpl = this.getOrCreateUserImpl((AbstractMeetMeEvent)serializable);
        if (meetMeUserImpl == null) {
            return;
        }
        AsteriskChannelImpl asteriskChannelImpl = meetMeUserImpl.getChannel();
        MeetMeRoomImpl meetMeRoomImpl = meetMeUserImpl.getRoom();
        if (serializable instanceof MeetMeLeaveEvent) {
            this.logger.info("Removing channel " + asteriskChannelImpl.getName() + " from room " + string);
            if (meetMeRoomImpl != meetMeUserImpl.getRoom()) {
                if (meetMeUserImpl.getRoom() != null) {
                    this.logger.error("Channel " + asteriskChannelImpl.getName() + " should be removed from room " + string + " but is user of room " + meetMeUserImpl.getRoom().getRoomNumber());
                    meetMeUserImpl.getRoom().removeUser(meetMeUserImpl);
                } else {
                    this.logger.error("Channel " + asteriskChannelImpl.getName() + " should be removed from room " + string + " but is user of no room");
                }
            }
            meetMeUserImpl.left(((ManagerEvent)serializable).getDateReceived());
            meetMeRoomImpl.removeUser(meetMeUserImpl);
            asteriskChannelImpl.setMeetMeUserImpl(null);
            return;
        }
        if (serializable instanceof MeetMeTalkingEvent) {
            if ((serializable = ((MeetMeTalkingEvent)serializable).getStatus()) != null) {
                meetMeUserImpl.setTalking((Boolean)serializable);
                return;
            }
            meetMeUserImpl.setTalking(true);
            return;
        }
        if (serializable instanceof MeetMeMuteEvent && (serializable = ((MeetMeMuteEvent)serializable).getStatus()) != null) {
            meetMeUserImpl.setMuted((Boolean)serializable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateRoom(MeetMeRoomImpl meetMeRoomImpl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Collection<MeetMeUserImpl> collection = new CommandAction("meetme list " + meetMeRoomImpl.getRoomNumber());
        try {
            collection = this.server.sendAction((ManagerAction)((Object)collection));
        }
        catch (ManagerCommunicationException managerCommunicationException) {
            this.logger.error("Unable to send \"meetme list\" command", managerCommunicationException);
            return;
        }
        if (collection instanceof ManagerError) {
            this.logger.error("Unable to send \"meetme list\" command: " + ((ManagerResponse)((Object)collection)).getMessage());
            return;
        }
        if (!(collection instanceof CommandResponse)) {
            this.logger.error("Response to \"meetme list\" command is not a CommandResponse but " + collection.getClass());
            return;
        }
        for (String string : ((CommandResponse)((Object)collection)).getResult()) {
            void var4_9;
            MeetMeUserImpl meetMeUserImpl;
            MeetMeUserImpl meetMeUserImpl2;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object = MEETME_LIST_PATTERN.matcher(string);
            if (!((Matcher)object).matches()) continue;
            Integer n2 = Integer.valueOf(((Matcher)object).group(1));
            object = this.channelManager.getChannelImplByName(((Matcher)object).group(2));
            arrayList.add(n2);
            if (string.contains("(Admin Muted)") || string.contains("(Muted)")) {
                bl2 = true;
            }
            if (string.contains("(talking)")) {
                bl3 = true;
            }
            if ((meetMeUserImpl2 = ((AsteriskChannelImpl)object).getMeetMeUser()) != null && meetMeUserImpl2.getRoom() != meetMeRoomImpl) {
                meetMeUserImpl2.left(DateUtil.getDate());
                Object var4_8 = null;
            }
            if ((meetMeUserImpl = meetMeRoomImpl.getUser(n2)) != null && meetMeUserImpl.getChannel() != object) {
                meetMeRoomImpl.removeUser(meetMeUserImpl);
                meetMeUserImpl = null;
            }
            if (var4_9 == null && meetMeUserImpl == null) {
                MeetMeUserImpl meetMeUserImpl3 = new MeetMeUserImpl(this.server, meetMeRoomImpl, n2, (AsteriskChannelImpl)object, DateUtil.getDate());
                meetMeUserImpl3.setMuted(bl2);
                meetMeUserImpl3.setTalking(bl3);
                meetMeRoomImpl.addUser(meetMeUserImpl3);
                ((AsteriskChannelImpl)object).setMeetMeUserImpl(meetMeUserImpl3);
                this.server.fireNewMeetMeUser(meetMeUserImpl3);
                continue;
            }
            if (var4_9 != null && meetMeUserImpl == null) {
                var4_9.setMuted(bl2);
                meetMeRoomImpl.addUser((MeetMeUserImpl)var4_9);
                continue;
            }
            if (var4_9 == null && meetMeUserImpl != null) {
                meetMeUserImpl.setMuted(bl2);
                ((AsteriskChannelImpl)object).setMeetMeUserImpl(meetMeUserImpl);
                continue;
            }
            if (var4_9 == meetMeUserImpl) continue;
            this.logger.error("Inconsistent state: channelUser != roomUser, channelUser=" + var4_9 + ", roomUser=" + meetMeUserImpl);
        }
        collection = meetMeRoomImpl.getUserImpls();
        ArrayList<MeetMeUserImpl> arrayList2 = new ArrayList<MeetMeUserImpl>();
        for (MeetMeUserImpl meetMeUserImpl : collection) {
            if (arrayList.contains(meetMeUserImpl.getUserNumber())) continue;
            arrayList2.add(meetMeUserImpl);
        }
        for (MeetMeUserImpl meetMeUserImpl : arrayList2) {
            meetMeUserImpl.left(DateUtil.getDate());
            meetMeRoomImpl.removeUser(meetMeUserImpl);
            meetMeUserImpl.getChannel().setMeetMeUserImpl(null);
        }
    }

    private MeetMeUserImpl getOrCreateUserImpl(AbstractMeetMeEvent abstractMeetMeEvent) {
        String string = abstractMeetMeEvent.getMeetMe();
        MeetMeRoomImpl meetMeRoomImpl = this.getOrCreateRoomImpl(string);
        Object object = meetMeRoomImpl.getUser(abstractMeetMeEvent.getUserNum());
        if (object != null) {
            return object;
        }
        object = abstractMeetMeEvent.getUniqueId();
        if (object == null) {
            this.logger.warn("UniqueId is null. Ignoring MeetMeEvent");
            return null;
        }
        AsteriskChannelImpl asteriskChannelImpl = this.channelManager.getChannelImplById((String)object);
        if (asteriskChannelImpl == null) {
            this.logger.warn("No channel with unique id " + (String)object + ". Ignoring MeetMeEvent");
            return null;
        }
        object = asteriskChannelImpl.getMeetMeUser();
        if (object != null) {
            this.logger.error("Got MeetMeEvent for channel " + asteriskChannelImpl.getName() + " that is already user of a room");
            ((MeetMeUserImpl)object).left(abstractMeetMeEvent.getDateReceived());
            if (((MeetMeUserImpl)object).getRoom() != null) {
                ((MeetMeUserImpl)object).getRoom().removeUser((MeetMeUserImpl)object);
            }
            asteriskChannelImpl.setMeetMeUserImpl(null);
        }
        this.logger.info("Adding channel " + asteriskChannelImpl.getName() + " as user " + abstractMeetMeEvent.getUserNum() + " to room " + string);
        object = new MeetMeUserImpl(this.server, meetMeRoomImpl, abstractMeetMeEvent.getUserNum(), asteriskChannelImpl, abstractMeetMeEvent.getDateReceived());
        meetMeRoomImpl.addUser((MeetMeUserImpl)object);
        asteriskChannelImpl.setMeetMeUserImpl((MeetMeUserImpl)object);
        this.server.fireNewMeetMeUser((MeetMeUser)object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MeetMeRoomImpl getOrCreateRoomImpl(String string) {
        MeetMeRoomImpl meetMeRoomImpl;
        boolean bl2 = false;
        Map<String, MeetMeRoomImpl> map = this.rooms;
        synchronized (map) {
            meetMeRoomImpl = this.rooms.get(string);
            if (meetMeRoomImpl == null) {
                meetMeRoomImpl = new MeetMeRoomImpl(this.server, string);
                this.populateRoom(meetMeRoomImpl);
                this.rooms.put(string, meetMeRoomImpl);
                bl2 = true;
            }
        }
        if (bl2) {
            this.logger.debug("Created MeetMeRoom " + string);
        }
        return meetMeRoomImpl;
    }
}

