/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.ChannelManager;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.action.QueueStatusAction;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberPenaltyEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class QueueManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AsteriskServerImpl server;
    private final ChannelManager channelManager;
    private final Map<String, AsteriskQueueImpl> queues;

    QueueManager(AsteriskServerImpl asteriskServerImpl, ChannelManager channelManager) {
        this.server = asteriskServerImpl;
        this.channelManager = channelManager;
        this.queues = new HashMap<String, AsteriskQueueImpl>();
    }

    void initialize() {
        Object object;
        try {
            object = this.server.sendEventGeneratingAction(new QueueStatusAction());
        }
        catch (ManagerCommunicationException managerCommunicationException) {
            object = managerCommunicationException;
            Throwable serializable = managerCommunicationException.getCause();
            if (serializable instanceof EventTimeoutException) {
                object = ((EventTimeoutException)serializable).getPartialResult();
            }
            throw object;
        }
        for (ManagerEvent managerEvent : object.getEvents()) {
            if (managerEvent instanceof QueueParamsEvent) {
                this.handleQueueParamsEvent((QueueParamsEvent)managerEvent);
                continue;
            }
            if (managerEvent instanceof QueueMemberEvent) {
                this.handleQueueMemberEvent((QueueMemberEvent)managerEvent);
                continue;
            }
            if (!(managerEvent instanceof QueueEntryEvent)) continue;
            this.handleQueueEntryEvent((QueueEntryEvent)managerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnected() {
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            Iterator<AsteriskQueueImpl> iterator = this.queues.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().cancelServiceLevelTimer();
            }
            this.queues.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<AsteriskQueue> getQueues() {
        ArrayList<AsteriskQueue> arrayList;
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            arrayList = new ArrayList<AsteriskQueue>(this.queues.values());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueue(AsteriskQueueImpl asteriskQueueImpl) {
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            this.queues.put(asteriskQueueImpl.getName(), asteriskQueueImpl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueueParamsEvent(QueueParamsEvent object) {
        Object object2 = ((QueueParamsEvent)object).getQueue();
        Integer n2 = ((QueueParamsEvent)object).getMax();
        String string = ((QueueParamsEvent)object).getStrategy();
        Integer n3 = ((QueueParamsEvent)object).getServiceLevel();
        Integer n4 = ((QueueParamsEvent)object).getWeight();
        object = this.queues.get(object2);
        if (object == null) {
            object = new AsteriskQueueImpl(this.server, (String)object2, n2, string, n3, n4);
            this.logger.info("Adding new queue " + object);
            this.addQueue((AsteriskQueueImpl)object);
            return;
        }
        object2 = object;
        synchronized (object2) {
            ((AsteriskQueueImpl)object).setMax(n2);
            ((AsteriskQueueImpl)object).setServiceLevel(n3);
            ((AsteriskQueueImpl)object).setWeight(n4);
            return;
        }
    }

    private void handleQueueMemberEvent(QueueMemberEvent queueMemberEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.queues.get(queueMemberEvent.getQueue());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + queueMemberEvent.getQueue());
            return;
        }
        AsteriskQueueMemberImpl asteriskQueueMemberImpl = asteriskQueueImpl.getMember(queueMemberEvent.getLocation());
        if (asteriskQueueMemberImpl == null) {
            asteriskQueueMemberImpl = new AsteriskQueueMemberImpl(this.server, asteriskQueueImpl, queueMemberEvent.getLocation(), QueueMemberState.valueOf(queueMemberEvent.getStatus()), queueMemberEvent.getPaused(), queueMemberEvent.getPenalty(), queueMemberEvent.getMembership());
        }
        asteriskQueueImpl.addMember(asteriskQueueMemberImpl);
    }

    private void handleQueueEntryEvent(QueueEntryEvent queueEntryEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.getQueueByName(queueEntryEvent.getQueue());
        AsteriskChannelImpl asteriskChannelImpl = this.channelManager.getChannelImplByName(queueEntryEvent.getChannel());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown queue " + queueEntryEvent.getQueue());
            return;
        }
        if (asteriskChannelImpl == null) {
            this.logger.error("Ignored QueueEntryEvent for unknown channel " + queueEntryEvent.getChannel());
            return;
        }
        if (asteriskQueueImpl.getEntry(queueEntryEvent.getChannel()) != null) {
            this.logger.error("Ignored duplicate queue entry during population in queue " + queueEntryEvent.getQueue() + " for channel " + queueEntryEvent.getChannel());
            return;
        }
        int n2 = queueEntryEvent.getPosition();
        asteriskQueueImpl.createNewEntry(asteriskChannelImpl, n2, queueEntryEvent.getDateReceived());
    }

    void handleJoinEvent(JoinEvent joinEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.getQueueByName(joinEvent.getQueue());
        AsteriskChannelImpl asteriskChannelImpl = this.channelManager.getChannelImplByName(joinEvent.getChannel());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored JoinEvent for unknown queue " + joinEvent.getQueue());
            return;
        }
        if (asteriskChannelImpl == null) {
            this.logger.error("Ignored JoinEvent for unknown channel " + joinEvent.getChannel());
            return;
        }
        if (asteriskQueueImpl.getEntry(joinEvent.getChannel()) != null) {
            this.logger.error("Ignored duplicate queue entry in queue " + joinEvent.getQueue() + " for channel " + joinEvent.getChannel());
            return;
        }
        int n2 = joinEvent.getPosition();
        asteriskQueueImpl.createNewEntry(asteriskChannelImpl, n2, joinEvent.getDateReceived());
    }

    void handleLeaveEvent(LeaveEvent leaveEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.getQueueByName(leaveEvent.getQueue());
        AbstractLiveObject abstractLiveObject = this.channelManager.getChannelImplByName(leaveEvent.getChannel());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored LeaveEvent for unknown queue " + leaveEvent.getQueue());
            return;
        }
        if (abstractLiveObject == null) {
            this.logger.error("Ignored LeaveEvent for unknown channel " + leaveEvent.getChannel());
            return;
        }
        abstractLiveObject = asteriskQueueImpl.getEntry(leaveEvent.getChannel());
        if (abstractLiveObject == null) {
            this.logger.error("Ignored leave event for non existing queue entry in queue " + leaveEvent.getQueue() + " for channel " + leaveEvent.getChannel());
            return;
        }
        asteriskQueueImpl.removeEntry((AsteriskQueueEntryImpl)abstractLiveObject, leaveEvent.getDateReceived());
    }

    void handleQueueMemberStatusEvent(QueueMemberStatusEvent queueMemberStatusEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.getQueueByName(queueMemberStatusEvent.getQueue());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown queue " + queueMemberStatusEvent.getQueue());
            return;
        }
        AsteriskQueueMemberImpl asteriskQueueMemberImpl = asteriskQueueImpl.getMemberByLocation(queueMemberStatusEvent.getLocation());
        if (asteriskQueueMemberImpl == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown member " + queueMemberStatusEvent.getLocation());
            return;
        }
        asteriskQueueMemberImpl.stateChanged(QueueMemberState.valueOf(queueMemberStatusEvent.getStatus()));
        asteriskQueueMemberImpl.penaltyChanged(queueMemberStatusEvent.getPenalty());
        asteriskQueueImpl.fireMemberStateChanged(asteriskQueueMemberImpl);
    }

    void handleQueueMemberPausedEvent(QueueMemberPausedEvent queueMemberPausedEvent) {
        AbstractLiveObject abstractLiveObject = this.getQueueByName(queueMemberPausedEvent.getQueue());
        if (abstractLiveObject == null) {
            this.logger.error("Ignored QueueMemberPausedEvent for unknown queue " + queueMemberPausedEvent.getQueue());
            return;
        }
        if ((abstractLiveObject = ((AsteriskQueueImpl)abstractLiveObject).getMemberByLocation(queueMemberPausedEvent.getLocation())) == null) {
            this.logger.error("Ignored QueueMemberPausedEvent for unknown member " + queueMemberPausedEvent.getLocation());
            return;
        }
        ((AsteriskQueueMemberImpl)abstractLiveObject).pausedChanged(queueMemberPausedEvent.getPaused());
    }

    void handleQueueMemberPenaltyEvent(QueueMemberPenaltyEvent queueMemberPenaltyEvent) {
        AbstractLiveObject abstractLiveObject = this.getQueueByName(queueMemberPenaltyEvent.getQueue());
        if (abstractLiveObject == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown queue " + queueMemberPenaltyEvent.getQueue());
            return;
        }
        if ((abstractLiveObject = ((AsteriskQueueImpl)abstractLiveObject).getMemberByLocation(queueMemberPenaltyEvent.getLocation())) == null) {
            this.logger.error("Ignored QueueMemberStatusEvent for unknown member " + queueMemberPenaltyEvent.getLocation());
            return;
        }
        ((AsteriskQueueMemberImpl)abstractLiveObject).penaltyChanged(queueMemberPenaltyEvent.getPenalty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsteriskQueueImpl getQueueByName(String string) {
        AsteriskQueueImpl asteriskQueueImpl;
        Map<String, AsteriskQueueImpl> map = this.queues;
        synchronized (map) {
            asteriskQueueImpl = this.queues.get(string);
        }
        if (asteriskQueueImpl == null) {
            this.logger.error("Requested queue '" + string + "' not found!");
        }
        return asteriskQueueImpl;
    }

    public void handleQueueMemberAddedEvent(QueueMemberAddedEvent queueMemberAddedEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.queues.get(queueMemberAddedEvent.getQueue());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored QueueMemberAddedEvent for unknown queue " + queueMemberAddedEvent.getQueue());
            return;
        }
        AsteriskQueueMemberImpl asteriskQueueMemberImpl = asteriskQueueImpl.getMember(queueMemberAddedEvent.getLocation());
        if (asteriskQueueMemberImpl == null) {
            asteriskQueueMemberImpl = new AsteriskQueueMemberImpl(this.server, asteriskQueueImpl, queueMemberAddedEvent.getLocation(), QueueMemberState.valueOf(queueMemberAddedEvent.getStatus()), queueMemberAddedEvent.getPaused(), queueMemberAddedEvent.getPenalty(), queueMemberAddedEvent.getMembership());
        }
        asteriskQueueImpl.addMember(asteriskQueueMemberImpl);
    }

    public void handleQueueMemberRemovedEvent(QueueMemberRemovedEvent queueMemberRemovedEvent) {
        AsteriskQueueImpl asteriskQueueImpl = this.queues.get(queueMemberRemovedEvent.getQueue());
        if (asteriskQueueImpl == null) {
            this.logger.error("Ignored QueueMemberRemovedEvent for unknown queue " + queueMemberRemovedEvent.getQueue());
            return;
        }
        AsteriskQueueMemberImpl asteriskQueueMemberImpl = asteriskQueueImpl.getMember(queueMemberRemovedEvent.getLocation());
        if (asteriskQueueMemberImpl == null) {
            this.logger.error("Ignored QueueMemberRemovedEvent for unknown agent name: " + queueMemberRemovedEvent.getMemberName() + " location: " + queueMemberRemovedEvent.getLocation() + " queue: " + queueMemberRemovedEvent.getQueue());
            return;
        }
        asteriskQueueImpl.removeMember(asteriskQueueMemberImpl);
    }
}

