/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.asteriskjava.manager.event.ResponseEvent;

public class AsyncAgiEvent
extends ResponseEvent {
    static final long serialVersionUID = 0L;
    public static final String SUB_EVENT_START = "Start";
    public static final String SUB_EVENT_EXEC = "Exec";
    public static final String SUB_EVENT_END = "End";
    private String channel;
    private String subEvent;
    private String commandId;
    private String result;
    private String env;

    public AsyncAgiEvent(Object object) {
        super(object);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public String getSubEvent() {
        return this.subEvent;
    }

    public void setSubEvent(String string) {
        this.subEvent = string;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String string) {
        this.commandId = string;
    }

    public String getResult() {
        return this.result;
    }

    public List<String> decodeResult() {
        return this.decode(this.getResult());
    }

    public void setResult(String string) {
        this.result = string;
    }

    public String getEnv() {
        return this.env;
    }

    public List<String> decodeEnv() {
        return this.decode(this.getEnv());
    }

    private List<String> decode(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        try {
            string = URLDecoder.decode(string, "ISO-8859-1");
            arrayList.addAll(Arrays.asList(string.split("\n")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("This JDK does not support ISO-8859-1 encoding", unsupportedEncodingException);
        }
        return arrayList;
    }

    public void setEnv(String string) {
        this.env = string;
    }

    public boolean isStart() {
        return this.isSubEvent(SUB_EVENT_START);
    }

    public boolean isExec() {
        return this.isSubEvent(SUB_EVENT_EXEC);
    }

    public boolean isEnd() {
        return this.isSubEvent(SUB_EVENT_END);
    }

    protected boolean isSubEvent(String string) {
        return this.subEvent != null && this.subEvent.equalsIgnoreCase(string);
    }
}

