/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AsteriskMapping;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.internal.ActionBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

class ActionBuilderImpl
implements ActionBuilder {
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String ATTRIBUTES_PROPERTY_NAME = "attributes";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AsteriskVersion targetVersion = AsteriskVersion.ASTERISK_1_0;

    ActionBuilderImpl() {
    }

    @Override
    public void setTargetVersion(AsteriskVersion asteriskVersion) {
        this.targetVersion = asteriskVersion;
    }

    @Override
    public String buildAction(ManagerAction managerAction) {
        return this.buildAction(managerAction, null);
    }

    @Override
    public String buildAction(ManagerAction object, String object22) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("action: ");
        stringBuffer.append(object.getAction());
        stringBuffer.append(LINE_SEPARATOR);
        if (object22 != null) {
            stringBuffer.append("actionid: ");
            stringBuffer.append(ManagerUtil.addInternalActionId(object.getActionId(), (String)object22));
            stringBuffer.append(LINE_SEPARATOR);
        } else if (object.getActionId() != null) {
            stringBuffer.append("actionid: ");
            stringBuffer.append(object.getActionId());
            stringBuffer.append(LINE_SEPARATOR);
        }
        HashSet<String> exception = new HashSet<String>();
        exception.add("class");
        exception.add("action");
        exception.add("actionid");
        exception.add(ATTRIBUTES_PROPERTY_NAME);
        if (object instanceof UserEventAction) {
            object2 = ((UserEventAction)((Object)object)).getUserEvent();
            this.appendUserEvent(stringBuffer, (UserEvent)object2);
            this.appendGetters(stringBuffer, object2, exception);
        } else {
            this.appendGetters(stringBuffer, object, exception);
        }
        object2 = ReflectionUtil.getGetters(object.getClass());
        if (object2.containsKey(ATTRIBUTES_PROPERTY_NAME)) {
            Method method = (Method)object2.get(ATTRIBUTES_PROPERTY_NAME);
            object2 = null;
            try {
                object2 = method.invoke((Object)object, new Object[0]);
            }
            catch (Exception exception2) {
                this.logger.error("Unable to retrieve property 'attributes' of " + object.getClass(), exception2);
            }
            if (object2 instanceof Map) {
                for (Map.Entry entry : ((Map)object2).entrySet()) {
                    this.appendString(stringBuffer, entry.getKey() == null ? "null" : entry.getKey().toString(), entry.getValue() == null ? "null" : entry.getValue().toString());
                }
            }
        }
        stringBuffer.append(LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    private void appendMap(StringBuffer stringBuffer, String string, Map<String, String> map) {
        if (string.endsWith("s")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.targetVersion.isAtLeast(AsteriskVersion.ASTERISK_1_2)) {
            this.appendMap12(stringBuffer, string, map);
            return;
        }
        this.appendMap10(stringBuffer, string, map);
    }

    private void appendMap10(StringBuffer stringBuffer, String object, Map<String, String> object2) {
        stringBuffer.append((String)object);
        stringBuffer.append(": ");
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            object2 = (Map.Entry)object.next();
            stringBuffer.append((String)object2.getKey());
            stringBuffer.append("=");
            if (object2.getValue() != null) {
                stringBuffer.append((String)object2.getValue());
            }
            if (!object.hasNext()) continue;
            stringBuffer.append("|");
        }
        stringBuffer.append(LINE_SEPARATOR);
    }

    private void appendMap12(StringBuffer stringBuffer, String string, Map<String, String> object) {
        for (Map.Entry entry : object.entrySet()) {
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append("=");
            if (entry.getValue() != null) {
                stringBuffer.append((String)entry.getValue());
            }
            stringBuffer.append(LINE_SEPARATOR);
        }
    }

    private void appendString(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(string2);
        stringBuffer.append(LINE_SEPARATOR);
    }

    private void appendUserEvent(StringBuffer stringBuffer, UserEvent object) {
        String string = object.getClass().getName();
        object = string.substring(string.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (((String)object).endsWith("event")) {
            object = ((String)object).substring(0, ((String)object).length() - 5);
        }
        this.appendString(stringBuffer, "UserEvent", (String)object);
    }

    private void appendGetters(StringBuffer stringBuffer, Object object, Set<String> set) {
        for (Map.Entry<String, Method> exception : ReflectionUtil.getGetters(object.getClass()).entrySet()) {
            Object object2;
            String string = exception.getKey();
            Method method = exception.getValue();
            if (set.contains(string)) continue;
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (Exception exception2) {
                this.logger.error("Unable to retrieve property '" + string + "' of " + object.getClass(), exception2);
                continue;
            }
            if (object2 == null || object2 instanceof Class) continue;
            String string2 = this.mapToAsterisk(method);
            if (object2 instanceof Map) {
                this.appendMap(stringBuffer, string2, (Map)object2);
                continue;
            }
            if (object2 instanceof String) {
                this.appendString(stringBuffer, string2, (String)object2);
                continue;
            }
            this.appendString(stringBuffer, string2, object2.toString());
        }
    }

    private String mapToAsterisk(Method method) {
        Object object = method.getAnnotation(AsteriskMapping.class);
        if (object != null) {
            return object.value();
        }
        object = this.determineSetterName(method.getName());
        try {
            object = method.getDeclaringClass().getDeclaredMethod((String)object, method.getReturnType()).getAnnotation(AsteriskMapping.class);
            if (object != null) {
                return object.value();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        String string = this.determineFieldName(method.getName());
        try {
            object = method.getDeclaringClass().getDeclaredField(string).getAnnotation(AsteriskMapping.class);
            if (object != null) {
                return object.value();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return string.toLowerCase(Locale.US);
    }

    String determineSetterName(String string) {
        if (string.startsWith("get")) {
            return "set" + string.substring(3);
        }
        if (string.startsWith("is")) {
            return "set" + string.substring(2);
        }
        throw new IllegalArgumentException("Getter '" + string + "' doesn't start with either 'get' or 'is'");
    }

    String determineFieldName(String string) {
        if (string.startsWith("get")) {
            return this.lcFirst(string.substring(3));
        }
        if (string.startsWith("is")) {
            return this.lcFirst(string.substring(2));
        }
        if (string.startsWith("set")) {
            return this.lcFirst(string.substring(3));
        }
        throw new IllegalArgumentException("Accessor '" + string + "' doesn't start with either 'get', 'is' or 'set'");
    }

    String lcFirst(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        char c2 = string.charAt(0);
        return Character.toLowerCase(c2) + string.substring(1);
    }
}

