/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.internal.AbstractBuilder;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

class ResponseBuilderImpl
extends AbstractBuilder
implements ResponseBuilder {
    private static final Set<String> ignoredAttributes = new HashSet<String>(Arrays.asList("attributes", "proxyresponse", "__result__"));
    private static final String RESPONSE_KEY = "response";
    private static final String PROXY_RESPONSE_KEY = "proxyresponse";
    private static final String RESPONSE_TYPE_ERROR = "error";

    ResponseBuilderImpl() {
    }

    @Override
    public ManagerResponse buildResponse(Class<? extends ManagerResponse> serializable, Map<String, Object> map) {
        Object object = (String)map.get(RESPONSE_KEY);
        if (RESPONSE_TYPE_ERROR.equalsIgnoreCase((String)object)) {
            object = new ManagerError();
        } else if (serializable == null) {
            object = new ManagerResponse();
        } else {
            try {
                object = ((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                this.logger.error("Unable to create new instance of " + ((Class)serializable).getName(), exception);
                return null;
            }
        }
        this.setAttributes(object, map, ignoredAttributes);
        if (object instanceof CommandResponse) {
            CommandResponse commandResponse = (CommandResponse)object;
            serializable = new ArrayList();
            for (String string : ((String)map.get("__result__")).split("\n")) {
                if (string.equals("--END COMMAND--") || string.equals(" --END COMMAND--")) continue;
                serializable.add((String)string);
            }
            commandResponse.setResult((List<String>)((Object)serializable));
        }
        if (((ManagerResponse)object).getResponse() != null && map.get(PROXY_RESPONSE_KEY) != null) {
            ((ManagerResponse)object).setResponse((String)map.get(PROXY_RESPONSE_KEY));
        }
        ((ManagerResponse)object).setAttributes(new HashMap<String, Object>(map));
        return object;
    }
}

