/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AstState {
    public static final int AST_STATE_DOWN = 0;
    public static final int AST_STATE_RSRVD = 1;
    public static final int AST_STATE_OFFHOOK = 2;
    public static final int AST_STATE_DIALING = 3;
    public static final int AST_STATE_RING = 4;
    public static final int AST_STATE_RINGING = 5;
    public static final int AST_STATE_UP = 6;
    public static final int AST_STATE_BUSY = 7;
    public static final int AST_STATE_DIALING_OFFHOOK = 8;
    public static final int AST_STATE_PRERING = 9;
    private static final Map<String, Integer> inverseStateMap;
    private static final Pattern UNKNOWN_STATE_PATTERN;

    private AstState() {
    }

    public static Integer str2state(String string) {
        Matcher matcher;
        if (string == null) {
            return null;
        }
        Integer n2 = inverseStateMap.get(string);
        if (n2 == null && (matcher = UNKNOWN_STATE_PATTERN.matcher(string)).matches()) {
            try {
                n2 = Integer.valueOf(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unable to convert state '" + string + "' to integer representation", numberFormatException);
            }
        }
        return n2;
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Down", 0);
        hashMap.put("Rsrvd", 1);
        hashMap.put("OffHook", 2);
        hashMap.put("Dialing", 3);
        hashMap.put("Ring", 4);
        hashMap.put("Ringing", 5);
        hashMap.put("Up", 6);
        hashMap.put("Busy", 7);
        hashMap.put("Dialing Offhook", 8);
        hashMap.put("Pre-ring", 9);
        inverseStateMap = Collections.unmodifiableMap(hashMap);
        UNKNOWN_STATE_PATTERN = Pattern.compile("^Unknown \\((\\d+)\\)$");
    }
}

