/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.asteriskjava.util.Log;

public class JavaLoggingLog
implements Log {
    private final Logger log;

    public JavaLoggingLog(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getName());
    }

    @Override
    public void debug(Object object) {
        StackTraceElement stackTraceElement = this.getInvokerSTE();
        if (stackTraceElement != null) {
            this.log.logp(Level.FINE, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), object.toString());
            return;
        }
        this.log.fine(object.toString());
    }

    @Override
    public void info(Object object) {
        StackTraceElement stackTraceElement = this.getInvokerSTE();
        if (stackTraceElement != null) {
            this.log.logp(Level.INFO, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), object.toString());
            return;
        }
        this.log.info(object.toString());
    }

    @Override
    public void warn(Object object) {
        StackTraceElement stackTraceElement = this.getInvokerSTE();
        if (stackTraceElement != null) {
            this.log.logp(Level.WARNING, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), object.toString());
            return;
        }
        this.log.warning(object.toString());
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        StackTraceElement stackTraceElement = this.getInvokerSTE();
        if (stackTraceElement != null) {
            this.log.logp(Level.WARNING, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), object.toString(), throwable);
            return;
        }
        this.log.log(Level.WARNING, object.toString(), throwable);
    }

    @Override
    public void error(Object object) {
        StackTraceElement stackTraceElement = this.getInvokerSTE();
        if (stackTraceElement != null) {
            this.log.logp(Level.SEVERE, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), object.toString());
            return;
        }
        this.log.severe(object.toString());
    }

    @Override
    public void error(Object object, Throwable throwable) {
        StackTraceElement stackTraceElement = this.getInvokerSTE();
        if (stackTraceElement != null) {
            this.log.logp(Level.SEVERE, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), object.toString(), throwable);
            return;
        }
        this.log.log(Level.SEVERE, object.toString(), throwable);
    }

    private StackTraceElement getInvokerSTE() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        if (stackTraceElementArray.length > 2) {
            return stackTraceElementArray[2];
        }
        return null;
    }
}

