/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.FileTrace;
import org.asteriskjava.util.internal.Trace;

public class SocketConnectionFacadeImpl
implements SocketConnectionFacade {
    public static final Pattern CRNL_PATTERN = Pattern.compile("\r\n");
    public static final Pattern NL_PATTERN = Pattern.compile("\n");
    private Socket socket;
    private Scanner scanner;
    private BufferedWriter writer;
    private Trace trace;
    private static final int MAX_SOCKET_READ_TIMEOUT_MILLIS = 4200000;

    public SocketConnectionFacadeImpl(String string, int n2, boolean bl2, int n3, int n4) {
        this(string, n2, bl2, n3, n4, CRNL_PATTERN);
    }

    public SocketConnectionFacadeImpl(String string, int n2, boolean bl2, int n3, int n4, Pattern pattern) {
        Socket socket = bl2 ? SSLSocketFactory.getDefault().createSocket() : SocketFactory.getDefault().createSocket();
        socket.setSoTimeout(n4);
        socket.connect(new InetSocketAddress(string, n2), n3);
        this.initialize(socket, pattern);
        if (System.getProperty("org.asteriskjava.trace", "false").equalsIgnoreCase("true")) {
            this.trace = new FileTrace(socket);
        }
    }

    SocketConnectionFacadeImpl(Socket socket) {
        socket.setSoTimeout(4200000);
        this.initialize(socket, NL_PATTERN);
    }

    private void initialize(Socket closeable, Pattern pattern) {
        this.socket = closeable;
        Closeable closeable2 = closeable.getInputStream();
        closeable = closeable.getOutputStream();
        closeable2 = new BufferedReader(new InputStreamReader((InputStream)closeable2));
        this.scanner = new Scanner((Readable)((Object)closeable2));
        this.scanner.useDelimiter(pattern);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable));
    }

    @Override
    public String readLine() {
        String string;
        try {
            string = this.scanner.next();
        }
        catch (IllegalStateException illegalStateException) {
            if (this.scanner.ioException() != null) {
                throw this.scanner.ioException();
            }
            throw new IOException("No more lines available: " + illegalStateException.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.scanner.ioException() != null) {
                throw this.scanner.ioException();
            }
            throw new IOException("No more lines available: " + noSuchElementException.getMessage());
        }
        if (this.trace != null) {
            this.trace.received(string);
        }
        return string;
    }

    @Override
    public void write(String string) {
        this.writer.write(string);
        if (this.trace != null) {
            this.trace.sent(string);
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.socket.close();
        this.scanner.close();
        if (this.trace != null) {
            this.trace.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socket.getPort();
    }
}

